const urlLocation = location.origin;
// const urlLocation = 'http://localhost:3939';
const apiUrl = '/dm/api/v1/';

/* types of devices icons */
const iconDoc = `<span class='printer type-icon'></span>`;
const iconFis = `<span class='fiscal type-icon'></span>`;
const iconPay = `<span class='card type-icon'></span>`;
const iconScl = `<span class='scales type-icon'></span>`;

/* flags of device type for filtering models list*/
const isDocFlag = document.getElementById('is_doc');
const isFisFlag = document.getElementById('is_fis');
const isWeightFlag = document.getElementById('is_weight');
const isPayFlag = document.getElementById('is_pay');

let selectedManuf = false;
let searchManufText = false;
let searchModelText = false;

/* nodes */
const devicesNode = document.getElementById('devices'); // tbody for list of devices
const modelsListNode = document.getElementById('models-list').querySelector('.content-box');
const manufacturersListNode = document.getElementById('manufacturers-list').querySelector('.content-box');
const searchManufInputNode = document.getElementById('manuf-search-input');
const searchModelsInputNode = document.getElementById('model-search-input');
const clearManufListNode = document.getElementById('clear-manuf-list');
const clearModelsListNode = document.getElementById('clear-model-list');
const actionButtonsContainer = document.getElementById('action-buttons-container');

const modelIdInputNode = document.getElementById('model_id'); // model id value for create a new device
const devCodeInputNode = document.getElementById('dev_code'); // new device name










const createNewDevicePrevStepButton = document.getElementById('createNewDevicePrevStep');
const createNewDeviceNextStepButton = document.getElementById('createNewDeviceNextStep');

let newDeviceType = '';
let createNewDeviceStep = 1;
let printersList = [];
let terminalsList = [];
let bankProtocols = [];
let printerProtocols = [];
let modelId = '';
















let models, manufs, modelsArrLength;

function setDeviceTypeIcon ({is_doc, is_fis ,is_pay ,is_weight}) {
	let icons = '';
	if (is_pay) {
		icons += iconPay;
	}
	if(is_doc){
		icons += iconDoc;		
	}
	if(is_fis){
		icons += iconFis;		
	}
	if(is_weight){
		icons += iconScl;		
	}
	return icons;
}
/* action cell */
function setActionsCell(dev_code, dev_id){
	if (window.screen.width < 768) {
		return `<td class="actions-cell"><span class="button-text button" onclick="goToDevicePage('${dev_id}')">${getTranslation('common.edit')}</span><span class="button-text button red" onclick="askDeleteDevice('${dev_code}')">${getTranslation('common.delete')}</span></td>`;
	}	
	return `<td class="actions-cell"><span class="edit" onclick="goToDevicePage('${dev_id}')"></span><span class="delete" onclick="askDeleteDevice('${dev_code}')"></span></td>`;
}

function fillDeviceListTable(deviceList) {
	/* clear table before getting new data */
	devicesNode.innerHTML = '';

	/*loop for filling table with actual devices*/
	for (let device of deviceList) {
		const interfaceIcon = setInterfaceIcon(device.intf.capt);
		const deviceTypeIcon = setDeviceTypeIcon(device);
		const actionsCell = setActionsCell(device.dev_code, device.dev_id);
		const trNode = `<tr class="device-row">
        <td class="code" onclick="toggleTableRowClass(this)"><span class="visible-xs">${getTranslation('deviceList.table.name')}:</span>${
					device.dev_code
				}</td>
        <td class="type"><span class="visible-xs">${getTranslation('deviceList.table.type')}:</span>${deviceTypeIcon}</td>
        <td class="model_name"><span class="visible-xs">${getTranslation('deviceList.table.model')}:</span>${
					device.model.capt
				} / ${device.prot.capt}</td>
        <td><span class="visible-xs">${getTranslation('deviceList.table.interface')}:</span><div class="interface">${interfaceIcon}<span>${device.intf_info}</span></div></td>${actionsCell}
        </tr>`;
		devicesNode.insertAdjacentHTML('beforeend', trNode);
	}
}

function getDeviceList() {
	toggleLoader();


	fetch(`${urlLocation}/dm/api/v3/devices`)
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			const devices = result.devices;
			let serverAlias = result.server_alias;
			let headerElement = document.getElementById("server_alias");

			if (serverAlias === "") {
				headerElement.textContent = "POS Пристрої";
			} else {
				headerElement.textContent = `POS Пристрої: ${serverAlias}`;
			}
			if(devices && devices.length){
				fillDeviceListTable(devices);
				!document.getElementById('empty-list').classList.contains('hidden') && document.getElementById('empty-list').classList.add('hidden');
				document.querySelector('.content.device-list-page').classList.remove('hidden');
			}else{
				document.getElementById('empty-list').classList.remove('hidden');
				document.querySelector('.content.device-list-page').classList.add('hidden');
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}

async function getModelAndManufList() {
	const sysInfo = await getSysInfo();
	fetch(`${urlLocation}${apiUrl}registry/devices`)
		.then((response) => response.json())
		.then(async (result) => {
			manufs = result.manufs;
			models = result.models;

			if (sysInfo.platform !== 'Android') {
				document.getElementById('t2p-label').classList.add('hidden');
			}

			generateModelsList();
			generateManufacturersList();
		})
		.catch(function (error) {
			console.log(`Request failed: ${error}`);
		});
}

function generateManufacturersList(removeSelected) {

	if (!manufs || !manufs.length) return null;
	if(removeSelected){
		clearSearchText('manuf'); clearSearchText('model');
	}
	

	manufacturersListNode.innerHTML = '';
	/*filtered list*/
	const manufsArr = manufs.filter(filterManufs);
	searchManufInputNode.value.length ? clearManufListNode.classList.remove('hidden') : clearManufListNode.classList.add('hidden');

	/* generate manufs list */
	if(modelsArrLength){
		for (let manufacture of manufsArr) {
		const manufactureItemNode = `<div id="manuf-${manufacture.manuf.id}" onClick="setManufId('${manufacture.manuf.id}', '${manufacture.manuf.capt}');">${manufacture.manuf.capt}</div>`;
		manufacturersListNode.insertAdjacentHTML('beforeend', manufactureItemNode);
		}
	}

}
function filterManufs({
	is_doc,
	is_fis,
	is_pay,
	is_weight,
	manuf: {capt}
}) {
	/* check if flag of device type is switched*/
	const ruleIsDoc = isDocFlag.checked ? is_doc === true : true;
	const ruleIsFis = isFisFlag.checked  ? is_fis === true : true;
	const ruleIsWeight = isWeightFlag.checked ? is_weight === true : true;
	const ruleIsPay = isPayFlag.checked  ? is_pay === true : true;

	// check if search text was entered, not selected from manufs list
	const ruleSearchManuf = searchManufInputNode.value && !searchManufInputNode.classList.contains('isSet') ? capt.includes(searchManufInputNode.value) : true;

	return ruleIsDoc && ruleIsFis && ruleIsWeight && ruleIsPay && ruleSearchManuf;
}
function setManufId(manufId, manufCapt){
	for(manufItemNode of manufacturersListNode.querySelectorAll('div')){
		manufItemNode.classList.remove('active');
	}

	searchManufInputNode.value = manufCapt;
	searchManufInputNode.disabled = true;
	searchManufInputNode.classList.add('isSet');

	clearManufListNode.classList.remove('hidden');

	manufId && document.getElementById(`manuf-${manufId}`).classList.add('active');
	selectedManuf = manufId;
	generateModelsList();
}
let devCodeToRemove;
function askDeleteDevice(dev_code){
	showModal('delete-device');
	devCodeToRemove = dev_code;
}
function removeDevice(){
	toggleLoader();
	fetch(`${urlLocation}/dm/api/v3/device?dev_name=${devCodeToRemove}`, {
		method: 'DELETE',
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				callTostSnackbar(result.errortxt);
				// document.getElementById('error-text-action-ask').innerHTML =
				// 	result.errortxt;
			} else {
				hideModal('delete-device');
				callTostSnackbar(getTranslation('common.deleted'));
				getDeviceList();
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function generateModelsList() {
	if (!models || !models.length) return null;

	/* clear models list before filtering */
	modelsListNode.innerHTML = '';

	searchModelsInputNode.value.length ? clearModelsListNode.classList.remove('hidden') : clearModelsListNode.classList.add('hidden');

	/*filtered list*/
	const modelsArr = models.filter(filterModels);
	modelsArrLength = modelsArr.length;

	/* generate models list */
	for (let modelArr of modelsArr) {
		const deviceTypeIcon = setDeviceTypeIcon(modelArr);
		const modelItemNode = `<div id="model-${modelArr.model.id}" onClick="setModel('${modelArr.model.id}', '${modelArr.model.capt}');">${modelArr.model.capt}${deviceTypeIcon}</div>`;
		modelsListNode.insertAdjacentHTML('beforeend', modelItemNode);
	}
}
function filterModels({
	is_doc,
	is_fis,
	is_pay,
	is_weight,
	model: {capt},
	manuf: {id}
}) {
	/* check if flag of device type is switched*/
	const ruleIsDoc = isDocFlag.checked ? is_doc === true : true;
	const ruleIsFis = isFisFlag.checked  ? is_fis === true : true;
	const ruleIsWeight = isWeightFlag.checked ? is_weight === true : true;
	const ruleIsPay = isPayFlag.checked  ? is_pay === true : true;

	const ruleSearchModels = searchModelsInputNode.value ? capt.includes(searchModelsInputNode.value) : true;

	const ruleManufId = selectedManuf ? id === selectedManuf : true;
	
	return ruleIsDoc && ruleIsFis && ruleIsWeight && ruleIsPay && ruleManufId && ruleSearchModels;
}
function setModel(modelId, modelCapt){
	for(modelItemNode of modelsListNode.querySelectorAll('div')){
		modelItemNode.classList.remove('active');
	}
	searchModelsInputNode.value = modelCapt;
	searchModelsInputNode.disabled = true;

	clearModelsListNode.classList.remove('hidden');
	modelIdInputNode.value = modelId;
	removeErrorClass(searchModelsInputNode, true);
	modelId && document.getElementById(`model-${modelId}`).classList.add('active');
}
function clearSearchText(entity){
	if(entity === 'manuf'){
		searchManufInputNode.disabled = false;
		searchManufInputNode.value = '';
		searchManufInputNode.classList.remove('isSet');
		selectedManuf = false;
	}
	if(entity === 'model'){
		searchModelsInputNode.disabled = false;
		searchModelsInputNode.value = '';
		modelIdInputNode.value = '';
	}
	generateManufacturersList();
	generateModelsList();
}

function removeErrorClass(elem, clicked){
	if(clicked){
		elem.closest('.line.error') && elem.closest('.line.error').classList.remove('error');
	}
	elem.onfocus = function(e){
		elem.closest('.line.error').classList.remove('error');
	}
}
document.getElementById('log-date-from').onclick = function (e) {
	e.preventDefault();
	e.cancelBubble = true;
	this.select();
	_Calendar.lcs(this);
};
document.getElementById('log-date-to').onclick = function (e) {
	e.preventDefault();
	e.cancelBubble = true;
	this.select();
	_Calendar.lcs(this);
};
(function () {
	document.getElementById('log-date-to').value = _Calendar.addnull(
		_Calendar.now.getDate(),
		_Calendar.now.getMonth() + 1,
		_Calendar.now.getFullYear()
	);
	document.getElementById('log-date-from').value = _Calendar.addnull(
		_Calendar.now.getDate(),
		_Calendar.now.getMonth() + 1,
		_Calendar.now.getFullYear()
	);
})();
document.zipLogs.onsubmit = function (e) {
	e.preventDefault();
	toggleLoader();
	let zip_logs_data = new FormData(this);
	let object = {};
	zip_logs_data.forEach((value, key) => {
		object[key] = value;
	});
	if (object.all_logs) {
		object.date_begin = '';
		object.date_end = '';
	}
	fetch(
		`${urlLocation}${apiUrl}ziplogs?date_begin=${object.date_begin}&date_end=${object.date_end}`,
		{
			method: 'GET',
		}
	)
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				document
					.getElementById('error-text-zip-logs')
					.classList.remove('hidden');
				document.getElementById('error-text-zip-logs').innerText =
					result.errortxt;
				callTostSnackbar(result.errortxt);
			} else {
				callTostSnackbar(getTranslation('common.downloaded'));
				hideModal('zip-logs-modal');
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
};
function goToDevicePage(dev_id){
	window.location.href = `./devicedetail.html?dev_id=${dev_id}`;
}

getDeviceList();
getModelAndManufList();













function generateSelect(
	parentNodeId,
	nodeId,
	optionsData,
	selected = "",
	onChange
  ) {
	/*get parent div*/
	const parentNode = document.getElementById(parentNodeId);
	parentNode.classList.remove("hidden");
  
	const parentListCont = parentNode.querySelector("div");
	parentListCont.innerHTML = ""; //clear data
  
	const selectList = document.createElement("select");
  
	selectList.id = nodeId;
	selectList.name = nodeId;
	onChange && (selectList.onchange = onChange);
  
	for (let optionData of optionsData) {
	  let newOption = (selectList.options[selectList.options.length] = new Option(
		optionData.capt,
		optionData.id
	  ));
	  if (nodeId === "intf") {
		newOption.classList.add(optionData.capt.toLowerCase());
	  }
	}

	selected && selected.id && (selectList.value = selected.id);
	parentListCont.appendChild(selectList);
}

createNewDevicePrevStepButton.addEventListener('click', (e) => {
	e.preventDefault();

	if (createNewDeviceStep === 1) {
		closeAddDeviceModal();
	} else {
		createNewDeviceStep = 1;

		const steps = document.querySelectorAll('.step');
		steps.item(0).classList.add('activeStep');
		steps.item(1).classList.remove('activeStep');

		document.querySelector('.createNewDeviceFirstStep').classList.remove('hidden');
		document.querySelector('.newDeviceOther').classList.add('hidden');
		document.querySelector('.newDevicePrinter').classList.add('hidden');
		document.querySelector('#connected-printers-container').classList.add('hidden');
		document.querySelector('#ethernet-settings-container').classList.add('hidden');
		document.querySelector('#terminal-ethernet-settings-container').classList.add('hidden');
		document.querySelector('#terminal-tcpserver-settings-container').classList.add('hidden');
		document.querySelector('#terminal-com-settings-container').classList.add('hidden');
		document.querySelector('#bluetooth-settings-container').classList.add('hidden');
		document.querySelector('#com-settings-container').classList.add('hidden');
		document.querySelector('.additional-printer-settings').classList.add('hidden');
		document.querySelector('.newDeviceTerminal').classList.add('hidden');
		document.querySelector('.newDeviceT2p').classList.add('hidden');

		createNewDeviceNextStepButton.textContent = 'Наступний крок';
	}
});

createNewDeviceNextStepButton.addEventListener('click', (e) => {
	e.preventDefault();

	if (createNewDeviceStep === 1) {
		createNewDeviceStep = 2;
		
		const steps = document.querySelectorAll('.step');
		steps.item(0).classList.remove('activeStep');
		steps.item(1).classList.add('activeStep');
		createNewDeviceNextStepButton.textContent = 'Створити';

		if (newDeviceType === 'printer') {
			document.querySelector('.createNewDeviceFirstStep').classList.add('hidden');
			document.querySelector('.newDevicePrinter').classList.remove('hidden');
			modelId = printersList[0]?.model?.id;


			fetch(`${urlLocation}/dm/api/v3/registry/prots?model_id=${printersList[0]?.model?.id}`)
				.then(res => res.json())
				.then(({ prots }) => {
					printerProtocols = prots;

					generateSelect(
						"interface-container",
						"interface", 
						prots[0].intfs.map(interface => ({
							id: interface.intf.id,
							capt: interface.intf.capt
						})),
						{ id: prots[0].intfs[1].intf.id }
					);

					if (prots[0].intfs[1].intf.capt === 'Ethernet') {
						document.querySelector('#ethernet-settings-container').classList.remove('hidden');
					} else if (prots[0].intfs[1].intf.capt === 'COM') {
						document.querySelector('#com-settings-container').classList.remove('hidden');
					} else if (prots[0].intfs[1].intf.capt === 'Bluetooth') {
						document.querySelector('#bluetooth-settings-container').classList.remove('hidden');
					}

					document.querySelector('#interface').addEventListener('change', interfaceChangeHandler);
			});


			generateSelect(
				"printer-settings-container",
				"printer-settings", 
				[
					{ id: "58", capt: '58мм' },
					{ id: "80", capt: '80мм' },
					{ id: "manual", capt: 'Вручну' },
				],
				{ id: '58' }
			);

			document.querySelector('#printer-settings').addEventListener('change', printerSettingsChangeHandler);
		} else if (newDeviceType === 'terminal') {
			document.querySelector('.createNewDeviceFirstStep').classList.add('hidden');
			document.querySelector('.newDeviceTerminal').classList.remove('hidden');

			generateSelect(
				"bank-container",
				"bank",
				terminalsList.map(({ model }) => model),
				{ id: terminalsList[0]?.model?.id ?? '' }
			);

			modelId = terminalsList[0]?.model?.id; 

			fetch(`${urlLocation}/dm/api/v3/registry/prots?model_id=${terminalsList[0]?.model?.id}`)
				.then(res => res.json())
				.then(({ prots }) => {
					bankProtocols = prots;
					generateSelect(
						"terminal-protocol-container",
						"terminal-prot",
						prots.map(protocol => ({
							id: protocol.prot.id,
							capt: protocol.prot.capt
						})),
						{ id: prots[0].prot.id }
					);
					if (prots.length > 1) {
						document.getElementById('terminal-protocol-container').classList.remove('hidden');
						document.querySelector('#terminal-prot').addEventListener('change', protChangeHandler);
					} else {
						document.getElementById('terminal-protocol-container').classList.add('hidden');
					}

					generateSelect(
						"terminal-interface-container",
						"terminal-interface", 
						prots[0].intfs.map(interface => ({
								id: interface.intf.id,
								capt: interface.intf.capt
							
						})),
						{ id: prots[0].intfs[0].intf.id }
					);

					if (prots[0].intfs[0].intf.capt === 'Ethernet') {
						document.querySelector('#terminal-ethernet-settings-container').classList.remove('hidden');
					} else if (prots[0].intfs[0].intf.capt === 'COM') {
						document.querySelector('#terminal-com-settings-container').classList.remove('hidden');
					} else if (prots[0].intfs[0].intf.capt === 'TCP_Server') {
						document.querySelector('#terminal-tcpserver-settings-container').classList.remove('hidden');
					}

					document.querySelector('#terminal-interface').addEventListener('change', terminalInterfaceChangeHandler);
			});

			document.querySelector('#bank').addEventListener('change', bankChangeHandler);

		} else if (newDeviceType === 't2p') {
			document.querySelector('.createNewDeviceFirstStep').classList.add('hidden');
			document.querySelector('.newDeviceT2p').classList.remove('hidden');

		} else if (newDeviceType === 'other') {
			document.querySelector('.createNewDeviceFirstStep').classList.add('hidden');
			document.querySelector('.newDeviceOther').classList.remove('hidden');
		}
	} else {
		if (newDeviceType === 'printer') {
			let intf_id = '';
			let prot_id = '';
			let prot_capt = '';

			const printerInterface = document.getElementById('interface').value;

			printerProtocols.forEach(({ prot, intfs }) => {
				let protocolFounded = false;

				intfs.forEach(({ intf }) => {
					if (intf.id === printerInterface) {
						protocolFounded = true;
						
						intf_id = intf.id;
						prot_capt = intf.capt;
					}
				})

				if (protocolFounded) {
					prot_id = prot.id;
				}
			});

			const getIntfInfo = () => {
				if (prot_capt === 'COM') {
					return document.getElementById('com').value;
				} else if (prot_capt === 'Ethernet') {
					return document.getElementById('ip').value;
				}  else if (prot_capt === 'Bluetooth') {
					return document.getElementById('bluetooth').value;
				} else if (prot_capt === 'USB') {
					return document.getElementById('printer-name').value;
				}

				return '';
			};

			const getIntfInfo1 = () => {
				if (prot_capt === 'COM') {
					return document.getElementById('com-speed').value;
				}

				return '';
			};

			const getLineWidth = () => {
				const printerSettingsValue = document.getElementById('printer-settings').value;

				if (printerSettingsValue === '58') {
					return 32;
				}

				if (printerSettingsValue === '80') {
					return 48;
				}

				return +document.getElementById('symbols_count').value;
			};

			const getPixelWidth = () => {
				const printerSettingsValue = document.getElementById('printer-settings').value;

				if (printerSettingsValue === 'manual') {
					return +document.getElementById('qr_size').value
				}

				return 12;
			};
			
			const body = JSON.stringify({
				dev_code: devCodeInputNode.value,
				model_id: modelId,
				doc_params: {
					line_width: getLineWidth(),
					pixel_width: getPixelWidth(),
					codepage: { id: "73", capt: "73" },
					imgMode: true,
					open_drawer: true,
				},
				fis_params: null,
				intf_id,
				prot_id,
				intf_info: getIntfInfo(),
				intf_info1: getIntfInfo1()
			});
			toggleLoader();

			fetch(`${urlLocation}/dm/api/v3/device`, 
				{ method: 'POST', body }
			)
			.then(res => res.json())
				.then(result => {
					toggleLoader();

					if (result.errortxt){
						callTostSnackbar(result.errortxt);
					} else {
						hideModal('add-device-modal');
						callTostSnackbar(getTranslation('common.created'));

						setTimeout(() => goToDevicePage(result.dev_id), 3000);
						getDeviceList();
					}
				})
				.catch(error => {
					toggleLoader();
					callTostSnackbar(`Request failed: ${error}`);
				});
		} else if (newDeviceType === 'terminal') {
			let intf_id = '';
			let prot_id = '';
			let prot_capt = '';

			const terminalProt = document.getElementById('terminal-prot').value;
			const terminalInterface = document.getElementById('terminal-interface').value;

			bankProtocols.forEach(({ prot, intfs }) => {
				let protocolFounded = false;

				intfs.forEach(({ intf }) => {
					if (intf.id === terminalInterface && prot.id === terminalProt) {
						protocolFounded = true;
						
						intf_id = intf.id;
						prot_capt = intf.capt;
					}
				})

				if (protocolFounded) {
					prot_id = prot.id;
				}
			});

			const body = JSON.stringify({
				dev_code: devCodeInputNode.value,
				model_id: modelId,
				doc_params: {
					line_width: 32,
					pixel_width: 12
				},
				fis_params: null,
				pay_params: {
					bank_name: document.getElementById('terminal-bankname').value,
					commision_percent: +document.getElementById('acquirer-commission').value,
					search_intf_on_error: document.getElementById('search-intf-on-error-value').checked
				},
				intf_id,
				prot_id,
				intf_info: prot_capt === 'COM'
					? document.getElementById('terminal-com').value
					: prot_capt === 'TCP_Server'
						? document.getElementById('terminal-tcpserver-port').value
						: document.getElementById('terminal-ethernet-ip').value,
				intf_info1: prot_capt === 'COM'
					? document.getElementById('terminal-com-speed').value
					: ''
			});


			toggleLoader();

			fetch(`${urlLocation}/dm/api/v3/device`, {
					method: 'POST',
					body
				})
				.then(res => res.json())
				.then(result => {
					toggleLoader();

					if (result.errortxt){
						callTostSnackbar(result.errortxt);
					} else {
						hideModal('add-device-modal');
						callTostSnackbar(getTranslation('common.created'));

						setTimeout(() => goToDevicePage(result.dev_id), 3000);
						getDeviceList();
					}
				})
				.catch(error => {
					toggleLoader();
					callTostSnackbar(`Request failed: ${error}`);
				});
		} else if (newDeviceType === 't2p') {
			const body = JSON.stringify({
				dev_code: devCodeInputNode.value,
				t2p_token: document.getElementById('t2p-token').value
			});


			toggleLoader();

			fetch(`${urlLocation}/dm/api/v3/device`, {
				method: 'POST',
				body
			})
				.then(res => res.json())
				.then(result => {
					toggleLoader();

					if (result.errortxt){
						callTostSnackbar(result.errortxt);
					} else {
						hideModal('add-device-modal');
						callTostSnackbar(getTranslation('common.created'));

						setTimeout(() => goToDevicePage(result.dev_id), 3000);
						getDeviceList();
					}
				})
				.catch(error => {
					toggleLoader();
					callTostSnackbar(`Request failed: ${error}`);
				});
		} else if (newDeviceType === 'other') {
			toggleLoader();

			fetch(`${urlLocation}${apiUrl}device`, {
				method: 'POST',
				body: JSON.stringify({
					dev_code: devCodeInputNode.value,
					model_id: modelIdInputNode.value,
				}),
			})
			.then(res => res.json())
			.then(result => {
				toggleLoader();

				if (result.errortxt){
					callTostSnackbar(result.errortxt);
				} else {
					hideModal('add-device-modal');
					callTostSnackbar(getTranslation('common.created'));

					setTimeout(() => goToDevicePage(result.dev_id), 3000);
					getDeviceList();
				}
			})
			.catch(error => {
				toggleLoader();
				callTostSnackbar(`Request failed: ${error}`);
			});
		}
	}
});

devCodeInputNode.addEventListener('keyup', (e) => {
	if (devCodeInputNode.value && newDeviceType) {
		createNewDeviceNextStepButton.removeAttribute('disabled');
		createNewDeviceNextStepButton.classList.remove('disabled');
	} else {
		createNewDeviceNextStepButton.setAttribute('disabled', true);
		createNewDeviceNextStepButton.classList.add('disabled');
	}
});

function changeDevType(dev_type) {
	newDeviceType = dev_type;

	if (devCodeInputNode.value) {
		createNewDeviceNextStepButton.removeAttribute('disabled');
		createNewDeviceNextStepButton.classList.remove('disabled');
	}
}

function closeAddDeviceModal() {
	createNewDeviceStep = 1;
	devCodeInputNode.value = '';
	
	const steps = document.querySelectorAll('.step');
	steps.item(0).classList.add('activeStep');
	steps.item(1).classList.remove('activeStep');
	
	createNewDeviceNextStepButton.setAttribute('disabled', true);
	createNewDeviceNextStepButton.classList.add('disabled');

	document.querySelector('.createNewDeviceFirstStep').classList.remove('hidden');
	document.querySelector('.newDeviceOther').classList.add('hidden');
	document.querySelector('.newDevicePrinter').classList.add('hidden');
	document.querySelector('#connected-printers-container').classList.add('hidden');
	document.querySelector('#ethernet-settings-container').classList.add('hidden');
	document.querySelector('#bluetooth-settings-container').classList.add('hidden');
	document.querySelector('#com-settings-container').classList.add('hidden');
	document.querySelector('.additional-printer-settings').classList.add('hidden');
	document.querySelector('.newDeviceTerminal').classList.add('hidden');
	document.querySelector('.newDeviceT2p').classList.add('hidden');

	createNewDeviceNextStepButton.textContent = 'Наступний крок';

	hideModal('add-device-modal');
}

function printerSettingsChangeHandler({ target: { value } }) {
	const additionalPrinterSettingsNode = document.querySelector('.additional-printer-settings');
	const symbolsCountNode = document.querySelector('#symbols_count');
	const qrSizeNode = document.querySelector('#qr_size');

	if (value === 'manual') {
		additionalPrinterSettingsNode.classList.remove('hidden');
	} else {
		additionalPrinterSettingsNode.classList.add('hidden');
		symbolsCountNode.value = '';
		qrSizeNode.value = '';		
	}
}

function interfaceChangeHandler({ target: { value } }) {
	document.querySelector('#connected-printers-container').classList.add('hidden');
	document.querySelector('#ethernet-settings-container').classList.add('hidden');
	document.querySelector('#com-settings-container').classList.add('hidden');
	document.querySelector('#bluetooth-settings-container').classList.add('hidden');

	let choosedProtocol = '';

	printerProtocols.forEach(({ intfs }) =>
		intfs.forEach(({ intf }) => {
			if (intf.id === value) {
				choosedProtocol = intf.capt;
			}
	}));

	if (choosedProtocol === 'USB') {
		fetch(`${urlLocation}/dm/printerlist?prot_id=${value}`)
			.then(res => res.json())
			.then(({ printers }) => {
				const printerNamesNode = document.getElementById('printer-names');

				printerNamesNode.innerHTML = '';

				printers.forEach(({ name }) => {
					const option = document.createElement('option');
					option.value = name;

					printerNamesNode.appendChild(option);
				});

			})

		document.querySelector('#connected-printers-container').classList.remove('hidden');
	} else if (choosedProtocol === 'Ethernet') {
		document.querySelector('#ethernet-settings-container').classList.remove('hidden');
	} else if (choosedProtocol === 'COM') {
		fetch(`${urlLocation}/dm/comlist`)
			.then(res => res.json())
			.then((ports) => {
				const comNamesNode = document.getElementById('com-ports');

				comNamesNode.innerHTML = '';

				ports.forEach((port) => {
					const option = document.createElement('option');
					option.value = port;

					comNamesNode.appendChild(option);
				});

			})
		document.querySelector('#com-settings-container').classList.remove('hidden');
	} else if (choosedProtocol === 'Bluetooth') {
		fetch(`${urlLocation}/dm/btlist`)
			.then(res => res.json())
			.then((btnames) => {
				const btNamesNode = document.getElementById('bt-names');

				btNamesNode.innerHTML = '';
				btnames.forEach((port) => {
					const option = document.createElement('option');
					option.value = port;

					btNamesNode.appendChild(option);
				});

			})
		document.querySelector('#bluetooth-settings-container').classList.remove('hidden');
	}
}

function terminalInterfaceChangeHandler({ target: { value } }) {
	document.querySelector('#terminal-com-settings-container').classList.add('hidden');
	document.querySelector('#terminal-ethernet-settings-container').classList.add('hidden');
	document.querySelector('#terminal-tcpserver-settings-container').classList.add('hidden');

	let choosedProtocol = '';

	bankProtocols.forEach(({ intfs }) =>
		intfs.forEach(({ intf }) => {
			if (intf.id === value) {
				choosedProtocol = intf.capt;
			}
	}));

	if (choosedProtocol === 'Ethernet') {
		document.querySelector('#terminal-ethernet-settings-container').classList.remove('hidden');
		document.getElementById('search-intf-on-error-container').classList.remove('hidden');
	} else if (choosedProtocol === 'COM') {
			fetch(`${urlLocation}/dm/comlist`)
				.then(res => res.json())
				.then((ports) => {
					const comNamesNode = document.getElementById('com-ports');

					comNamesNode.innerHTML = '';

					ports.forEach((port) => {
						const option = document.createElement('option');
						option.value = port;

						comNamesNode.appendChild(option);
						console.log(comNamesNode);
					});

				})
		document.querySelector('#terminal-com-settings-container').classList.remove('hidden');
		document.getElementById('search-intf-on-error-container').classList.remove('hidden');
	} else if (choosedProtocol === 'TCP_Server') {
		document.querySelector('#terminal-tcpserver-settings-container').classList.remove('hidden');
		document.getElementById('search-intf-on-error-container').classList.add('hidden');
	}
}

function bankChangeHandler({ target: { value } }) {
	modelId = value;

	fetch(`${urlLocation}/dm/api/v3/registry/prots?model_id=${value}`)
		.then(res => res.json())
		.then(({ prots }) => { 
			bankProtocols = prots;

			let choosedProtocol = prots[0].intfs[0].intf.capt;
			generateSelect(
				"terminal-protocol-container",
				"terminal-prot",
				prots.map(protocol => ({
					id: protocol.prot.id,
					capt: protocol.prot.capt
				})),
				{ id: prots[0].prot.id }
			);
			if (prots.length > 1) {
				document.getElementById('terminal-protocol-container').classList.remove('hidden');
				document.querySelector('#terminal-prot').addEventListener('change', protChangeHandler);
			} else {
				document.getElementById('terminal-protocol-container').classList.add('hidden');
			}

			generateSelect(
				"terminal-interface-container",
				"terminal-interface", 
				prots[0].intfs.map(interface => ({
						id: interface.intf.id,
						capt: interface.intf.capt
					
				})),
				{ id: prots[0].intfs[0].intf.id }
			);
			
			document.querySelector('#terminal-com-settings-container').classList.add('hidden');
			document.querySelector('#terminal-ethernet-settings-container').classList.add('hidden');
			document.querySelector('#terminal-tcpserver-settings-container').classList.add('hidden');


			if (modelId === '988f87a0-92f1-4fba-96f9-a7097874be7b' || modelId === '{988F87A0-92F1-4FBA-96F9-A7097874BE7B}' || modelId === '988F87A0-92F1-4FBA-96F9-A7097874BE7B') {
				document.querySelector('#terminal-bankname-container').classList.remove('hidden');
			} else {
				document.querySelector('#terminal-bankname-container').classList.add('hidden');
			}
			if (choosedProtocol === 'Ethernet') {
				document.querySelector('#terminal-ethernet-settings-container').classList.remove('hidden');
			} else if (choosedProtocol === 'COM') {
				document.querySelector('#terminal-com-settings-container').classList.remove('hidden');
			} else if (choosedProtocol === 'TCP_Server') {
				document.querySelector('#terminal-tcpserver-settings-container').classList.remove('hidden');
			}

			document.querySelector('#terminal-interface').addEventListener('change', terminalInterfaceChangeHandler);
	});
}

function protChangeHandler({ target: { value } }) {
	document.querySelector('#terminal-com-settings-container').classList.add('hidden');
	document.querySelector('#terminal-ethernet-settings-container').classList.add('hidden');
	document.querySelector('#terminal-tcpserver-settings-container').classList.add('hidden');

	let choosedProtocol = '';

	for (let i = 0; i < bankProtocols.length; i++) {
		if (bankProtocols[i].prot.id === value) {
			choosedProtocol = bankProtocols[i].intfs[0].intf.capt;
			generateSelect(
				"terminal-interface-container",
				"terminal-interface",
				bankProtocols[i].intfs.map(interface => ({
					id: interface.intf.id,
					capt: interface.intf.capt

				})),
				{ id: bankProtocols[i].intfs[0].intf.id }
			);
		}
	}

	if (choosedProtocol === 'Ethernet') {
		document.querySelector('#terminal-ethernet-settings-container').classList.remove('hidden');
	} else if (choosedProtocol === 'COM') {
		document.querySelector('#terminal-com-settings-container').classList.remove('hidden');
	} else if (choosedProtocol === 'TCP_Server') {
		document.querySelector('#terminal-tcpserver-settings-container').classList.remove('hidden');
	}
	document.querySelector('#terminal-interface').addEventListener('change', terminalInterfaceChangeHandler);

}

function findTerminal(isIntfCom, firstTerminal) {
	toggleLoader();
	let protocolId;
	let intfId = document.getElementById('terminal-interface').value;

	fetch(`${urlLocation}/dm/api/v3/registry/prots?model_id=${modelId}`)
		.then(res => res.json())
		.then(({ prots }) => {
			const terminalProt = document.getElementById("terminal-prot").value;
			bankProtocols = prots;
			bankProtocols.forEach(({ prot }) => {
					if (prot.id === terminalProt) {
						protocolId = prot.id;
					}
			});

			return fetch(`${urlLocation}/dm/api/v3/finddevices?dev_id=${modelId}&intf_id=${intfId}&prot_id=${protocolId}&findfirst=${firstTerminal}`);
		})
		.then(res => res.json())
		.then((result) => {
			if (result.res === 0) {
				toggleLoader();

				const data = result.findDevices;
				const buttonEthernetContainer = document.getElementById('button-ethernet-container');
				const buttonComContainer = document.getElementById('button-com-container');
			if (data.length === 1 || firstTerminal === 1){
				terminalSetIntfInfo(data[0].intf_info, isIntfCom);
			}
			else {
				if (isIntfCom) {
					document.getElementById('terminals-com-label').classList.remove('hidden');
				} else {
					document.getElementById('terminals-ethernet-label').classList.remove('hidden');
				}
				data.forEach((item, index) => {

					const button = document.createElement('div');
					const merchIdArray = item.merchList.map(item => item.id);

					if (isIntfCom) {
						button.textContent = `Порт: ${item.intf_info} Список мерчантів: ${merchIdArray.join("/")}`;
					} else {
						button.textContent = `IP: ${item.intf_info} Список мерчантів: ${merchIdArray.join("/")}`;
					}
					button.className = "find-terminals-button";
					button.onclick = function() {
						terminalSetIntfInfo(item.intf_info, isIntfCom);
					};

					if (isIntfCom) {
						buttonComContainer.appendChild(button);
					} else {
						buttonEthernetContainer.appendChild(button);
					}

				});
				callTostSnackbar(`Знайдено ${data.length} термінали`);
			}
			}
			else if (result.errortxt) {
				toggleLoader();
				callTostSnackbar(`${result.errortxt}`);
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Помилка: ${error}`);
		});
}

function terminalSetIntfInfo(intfInfo, isIntfCom) {
	if (isIntfCom){
		document.getElementById('terminal-com').value = intfInfo;
		callTostSnackbar(`Назву COM порту терміналу заповнено.`);
	}
	else {
		document.getElementById('terminal-ethernet-ip').value = intfInfo;
		callTostSnackbar(`IP адресу терміналу заповнено.`);
	}
}

function openAddDeviceModal() {
	fetch(`${urlLocation}/dm/api/v3/devices/registry`)
		.then(res => res.json())
		.then(({ models }) => {
			let ecsposids = ["{D42322D5-66F0-439D-BBDB-B680DDF5B90D}", "d42322d5-66f0-439d-bbdb-b680ddf5b90d", "D42322D5-66F0-439D-BBDB-B680DDF5B90D"];
			printersList = models.filter((m) => {
				return m.is_doc &&
					!m.is_other &&
					ecsposids.includes(m.model.id);
			});
			terminalsList = models.filter((m) => m.is_pay && !m.is_other);
		});

	showModal('add-device-modal');
}

async function getSysInfo() {
	return fetch(`${urlLocation}/dm/api/v1/sys_info`, {
		method: 'GET',
	})
		.then((response) => response.json())
		.then((result) => {
			return result;
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		});
}