const urlLocation = location.origin;
// const urlLocation = "http://localhost:3939";
const queryString = window.location.search;
const urlParams = new URLSearchParams(queryString);
const apiUrl = 'dm/vchasno-kasa/api/v1/';
const deviceId = urlParams.get('dev_id');
const terminalsContainer = document.querySelector('.terminals');
const printersContainer = document.querySelector('.printers');
const paytypesContainer = document.querySelector('.paytypes');
const autoCancelTransactionCheckbox = document.querySelector('#auto_cancel_transaction');
const merchantCodeInput = document.querySelector('#merchantCode');

function goBack() {
	window.history.back();
}

function goToLogs() {
	window.location = `${urlLocation}/dm/vchasno-kasa/logs.html?dev_id=${deviceId}`;
}

function toggleLoader() {
	document.getElementById('loader-box').classList.toggle('active');
}

function clearBatchSettings() {
	const selectedTerminal = document.querySelector('input[name="terminal"]:checked');
	const selectedPrinter = document.querySelector('input[name="printer"]:checked');

	autoCancelTransactionCheckbox.checked = false;
	merchantCodeInput.value = '';

	if (selectedPrinter) {
		selectedPrinter.value = false;
		selectedPrinter.checked = false;
	}

	if (selectedTerminal) {
		selectedTerminal.value = false;
		selectedTerminal.checked = false;
	}
}

function saveBatchSettings() {
	const selectedTerminal = document.querySelector('input[name="terminal"]:checked');
	const selectedPrinter = document.querySelector('input[name="printer"]:checked');
	const paytypeCheckboxes = document.querySelectorAll('.paytypes input[type="checkbox"]');
	const checkedPaytypes = [];
	paytypeCheckboxes.forEach(checkbox => {
		if (checkbox.checked) {
			checkedPaytypes.push(checkbox.value);
		}
	});


	const pck_trm = selectedTerminal ? selectedTerminal.value : '';
	const pck_prn = selectedPrinter ? selectedPrinter.value : '';
	const pck_TermPayTypes = checkedPaytypes.join('/');
	const pck_merchid = merchantCodeInput.value || '';
	const pck_autocancel = autoCancelTransactionCheckbox.checked;


	const json = JSON.stringify({ pck_trm, pck_prn, pck_TermPayTypes, pck_merchid, pck_autocancel });

	toggleLoader();

	fetch(`${urlLocation}/${apiUrl}prro/pack-mode?dev_id=${deviceId}`, { method: 'POST', body: json })
		.then(response => response.json())
		.then(result => {
			toggleLoader();
			callTostSnackbar(result.errortxt ? result.errortxt : 'Дані успішно змінено');
			setTimeout(() => goBack(), 3000);
		})
		.catch(error => {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});	
}

function fillTerminals(terminals, checkedId) {
	terminals.forEach(terminal => {
		const terminalNode = document.createElement('div');
		terminalNode.classList.add('batch-device');

		const isChecked = terminal.dev_id === checkedId ? 'checked' : '';
		const newTerminal = `
			<input name="terminal" type="radio" id="t${terminal.dev_id}" value=${terminal.dev_id} ${isChecked}>
			<label for="t${terminal.dev_id}" class="link">${terminal.dev_code}</label>
		`;

		terminalNode.insertAdjacentHTML('beforeend', newTerminal);
		terminalsContainer.appendChild(terminalNode);
	})
}

function fillPrinters(printers, checkedId) {
	printers.forEach(printer => {
		const printerNode = document.createElement('div');
		printerNode.classList.add('batch-device');

		const isChecked = printer.dev_id === checkedId ? 'checked' : '';
		const newPrinter = `
			<input name="printer" type="radio" id="p${printer.dev_id}" value=${printer.dev_id} ${isChecked}>
			<label for="p${printer.dev_id}" class="link">${printer.dev_code}</label>
		`;

		printerNode.insertAdjacentHTML('beforeend', newPrinter);
		printersContainer.appendChild(printerNode);
	})
}

function fillPayTypes(payTypes, checkedId) {
	toggleLoader();
	const checkedIdsArray = !checkedId ? [] : checkedId.split('/').map(id => parseInt(id));

			payTypes.forEach(paytype => {
				if (paytype.pay_id > 0 && paytype.pay_id !== 100) {
					const paytypeNode = document.createElement('div');
					paytypeNode.classList.add('batch-device');

					let isChecked = checkedIdsArray.includes(paytype.pay_id) ? 'checked' : '';
					if (paytype.pay_id === 2 && !checkedId) {
						isChecked = 'checked';
					}

					const newPaytype = `
               <input name="paytype" type="checkbox" id="p${paytype.pay_id}" value=${paytype.pay_id} ${isChecked}>
               <label for="p${paytype.pay_id}" class="link">${paytype.pay_id} ${paytype.caption}</label>
            `;

					paytypeNode.insertAdjacentHTML('beforeend', newPaytype);
					paytypesContainer.appendChild(paytypeNode);
				}
			});
}

function setupBatchSettings(currentDeviceInfo) {
	const { pck_trm, pck_prn, pck_TermPayTypes, pck_merchid, pck_autocancel } = currentDeviceInfo;

	toggleLoader(pck_trm);
	fetch(`${urlLocation}/${apiUrl}prro/groups?dev_id=${deviceId}`)
		.then(res => res.json())
		.then(result => {
			const payTypes = result.pay_types;
			const emptyPaytypesMessage = paytypesContainer.querySelector('p');

			if (payTypes.length) {
				fillPayTypes(payTypes, pck_TermPayTypes);
				emptyPaytypesMessage.classList.add('hidden');
			} else {
				emptyPaytypesMessage.classList.remove('hidden');
			}

			toggleLoader();
			return fetch(`${urlLocation}/dm/api/v3/devices`);
		})
		.then(res => res.json())
		.then(result => {
			const emptyTerminalsMessage = terminalsContainer.querySelector('p');
			const emptyPrintersMessage = printersContainer.querySelector('p');


			const { terminals, printers } = result.devices.reduce((acc, device) => {
				if (device.is_doc) acc.printers.push(device);
				if (device.is_pay) acc.terminals.push(device);

				return acc;
			}, { terminals: [], printers: [] });

			if (terminals.length) {
				fillTerminals(terminals, pck_trm);
				emptyTerminalsMessage.classList.add('hidden');
			} else {
				emptyTerminalsMessage.classList.remove('hidden');
			}

			if (printers.length) {
				fillPrinters(printers, pck_prn);
				emptyPrintersMessage.classList.add('hidden');
			} else {
				emptyPrintersMessage.classList.remove('hidden');
			}

			toggleLoader();
		})
		.catch(error => {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});


		autoCancelTransactionCheckbox.checked = pck_autocancel;
		merchantCodeInput.value = pck_merchid;
}

(function(){
	toggleLoader();

	fetch(`${urlLocation}/${apiUrl}prro/pack-mode?dev_id=${deviceId}`)
		.then(res => res.json())
		.then(result => {
			toggleLoader();

			if (result.errortxt) {
				callTostSnackbar(result.errortxt);
			} else {
				setupBatchSettings(result);
			}
		})
		.catch(error => {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
			setupBatchSettings({});
		});
})();
