// const urlLocation = 'http://localhost:3939';
const urlLocation = location.origin;
const apiUrl = '/dm/api/v1/';
const queryString = window.location.search;
const urlParams = new URLSearchParams(queryString);
const deviceId = urlParams.get('dev_id') ?? '';
let perPageVal;
let levelVal = 4, date_from, date_to;

/*nodes*/
const logsNode = document.getElementById('logs'); // tbody for list of devices

let Pagination = {
    code: '',
    // converting initialize data
    Extend: function (data) {
        data = data || {};
        Pagination.size = data.size || 300;
        Pagination.page = data.page || 1;
        Pagination.step = data.step || 3;
    },
    // add pages by number (from [s] to [f])
    Add: function (s, f) {
        for (var i = s; i < f; i++) {
            Pagination.code += `<div onclick="changePage(${i},${
                document.getElementById('perPage').value
            })">${i}</div>`;
        }
    },
    // add last page with separator
    Last: function () {
        Pagination.code += `<div>...</div><div onclick="changePage(${
            Pagination.size
        },${document.getElementById('perPage').value})">${
            Pagination.size
        }</div>`;
    },
    // add first page with separator
    First: function () {
        Pagination.code += `<div onclick="changePage(1,${
            document.getElementById('perPage').value
        })">1</div><div>...</div>`;
    },

    // --------------------
    // Handlers
    // --------------------

    // change page
    Click: function () {
        Pagination.page = +this.innerHTML;
        Pagination.Start();
    },

    // previous page
    Prev: function () {
        Pagination.page--;
        if (Pagination.page < 1) {
            Pagination.page = 1;
        }
        changePage(Pagination.page, document.getElementById('perPage').value);
        Pagination.Start();
    },

    // next page
    Next: function () {
        Pagination.page++;
        if (Pagination.page > Pagination.size) {
            Pagination.page = Pagination.size;
        }
        changePage(Pagination.page, document.getElementById('perPage').value);
        Pagination.Start();
    },

    // --------------------
    // Script
    // --------------------

    // binding pages
    Bind: function () {
        var div = Pagination.e.getElementsByTagName('div');
        for (var i = 0; i < div.length; i++) {
            if (+div[i].innerHTML === Pagination.page)
                div[i].className = 'current';
            div[i].addEventListener('click', Pagination.Click, false);
        }
    },

    // write pagination
    Finish: function () {
        Pagination.e.innerHTML = Pagination.code;
        Pagination.code = '';
        Pagination.Bind();
    },

    // find pagination type
    Start: function () {
        if (Pagination.size < Pagination.step * 2 + 6) {
            Pagination.Add(1, Pagination.size + 1);
        } else if (Pagination.page < Pagination.step * 2 + 1) {
            Pagination.Add(1, Pagination.step * 2 + 4);
            Pagination.Last();
        } else if (Pagination.page > Pagination.size - Pagination.step * 2) {
            Pagination.First();
            Pagination.Add(
                Pagination.size - Pagination.step * 2 - 2,
                Pagination.size + 1
            );
        } else {
            Pagination.First();
            Pagination.Add(
                Pagination.page - Pagination.step,
                Pagination.page + Pagination.step + 1
            );
            Pagination.Last();
        }
        Pagination.Finish();
    },

    // --------------------
    // Initialization
    // --------------------

    // binding buttons
    Buttons: function (e) {
        var nav = e.getElementsByTagName('div');
        nav[0].addEventListener('click', Pagination.Prev, false);
        nav[1].addEventListener('click', Pagination.Next, false);
    },

    // create skeleton
    Create: function (e) {
        var html = [
            '<div><i class="fas fa-angle-left"></i></div>', // previous button
            '<span class="pages"></span>', // pagination container
            '<div><i class="fas fa-angle-right"></i></div>', // next button
        ];

        e.innerHTML = html.join('');
        Pagination.e = e.getElementsByTagName('span')[0];
        Pagination.Buttons(e);
    },

    // init
    Init: function (e, data) {
        Pagination.Extend(data);
        Pagination.Create(e);
        Pagination.Start();
    },
};

function fillLogsListTable(logsList) {
	/* clear table before getting new data */
	logsNode.innerHTML = '';

	/*loop for filling table with actual logs*/
	for (let log of logsList) {   
            let date = `${log.dt.substr(6, 2)}.${log.dt.substr(
                4,
                2
            )}.${log.dt.substr(0, 4)}`;
            let time =  ` ${log.dt.substr(8, 2)}:${log.dt.substr(
                10,
                2
            )}:${log.dt.substr(12, 2)}`;
            let logInfo = log.info.replace(/</, '&lt;');
            logInfo = logInfo.replace(/>/, '&gt;'); 
		const trNode = `<tr class="log-row">
        <td class="code" onclick="toggleTableRowClass(this)"><span class="visible-xs">${getTranslation('settings.table.date')}:</span>${
            date
				}</td>
        <td class="type"><span class="visible-xs">${getTranslation('settings.table.time')}:</span>${time}</td>
        <td class="model_name"><span class="visible-xs">${getTranslation('settings.table.source')}:</span>${
            log.source
				}</td>
        <td class="protocol"><span class="visible-xs">${getTranslation('settings.table.device_name')}:</span>${
            log.device
                }</td>
                <td><span class="visible-xs">${getTranslation('settings.table.tag')}:</span>${log.tag}</td>
                <td><span class="visible-xs">${getTranslation('settings.table.level')}:</span>${log.level}</td>
                <td><span class="visible-xs">${getTranslation('settings.table.info')}:</span>${logInfo}</td>
        </tr>`;
		logsNode.insertAdjacentHTML('beforeend', trNode);
	}
}

function getLogs(extraParam) {
    toggleLoader();
    !extraParam && (extraParam = '');
    fetch(`${urlLocation}${apiUrl}eventlog?dev_id=${deviceId}${extraParam}`)
        .then((response) => response.json())
        .then((result) => {
            toggleLoader();
            const pagNode = document.getElementById('pagination');
            const perPageNode = document.getElementById('perPage');

            perPageNode.value = result.paging.page_size;
            pagNode.innerHTML = '';

            result.events && fillLogsListTable(result.events);
            if (result.paging.total_pages > 1) {
                for (i = 1; i <= result.paging.total_pages; i++) {
                    let curPage = '';
                    i === result.paging.page_number && (curPage = 'selected');
                    let pageNode = `<div onclick="changePage(${i},${perPageNode.value})" class="${curPage}">${i}</div>`;
                    //pagNode.insertAdjacentHTML('beforeend', pageNode);
                }
                Pagination.Init(document.getElementById('pagination'), {
                    size: result.paging.total_pages, // pages size
                    page: result.paging.page_number, // selected page
                    step: 2, // pages before and after current
                });
                //pagNode.page_number
            }
        })
        .catch(function (error) {
            toggleLoader();
            callTostSnackbar(`Request failed: ${error}`);
        });
}

function backToDev() {
    window.location.href = `./devicedetail.html?dev_id=${deviceId}`;
}
function backToDevList() {
    window.location.href = `./index.html`;
}
function changePage(page, count) {
    getLogs(`&pg_no=${page}&pg_cnt=${count}&level=${levelVal}&date_from=${date_from}&date_to=${date_to}`);
}
function changePerPage(count) {
    perPageVal = count;
    getLogs(`&date_from=${date_from}&date_to=${date_to}&pg_no=1&pg_cnt=${perPageVal}&level=${levelVal}`);
}
function changeLevel(level){
    levelVal = level;
    getLogs(`&date_from=${date_from}&date_to=${date_to}&pg_no=1&level=${levelVal}&pg_cnt=${perPageVal}`);
}
function changeDate( from, dateStr){
    console.log(dateStr);
    from && (date_from = formatDateForLogs(from,dateStr));
    !from && (date_to = formatDateForLogs(from,dateStr));
    getLogs(`&date_from=${date_from}&date_to=${date_to}&pg_no=1&level=${levelVal}&pg_cnt=${perPageVal}`);
}
document.getElementById('log-date-from').onclick = function (e) {
	e.preventDefault();
	e.cancelBubble = true;
	this.select();
	_Calendar.lcs(this);
};
document.getElementById('log-date-to').onclick = function (e) {
	e.preventDefault();
	e.cancelBubble = true;
	this.select();
	_Calendar.lcs(this);
};
(function () {
	document.getElementById('log-date-to').value = date_from = _Calendar.addnull(
		_Calendar.now.getDate(),
		_Calendar.now.getMonth() + 1,
		_Calendar.now.getFullYear()
	);
	document.getElementById('log-date-from').value = date_to = _Calendar.addnull(
		_Calendar.now.getDate(),
		_Calendar.now.getMonth() + 1,
		_Calendar.now.getFullYear()
    );
    date_from = formatDateForLogs(true,date_from);
    date_to = formatDateForLogs(false,date_to);
    getLogs(`&date_from=${date_from}&date_to=${date_to}`);
})();
function formatDateForLogs(from, dateStr){
    const dateArr = dateStr.split('.');
    if(from){
        return `${dateArr[2]}${dateArr[1]}${dateArr[0]}000000`
    }else{
        return `${dateArr[2]}${dateArr[1]}${dateArr[0]}235959`
    }
}
//date_from date_to YYYYMMDDHHMMSS