const urlLocation = location.origin;
const queryString = window.location.search;
const urlParams = new URLSearchParams(queryString);
const apiUrl = 'dm/vchasno-kasa/api/v1/';
const deviceId = urlParams.get('dev_id');
const pagNode = document.getElementById('pagination');
const perPageNode = document.getElementById('perPage');

let Pagination = {
	code: '',
	// converting initialize data
	Extend: function (data) {
		data = data || {};
		Pagination.size = data.size || 300;
		Pagination.page = data.page || 1;
		Pagination.step = data.step || 3;
	},
	// add pages by number (from [s] to [f])
	Add: function (s, f) {
		for (var i = s; i < f; i++) {
			Pagination.code += `<div onclick="changePage(${i},${
				document.getElementById('perPage').value
			})">${i}</div>`;
		}
	},
	// add last page with separator
	Last: function () {
		Pagination.code += `<div>...</div><div onclick="changePage(${
			Pagination.size
		},${document.getElementById('perPage').value})">${Pagination.size}</div>`;
	},
	// add first page with separator
	First: function () {
		Pagination.code += `<div onclick="changePage(1,${
			document.getElementById('perPage').value
		})">1</div><div>...</div>`;
	},

	// --------------------
	// Handlers
	// --------------------

	// change page
	Click: function () {
		Pagination.page = +this.innerHTML;
		Pagination.Start();
	},

	// previous page
	Prev: function () {
		Pagination.page--;
		if (Pagination.page < 1) {
			Pagination.page = 1;
		}
		changePage(Pagination.page, document.getElementById('perPage').value);
		Pagination.Start();
	},

	// next page
	Next: function () {
		Pagination.page++;
		if (Pagination.page > Pagination.size) {
			Pagination.page = Pagination.size;
		}
		changePage(Pagination.page, document.getElementById('perPage').value);
		Pagination.Start();
	},

	// --------------------
	// Script
	// --------------------

	// binding pages
	Bind: function () {
		var div = Pagination.e.getElementsByTagName('div');
		for (var i = 0; i < div.length; i++) {
			if (+div[i].innerHTML === Pagination.page) div[i].className = 'current';
			div[i].addEventListener('click', Pagination.Click, false);
		}
	},

	// write pagination
	Finish: function () {
		Pagination.e.innerHTML = Pagination.code;
		Pagination.code = '';
		Pagination.Bind();
	},

	// find pagination type
	Start: function () {
		if (Pagination.size < Pagination.step * 2 + 6) {
			Pagination.Add(1, Pagination.size + 1);
		} else if (Pagination.page < Pagination.step * 2 + 1) {
			Pagination.Add(1, Pagination.step * 2 + 2);
			Pagination.Last();
		} else if (Pagination.page > Pagination.size - Pagination.step * 2) {
			Pagination.First();
			Pagination.Add(
				Pagination.size - Pagination.step * 2 - 2,
				Pagination.size + 1
			);
		} else {
			Pagination.First();
			Pagination.Add(
				Pagination.page - Pagination.step,
				Pagination.page + Pagination.step + 1
			);
			Pagination.Last();
		}
		Pagination.Finish();
	},

	// --------------------
	// Initialization
	// --------------------

	// binding buttons
	Buttons: function (e) {
		var nav = e.getElementsByTagName('div');
		nav[0].addEventListener('click', Pagination.Prev, false);
		nav[1].addEventListener('click', Pagination.Next, false);
	},

	// create skeleton
	Create: function (e) {
		var html = [
			'<div class="left-arrow"><img src="./images/arrow.png" /></div>', // previous button
			'<span class="pages"></span>', // pagination container
			'<div class="right-arrow"><img src="./images/arrow.png" /></div>', // next button
		];

		e.innerHTML = html.join('');
		Pagination.e = e.getElementsByTagName('span')[0];
		Pagination.Buttons(e);
	},

	// init
	Init: function (e, data) {
		Pagination.Extend(data);
		Pagination.Create(e);
		Pagination.Start();
	},
};

function getLogs(extraParam) {
	!extraParam && (extraParam = '');
	const devIdParam = deviceId ? `dev_id=${deviceId}&` : '';
	fetch(`${urlLocation}/${apiUrl}logs?${devIdParam}${extraParam}`)
		.then((response) => response.json())
		.then((result) => {
			const table = document.getElementById('logs-list-container');

			perPageNode.value = result.paging.page_size;
			pagNode.innerHTML = '';
			table.innerHTML = '';
			let levelClass;

			for (let [key, log] of result.logs.entries()) {
				let logInfo = log.info.replace(/</, '&lt;');
				logInfo = logInfo.replace(/>/, '&gt;');
				const dev_id =
					log.device_id !== '-' ? `data-dev="${log.device_id}"` : '';
				if (log.level === 1) {
					levelClass = 'red';
				} else if (log.level === 2) {
					levelClass = 'yellow';
				} else if (log.level === 3) {
					levelClass = 'green';
				}
				let trNode = `<tr class="device-row ${
					levelClass ? levelClass : ''
				}" ${dev_id} onclick="showModal(this)">
           <td class="date"><span class="visible-xs">Date: </span>${
							log.datetime.split(' ')[0]
						}</td>
           <td class="time"><span class="visible-xs">Time: </span>${
							log.datetime.split(' ')[1]
						}</td>
           <td class="source"><span class="visible-xs">Source: </span>${
							log.source
						}</td>
           <td class="device_name"><span class="visible-xs">Device: </span>${
							log.device_name
						}</td>
           <td class="tag"><span class="visible-xs">Tag: </span>${log.tag}</td>
           <td class="level"><span class="visible-xs">Level: </span>${
							log.level
						}</td>
           <td class="info"><span class="visible-xs">Info: </span><span>${logInfo.toString()}</span></td>
           </tr>`;
				table.insertAdjacentHTML('beforeend', trNode);
			}

			if (result.paging.total_pages > 1) {
				for (i = 1; i <= result.paging.total_pages; i++) {
					let curPage = '';
					i === result.paging.page_number && (curPage = 'selected');
					let pageNode = `<div onclick="changePage(${i},${perPageNode.value})" class="${curPage}">${i}</div>`;
					//pagNode.insertAdjacentHTML('beforeend', pageNode);
				}
				Pagination.Init(document.getElementById('pagination'), {
					size: result.paging.total_pages, // pages size
					page: result.paging.page_number, // selected page
					step: 2, // pages before and after current
				});
				//pagNode.page_number
			}
		});
}

function changePage(page, count) {
	getLogs(`page=${page}&page_size=${count}`);
}
function changePerPage(count) {
	getLogs(`page=1&page_size=${count}`);
}

function hideModal() {
	document.getElementById('modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
}
function showModal(logR) {
	const device_name = logR.querySelector('.device_name').innerHTML;

	document.getElementById('modal').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');

	document.getElementById('m_date').innerHTML =
		logR.querySelector('.date').innerHTML +
		'  ' +
		logR.querySelector('.time').innerHTML;

	document.getElementById('m_source').innerHTML = logR.querySelector(
		'.source'
	).innerHTML;
	device_name &&
		(document.getElementById(
			'm_dev'
		).innerHTML = `Подія по пристрою ${device_name}`);
	document.getElementById('m_level').innerHTML = logR.querySelector(
		'.level'
	).innerHTML;
	document.getElementById('m_tag').innerHTML = logR.querySelector(
		'.tag'
	).innerHTML;
	document.getElementById('m_mes').innerHTML = logR.querySelector(
		'.info'
	).innerHTML;
}
function goBack() {
	window.history.back();
}
getLogs();
