const urlLocation = location.origin;
// const urlLocation = "http://localhost:3939";

const API_URL =  `${urlLocation}/dm/api/v3/emul`;
const queryString = window.location.search;
const urlParams = new URLSearchParams(queryString);
const devId = urlParams.get('dev_id');
 
const settingsPage = document.getElementById('settings-page');
const productsPage = document.getElementById('products-page');
const logsPage = document.getElementById('logs-page');

const retryButton = document.getElementById('retry-button');
const refreshButton = document.getElementById('refresh-button');
const emulatorTitle = document.getElementById('emulator-title');
const actionsMenu = document.getElementById('actions-menu');
const actionsButton = document.getElementById('actions-button');

let taxCodesArray = [];
let paysCodesArray = [];
let taxesArray = [];
let EMULATION_STATUS = 11;
let isMigrationStarted = false;
let dbMigrationStateInterval = null;

retryButton.addEventListener('click', saveSettings);
  
const connectionCheckboxes = document.getElementsByName('connection');

const getCurrentPageHash = () => {
    const pageHash = window.location.hash;

    let selectedTabId = '#settings';

    if (pageHash === '#products' || pageHash === '#logs') {
        selectedTabId = pageHash;
    }

    return selectedTabId;
}

const pingEmulationStatus = async () => {
    const { status } = await fetch(`${API_URL}/status?dev_id=${devId}`).then(response => response.json());
    EMULATION_STATUS = status;
}

const fillActionsMenu = () => {
    const menuItems = [];

    const saveMenuItem = document.createElement('div');
    saveMenuItem.textContent = 'Зберегти';
    saveMenuItem.addEventListener('click', saveSettings);

    menuItems.push(saveMenuItem);

    const overrideMenuItem = document.createElement('div');
    overrideMenuItem.textContent = 'Перенести налаштування';
    overrideMenuItem.addEventListener('click', showMigrationModal);

    menuItems.push(overrideMenuItem);

    if (EMULATION_STATUS === 10) {
        const stopEmulatorMenuItem = document.createElement('div');
        stopEmulatorMenuItem.textContent = 'Зупинити';
        stopEmulatorMenuItem.addEventListener('click', () => {
            toggleEmulation(false);
        });

        menuItems.push(stopEmulatorMenuItem);
    } else if (EMULATION_STATUS === 11 || EMULATION_STATUS === 12) {
        const startEmulatorMenuItem = document.createElement('div');
        startEmulatorMenuItem.textContent = 'Зберегти і запустити';
        startEmulatorMenuItem.addEventListener('click', () => {
            saveSettings();
            toggleEmulation(true, true);
        });

        menuItems.push(startEmulatorMenuItem);
    } else if (EMULATION_STATUS === 13) {
        // TODO 
        document.getElementById('modal-emulator-error').classList.remove('hidden');
        document.getElementById('overlay').classList.remove('hidden');
    }

    actionsMenu.replaceChildren(...menuItems);
};

const changeEmulatorTitle = () => {
    emulatorTitle.textContent = EMULATION_STATUS === 10 ? 'Емулятор РРО (запущено)' : 'Емулятор РРО (не запущено)';
};

const initiateTabs = async () => {
    const tabs = document.querySelectorAll('.tab');
    const selectedTabId = getCurrentPageHash();
    await pingEmulationStatus();
    fillActionsMenu();
    changeEmulatorTitle();

    showPageContent(selectedTabId);
    document.getElementById(selectedTabId).classList.add('active-tab');
    
    tabs.forEach(tab => tab.addEventListener('click', tabClickHandler));
    connectionCheckboxes.forEach(cb => cb.addEventListener('change', changeConnectionTypeHandler));
};

const tabClickHandler = ({ target }) => {
    const selectedTabId = target.getAttribute('id');
    const activeTab = document.querySelector('.tabs .active-tab');
    
    activeTab.classList.remove('active-tab');
    target.classList.add('active-tab');
    
    showPageContent(selectedTabId);
    window.history.pushState({}, '', selectedTabId);
};

const fillUpProductsTable = (goods) => {
    const productsTableBodyNode = document.getElementById('product-table-body');
    productsTableBodyNode.innerHTML = '';

    goods.forEach(({
        name,
        code,
        price,
        quantity,
        disc,
        taxgrp
    }) => {
        const tr = document.createElement('tr');
        tr.classList.add('row');

        tr.innerHTML = `
            <td>${code}</td>
            <td>${taxgrp}</td>
            <td>${name}</td>
            <td>${price}</td>
            <td>${quantity}</td>
            <td>${disc}</td>
        `;
    
        productsTableBodyNode.appendChild(tr);
    });
};

const changeConnectionTypeHandler = ({ target: { value } }) => {
    document.getElementById('com-port-settings').classList.add('hidden');
    document.getElementById('ethernet-port-settings').classList.add('hidden');

    if (value === 'ethernet') {    
        document.getElementById('ethernet-port-settings').classList.remove('hidden');
    }
    
    if (value === 'com') {
        document.getElementById('com-port-settings').classList.remove('hidden');
    }
};

const getPrintersFromDM = (printerName) => {
    fetch(`${urlLocation}/dm/api/v3/devices`)
        .then(response => response.json())
        .then(({ devices }) => {
            const printers = devices.filter(({ is_doc }) => is_doc);
            const selectedPrinter = printers.find(printer => printer.dev_code === printerName);
            const emptyListMessage = !printers.length ? '<p>Доступні принтери не знайдені. <span class="link" onclick="goToDashboard()">Додати принтер</span</p>' : '';

            generateSelect(
                "printers-container",
                "printers",
                printers.map(device => ({
                    id: device.dev_code,
                    capt: device.dev_code,
                })),
                selectedPrinter ? { id: selectedPrinter.dev_code } : '',
                null,
                emptyListMessage,
            );
        })
};

const showPageContent = (selectedTabId) => {
    settingsPage.classList.add('hidden');
    productsPage.classList.add('hidden');
    logsPage.classList.add('hidden');

    document.getElementById('save-message').classList.add('hidden');    
    document.getElementsByClassName('tabs-container')[0].classList.remove('hidden');
    document.getElementsByClassName('emulation-settings')[0].classList.remove('hidden');

    if (selectedTabId === '#settings') {
        showSettingsPage();
    }
    
    if (selectedTabId === '#products') {
        showProductsPage();
    } 
    
    if (selectedTabId === '#logs') {
        showLogsPage();
    }
};

function goToDashboard() {
	window.location = `${urlLocation}/dm/dashboard.html`;
}

const showSettingsPage = async () => {
    settingsPage.classList.remove('hidden');

    document.getElementById('com-port-settings').classList.add('hidden');
    document.getElementById('ethernet-port-settings').classList.add('hidden');

    const comConnectionCheckbox = document.getElementById('com-connection');
    const ethernetConnectionCheckbox = document.getElementById('ethernet-connection');

    toggleLoader();
    fetch(`${API_URL}/getsettings?dev_id=${devId}`)
        .then(response => response.json())
        .then(({
            is_com,
            is_print,
            is_plu_editable,
            debug_mode,
            disable_rounding,
            dev_sn,
            dev_model,
            prn_name,
            com_port,
            com_port_sec,
            com_br,
            ethernet_port,
            taxCodesAssociated,
            paysCodesAssociated,
            taxes,
        }) => {
            if (is_com) {
                comConnectionCheckbox.checked = true;
                document.getElementById('com-port-settings').classList.remove('hidden');
            } else {
                ethernetConnectionCheckbox.checked = true;
                document.getElementById('ethernet-port-settings').classList.remove('hidden');
            }

            taxCodesArray = JSON.parse(JSON.stringify(taxCodesAssociated));
            createTableRows(taxCodesArray, "taxCodes");

            paysCodesArray = JSON.parse(JSON.stringify(paysCodesAssociated));
            createTableRows(paysCodesArray, "paysCodes");

            taxesArray = JSON.parse(JSON.stringify(taxes));
            createTableRows(taxesArray, "taxes");


            document.getElementById('use-printer').checked = is_print;
            document.getElementById('edit-products').checked = is_plu_editable;
            document.getElementById('debug-mode').checked = debug_mode;
            document.getElementById('disable-rounding').checked = disable_rounding;
            document.getElementById('serial-number').value = dev_sn;
            document.getElementById('dev-model').value = dev_model;
            document.getElementById('com-port-speed').value = com_br;
            document.getElementById('com-port-name').value = com_port;
            document.getElementById('com-port-sec-name').value = com_port_sec;
            document.getElementById('ethernet-port-name').value = ethernet_port;
            toggleLoader();
            getPrintersFromDM(prn_name);
        }).catch(() => {
            toggleLoader()
        }
    );
};

function createTableRows(dataArray, arrayType) {
    if (arrayType === "taxCodes") {
        const taxCodesBody = document.getElementById('taxCodesBody');
        taxCodesBody.innerHTML = '';

        dataArray.forEach((taxCode, index) => {
            const row = document.createElement('tr');

            // Create and append input field for prro_code
            const prroCodeInput = document.createElement('input');
            prroCodeInput.type = 'text';
            prroCodeInput.value = taxCode.prro_code;
            prroCodeInput.addEventListener('input', (event) => {
                dataArray[index].prro_code = parseInt(event.target.value) || 0;
            });
            const prroCodeCell = document.createElement('td');
            prroCodeCell.appendChild(prroCodeInput);
            row.appendChild(prroCodeCell);

            // Create and append input field for pos_code
            const posCodeInput = document.createElement('input');
            posCodeInput.type = 'text';
            posCodeInput.value = taxCode.pos_code;
            posCodeInput.addEventListener('input', (event) => {
                dataArray[index].pos_code = parseInt(event.target.value) || 0;
            });
            const posCodeCell = document.createElement('td');
            posCodeCell.appendChild(posCodeInput);
            row.appendChild(posCodeCell);

            // Append the row to the table body
            taxCodesBody.appendChild(row);
        });
    } else if (arrayType === "paysCodes") {
        const paysCodesBody = document.getElementById('paysCodesBody');
        paysCodesBody.innerHTML = '';

        dataArray.forEach((payCode, index) => {
            const row = document.createElement('tr');

            // Create and append input field for prro_code
            const prroCodeInput = document.createElement('input');
            prroCodeInput.type = 'text';
            prroCodeInput.value = payCode.prro_code;
            prroCodeInput.addEventListener('input', (event) => {
                dataArray[index].prro_code = parseInt(event.target.value) || 0;
            });
            const prroCodeCell = document.createElement('td');
            prroCodeCell.appendChild(prroCodeInput);
            row.appendChild(prroCodeCell);

            // Create and append input field for pos_code
            const posCodeInput = document.createElement('input');
            posCodeInput.type = 'text';
            posCodeInput.value = payCode.pos_code;
            posCodeInput.addEventListener('input', (event) => {
                dataArray[index].pos_code = parseInt(event.target.value) || 0;
            });
            const posCodeCell = document.createElement('td');
            posCodeCell.appendChild(posCodeInput);
            row.appendChild(posCodeCell);

            // Append the row to the table body
            paysCodesBody.appendChild(row);
        });
    } else {
        const taxesBody = document.getElementById('taxesBody');
        taxesBody.innerHTML = '';

        taxesArray.forEach((tax, index) => {
            const row = document.createElement('tr');

            // Create and append input field for id
            const idInput = document.createElement('input');
            idInput.type = 'text';
            idInput.value = tax.id;
            idInput.addEventListener('input', (event) => {
                taxesArray[index].id = parseInt(event.target.value) || 0;
            });
            const idCell = document.createElement('td');
            idCell.appendChild(idInput);
            row.appendChild(idCell);

            // Create and append input field for tax_type
            const taxTypeInput = document.createElement('input');
            taxTypeInput.type = 'text';
            taxTypeInput.value = tax.tax_type;
            taxTypeInput.addEventListener('input', (event) => {
                taxesArray[index].tax_type = event.target.value;
            });
            const taxTypeCell = document.createElement('td');
            taxTypeCell.appendChild(taxTypeInput);
            row.appendChild(taxTypeCell);

            // Create and append input field for tax_value
            const taxValueInput = document.createElement('input');
            taxValueInput.type = 'text';
            taxValueInput.value = tax.tax_value;
            taxValueInput.addEventListener('input', (event) => {
                taxesArray[index].tax_value = event.target.value;
            });
            const taxValueCell = document.createElement('td');
            taxValueCell.appendChild(taxValueInput);
            row.appendChild(taxValueCell);

            // Create and append input field for tax_name
            const taxNameInput = document.createElement('input');
            taxNameInput.type = 'text';
            taxNameInput.value = tax.tax_name;
            taxNameInput.addEventListener('input', (event) => {
                taxesArray[index].tax_name = event.target.value;
            });
            const taxNameCell = document.createElement('td');
            taxNameCell.appendChild(taxNameInput);
            row.appendChild(taxNameCell);

            // Create and append input field for tax_assoc
            const taxAssocInput = document.createElement('input');
            taxAssocInput.type = 'text';
            taxAssocInput.value = tax.tax_assoc;
            taxAssocInput.addEventListener('input', (event) => {
                taxesArray[index].tax_assoc = event.target.value;
            });
            const taxAssocCell = document.createElement('td');
            taxAssocCell.appendChild(taxAssocInput);
            row.appendChild(taxAssocCell);

            // Append the row to the table body
            taxesBody.appendChild(row);
        });
    }
}

const showProductsPage = () => {
    productsPage.classList.remove('hidden');

    fetch(`${API_URL}/goods?dev_id=${devId}`)
        .then(response => response.json())
        .then(({ goods }) => fillUpProductsTable(goods))
        .catch(() => toggleLoader());
};

const showLogsPage = () => {
    logsPage.classList.remove('hidden');

    const logsInfoNode = document.getElementById('logs-info');

    fetch(`${API_URL}/logs?dev_id=${devId}`)
        .then(response => response.arrayBuffer())
        .then(buffer => {
            const decoder = new TextDecoder('windows-1251');
            logsInfoNode.textContent = decoder.decode(buffer);
        })
        .catch(error => {
            console.error(error);
            toggleLoader();
        });
};

refreshButton.addEventListener('click', () => {
    const selectedTabId = getCurrentPageHash();
    showPageContent(selectedTabId);
});

function saveSettings(){
    const saveMessage = document.getElementById('save-message');
    saveMessage.innerHTML = '';
    saveMessage.classList.add('hidden');

    const is_com = document.getElementById('com-connection').checked;
    const com_port = document.getElementById('com-port-name').value;
    const com_port_sec = document.getElementById('com-port-sec-name').value;
    const com_br = document.getElementById('com-port-speed').value;
    const ethernet_port = document.getElementById('ethernet-port-name').value;
    const prn_name = document.getElementById('printers').value;
    const is_print = document.getElementById('use-printer').checked;
    const is_plu_editable = document.getElementById('edit-products').checked;
    const debug_mode = document.getElementById('debug-mode').checked;
    const disable_rounding = document.getElementById('disable-rounding').checked;
    const dev_sn = document.getElementById('serial-number').value;
    const dev_model = document.getElementById('dev-model').value;
    const taxCodesAssociated = taxCodesArray;
    const paysCodesAssociated = paysCodesArray;
    const taxes = taxesArray;
    toggleLoader();

    fetch(`${API_URL}/setsettings?dev_id=${devId}`, {
        method: 'POST',
        body: JSON.stringify({
            is_com,
            com_port,
            com_port_sec,
            com_br: Number(com_br),
            ethernet_port: Number(ethernet_port),
            prn_name,
            is_print,
            is_plu_editable,
            debug_mode,
            disable_rounding,
            dev_sn,
            dev_model,
            taxCodesAssociated,
            paysCodesAssociated,
            taxes,
        })
    })
    .then(response => response.json())
    .then(({ err_msg }) => {
        if (err_msg) {
            toggleLoader();
            showModalAsk(1, err_msg);
            console.log(err_msg);
        } else {
            toggleLoader();
            showModalAsk(0, '', 'Налаштування збережено успішно');
            console.log(err_msg);
        }
    });
}

function showModalAsk(status, errorMessage, successMessage) {
    if (status === 0) {
        document.getElementById('retry-button').classList.add('hidden');
        document.querySelector('.actionQuestion').innerHTML = successMessage;
        document.getElementById('modal-ask-before-action').classList.remove('hidden');
        document.getElementById('overlay').classList.remove('hidden');
    } else {
        document.querySelector('.actionQuestion').innerHTML = `Помилка збереження налаштувань: ${errorMessage}`;
        document.getElementById('modal-ask-before-action').classList.remove('hidden');
        document.getElementById('overlay').classList.remove('hidden');
    }
}

function hideModalAsk() {
    document.getElementById('retry-button').classList.remove('hidden');
    document.getElementById('modal-ask-before-action').classList.add('hidden');
    document.getElementById('overlay').classList.add('hidden');
    const selectedTabId = getCurrentPageHash();
    showPageContent(selectedTabId);
}

function showMigrationModal () {
    document.getElementById('modal-db-migration').classList.remove('hidden');
    document.getElementById('overlay').classList.remove('hidden');
}

function hideMigrationModal() {
    document.getElementById('modal-db-migration').classList.add('hidden');
    document.getElementById('overlay').classList.add('hidden');
}

function openDbMigrationStateModal() {
	document.getElementById('modal-migration-state').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}

function closeDbMigrationStateModal() {
	document.getElementById('modal-migration-state').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
	if (!isMigrationStarted) return;

	const url = `${urlLocation}/dm/api/v3/data_migration_stop`;

	fetch(url)
		.then(response => response.json())
		.then(({ res, errortxt }) => {
			const migrationStateProgress = document.getElementById('migration-state-progress');
			const migrationStateLoader = document.getElementById('migration-state-loader');
			const migrationStateMessage = document.getElementById('migration-state-message');
			const migrationStateErrorText = document.getElementById('migration-state-error-text');

			migrationStateProgress.classList.remove('hidden');
			migrationStateLoader.classList.remove('hidden');
			migrationStateMessage.classList.remove('hidden');
			migrationStateErrorText.classList.add('hidden');

			if (res === -1) {
				document.getElementById('migration-state-progress').innerHTML = `Прогрес перенесення:`;
				migrationStateMessage.innerHTML = '';
				migrationStateErrorText.innerHTML = '';
				isMigrationStarted = false;
				clearInterval(dbMigrationStateInterval);
				callTostSnackbar(errortxt);
			} else {
				migrationStateErrorText.classList.remove('hidden');
				migrationStateErrorText.innerHTML = errortxt;
			}
		})
		.catch(err => {
			callTostSnackbar(`Request failed: ${err}`);
		});
}

function toggleLoader() {
    document.getElementById('loader-box').classList.toggle('active');
}

function backToPrro() {
    window.location = `${urlLocation}/dm/vchasno-kasa/devicedetail.html?dev_id=${devId}`
}

function migrateDB() {
    const dbFilePath = document.getElementById('dbFilePath').value;
    const iniFilePath = document.getElementById('iniFilePath').value;

    fetch(`${urlLocation}/dm/api/v3/emul/data_migration_start?dev_id=${devId}&db_path=${dbFilePath}&ini_path=${iniFilePath}`, {
		method: 'GET',
	})
		.then((response) => response.json())
		.then((result) => {
			if (result.errortxt) {
				document.getElementById('error-db-migration').innerText = result.errortxt;
			} else if (result.res === 0) {
				isMigrationStarted = true;
				dbMigrationStateInterval = setInterval(dbMigrationState, 1000);
				hideMigrationModal();
				openDbMigrationStateModal();
			}
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		});
}

function dbMigrationState() {
	const url = `${urlLocation}/dm/api/v3/data_migration_state`;
	const reverseSyncLoaderBox = document.getElementById('migration-state-loader-box');

	fetch(url)
		.then(response => response.json())
		.then(({ res, errortxt }) => {
			const migrationStateProgress = document.getElementById('migration-state-progress');
			const migrationStateLoader = document.getElementById('migration-state-loader');
			const migrationStateMessage = document.getElementById('migration-state-message');
			const migrationStateErrorText = document.getElementById('migration-state-error-text');
			migrationStateMessage.classList.remove('hidden');
			migrationStateMessage.innerHTML = errortxt;

			if (res < 100 && res > 0) {
				reverseSyncLoaderBox.classList.remove('hidden');

				document
					.getElementById('migration-state-progress')
					.innerHTML = `Прогрес перенесення:&nbsp;&nbsp;&nbsp;${res}%`;
			}
			
			if (res === 100 && dbMigrationStateInterval) {
				document.getElementById('migration-state-progress').innerHTML = `Прогрес перенесення:`;
				migrationStateMessage.innerHTML = '';
				migrationStateErrorText.innerHTML = '';
				clearInterval(dbMigrationStateInterval);
				isMigrationStarted = false;
                const selectedTabId = getCurrentPageHash();
                showPageContent(selectedTabId);
				closeDbMigrationStateModal();
				callTostSnackbar('Міграція завершена вдало');
			}

			if (res === -2) {
				clearInterval(dbMigrationStateInterval);
				document.getElementById('migration-state-progress').innerHTML = `При міграції сталась помилка:`;
				migrationStateProgress.classList.remove('hidden');
				migrationStateLoader.classList.add('hidden');
				migrationStateMessage.classList.add('hidden');
				migrationStateErrorText.classList.remove('hidden');
				migrationStateErrorText.innerHTML = errortxt;
			}
		})
		.catch(err => {
			callTostSnackbar(`Request failed: ${err}`);
		});
}


async function toggleEmulation(updatedState, skipNotification = false) {
	try {
		const response = await fetch(
		   `${API_URL}/${updatedState ? 'start' : 'stop'}?dev_id=${devId}`, {
				method: 'POST',
		   		body:{}
	   		}
		);

	   const result = await response.json();

	   if (result.res !== 0) {
			callTostSnackbar(result.errortxt);
			return false;
	   }

        EMULATION_STATUS = updatedState ?  10 : 12;
    
        fillActionsMenu();
        changeEmulatorTitle();

        if (!skipNotification) {
            showModalAsk(0, '', `Емулятор ${updatedState ? 'запущено' : 'зупинено'}`);
        }
	   return true;
	} catch (err) {
		return false;
	}
}

function toggleMenu() {
    actionsMenu.classList.toggle('hidden');
}

function generateSelect(
  parentNodeId,
  nodeId,
  optionsData,
  selected = "",
  onChange,
  emptyListMessage = "",
) {
  /*get parent div*/
  const parentNode = document.getElementById(parentNodeId);
  parentNode.classList.remove("hidden");

  const parentListCont = parentNode.querySelector("div");
  parentListCont.innerHTML = ""; //clear data

  const selectList = document.createElement("select");

  const emptyListMessageNode = document.createElement("p");
  emptyListMessageNode.innerHTML = emptyListMessage;

  selectList.id = nodeId;
  selectList.name = nodeId;
  selectList.disabled = optionsData.length === 0;
  onChange && (selectList.onchange = onChange);

  for (let optionData of optionsData) {
    let newOption = (selectList.options[selectList.options.length] = new Option(
      optionData.capt,
      optionData.id
    ));
    if (nodeId === "intf") {
      newOption.classList.add(optionData.capt.toLowerCase());
    }
  }
  selected && selected.id && (selectList.value = selected.id);
  parentListCont.appendChild(selectList);

  if (optionsData.length === 0 && emptyListMessage) {
    parentListCont.appendChild(emptyListMessageNode);
  }
}


document.addEventListener('click', e => {
    if (!actionsMenu.contains(e.target) && e.target !== actionsButton) {
        actionsMenu.classList.add('hidden');
    }
})

initiateTabs();