const urlLocation = location.origin;
// const urlLocation = "http://localhost:3939";

const queryString = window.location.search;
const urlParams = new URLSearchParams(queryString);
const apiUrl = 'dm/vchasno-kasa/api/v1/';
const deviceId = urlParams.get('dev_id');
const modalXReport = document.getElementById('modal-x-report');
const overlay = document.getElementById('overlay');
const signInfoNode = document.getElementById('prev-key-info');
const prroGroupsInfoNode = document.getElementById('prro-groups-info');
const prroInfoNode = document.getElementById('prro-info');
const safeSumm = document.getElementById('safe-summ-input');
const passwordInput = document.getElementById("prev-key-pass");
const showPasswordBtn = document.getElementById("show-password-btn");
const toggleEmulationSwitchNode = document.getElementById("toggle-emulation-switch");
const emulationSettingsLink = document.getElementById("emulation-settings");
const emulationStateNode = document.getElementById("emulation-state");
let keytype;
let acskList = [];
let removeExistingReceiptsInReverseSync = false;
let isReverseSyncStarted = false;
let reverseSyncInterval = null;
let loadedFileExtension = null;
const postSafeSummButton = document.getElementById('post-safe-summ');
const statusDesc = {
	0: {
		caption: 'Online',
		className: 'green',
	},
	1: {
		caption: 'Online, поточна помилка не потребує уваги',
		className: 'yellow',
	},
	2: {
		caption: 'Online, помилка потребує уваги',
		className: 'yellow',
	},
	10: {
		caption: 'Offline',
		className: 'blue',
	},
	12: {
		caption: 'Offline, помилка потребує уваги',
		className: 'yellow',
	},
	20: {
		caption: 'Заблоковано',
		className: 'red',
	},
};

safeSumm.addEventListener('keyup', function (e) {
	const isSafeSummValid = (Number.parseFloat(e.target.value) || Number.parseFloat(e.target.value) === 0) && e.target.value >= 0;
	postSafeSummButton.disabled = !isSafeSummValid;
})
function toggleLoader() {
	document.getElementById('loader-box').classList.toggle('active');
}
function formatOfflineTime(time) {
	const hours =
		Math.floor(time / 60) > 9
			? Math.floor(time / 60)
			: `0${Math.floor(time / 60)}`;
	const minutes = time % 60 > 9 ? time % 60 : `0${time % 60}`;
	return `${hours}:${minutes}`;
}
function setAdditionalInfo(version, dfs) {
	let dfsClass = 'green';
	dfs < 95 && dfs > 50 && (dfsClass = 'orange');
	dfs <= 50 && (dfsClass = 'red');
	document.querySelector('.additional-info .version span').innerText = version;
	document.querySelector('.additional-info .dfs span').classList.add(dfsClass);
	document.querySelector('.additional-info .dfs span').innerText =
		dfs < 0 ? 'Не доступна' : `${dfs}%`;
}
function isEndOfSighKey(endStr) {
	if (endStr) {
		const today = new Date();
		const endDate = new Date(
			endStr.substr(0, 4),
			endStr.substr(4, 2) - 1,
			endStr.substr(6, 2)
		);
		const Days = Math.floor(
			(endDate.getTime() - today.getTime()) / (1000 * 60 * 60 * 24)
		);
		return Days > 5 ? false : true;
	}
	return false;
}
function generatePrevKeyInfoBlock(signInfo, shiftdt) {
	// if sign ket expires in 5 days add red to prev-key-info node
	const expiredDateOfSignKey = isEndOfSighKey(signInfo?.endTime);
	signInfoNode.parentNode.classList.remove('error');
	expiredDateOfSignKey && signInfoNode.parentNode.classList.add('error');

	let prevKeyDetails = `<div class="line"><b>Тип ключа</b><div>${keytype}</div></div><div class="line"><b>Номер сертифікату</b><div>${signInfo?.serial?.toLowerCase()}</div>`;

	if (signInfo?.publicKeyID) {
		if (signInfo.subjectOrg) {
			prevKeyDetails = `<div class="line"><b>АЦСК</b><div>${signInfo.issuerCN}</div></div><div class="line"><b>Тип ключа</b><div>${keytype}</div></div><div class="line"><b>Власник</b><div>${signInfo.subjectCN} (${signInfo.subjectOrg})</div></div>`;
		} else {
			prevKeyDetails = `<div class="line"><b>АЦСК</b><div>${signInfo.issuerCN}</div></div><div class="line"><b>Тип ключа</b><div>${keytype}</div></div><div class="line"><b>Власник</b><div>${signInfo.subjectCN}</div></div>`;
		}
		prevKeyDetails += `<div class="line"><b>Ідентифікатор ключа суб'єкта</b><div style='word-break: break-word;'>${signInfo?.publicKeyID}</div></div>`;
		signInfo?.endTime &&
			signInfo?.beginTime &&
			(prevKeyDetails += `<div class="line ${expiredDateOfSignKey ? 'red' : ''
				}"><b>Термін дії</b> ${expiredDateOfSignKey ? '<b>(закінчується)</b>' : ''
				}<div>з ${formatDate(signInfo?.beginTime, false)} по ${formatDate(
					signInfo?.endTime,
					false
				)}</div></div>`);

	}

	if (
		signInfo &&
		(signInfo.subjectCN === signInfo.subjectOrg || !signInfo.subjectOrg)
	) {
		shiftdt ? disableEnableEdit(false, true) : disableEnableEdit(true, true);
		signInfoNode.innerHTML = `<div class="line">${prevKeyDetails}</div>`;
		signInfoNode.classList.remove('hidden');
	} else if (signInfo) {
		shiftdt ? disableEnableEdit(false, true) : disableEnableEdit(true, true);
		signInfoNode.innerHTML = `<div class="line">${prevKeyDetails}</div>`;
		signInfoNode.classList.remove('hidden');
	} else {
		shiftdt ? disableEnableEdit(false) : disableEnableEdit(true);
		signInfoNode.innerText = '';
		signInfoNode.classList.add('hidden');
	}
}
async function getDevice() {
	toggleLoader();

	const sysInfo = await getSysInfo();
	if (sysInfo.platform === 'Android') {
		document.getElementById('emulation-status').classList.add('hidden');
	}
	document.getElementById('is-alarm').value = false;
	if (document.querySelector('.offline_time_container')) {
		document.querySelector('.offline_time_container').remove();
	}
	if (document.querySelector('.offline_receipt_count_container')) {
		document.querySelector('.offline_receipt_count_container').remove();
	}

	const deviceInfo = await fetch(`${urlLocation}/${apiUrl}prro?dev_id=${deviceId}`)
		.then((response) => response.text())
		.then((result) => {
			let changedResult = result.replaceAll(/\\\\U0027/g, "'");
			changedResult = JSON.parse(changedResult);

			if (changedResult.errortxt) {
				callTostSnackbar(changedResult.errortxt);
			} else {
				const signInfo = changedResult.signinfo && JSON.parse(changedResult.signinfo);
				keytype = changedResult.cloud_sign ? 'Хмарний' : 'Файловий';
				if (keytype === 'Хмарний') {
					document.getElementById('check-sign-session-button').classList.remove('hidden');
				} else {
					document.getElementById('check-sign-session-button').classList.add('hidden');
				}
				if (changedResult.sign_mode === 1) {
					document.getElementById('sign_mode').innerText = 'У застосунку';
				} else if (changedResult.sign_mode === 2) {
					document.getElementById('sign_mode').innerText = 'З хмарного сховища Вчасно.Каса';
				} else {
					document.getElementById('sign_mode').innerText = 'Не обрано';
				}
				/* open shift time */
				const shiftPostTime = changedResult.shiftterm ? changedResult.shiftterm / 60 : false;
				let shiftPosClassName = '';

				switch (true) {
					case shiftPostTime && shiftPostTime <= 20:
						shiftPosClassName = 'green';
						break;
					case shiftPostTime < 24 && shiftPostTime > 20:
						shiftPosClassName = 'yellow';
						break;
					case shiftPostTime >= 24:
						shiftPosClassName = 'red';
						break;
				}

				const shiftOpenDate = changedResult.shiftdt && formatDate(changedResult.shiftdt);

				if (changedResult.blocked === 1) {
					document.getElementById('disabled-prro-warning').classList.remove('hidden');
				} else {
					document.getElementById('disabled-prro-warning').classList.add('hidden');
				}
				document.querySelector('h1').innerText = changedResult.device;
				document.getElementById('fisid').innerText = changedResult.fisid;
				document.getElementById('prro_type').innerText = changedResult.prro_type
					? 'Тестовий'
					: 'Фіскальний';
				document.getElementById('firm_name').innerText = changedResult.firm_name;
				document.getElementById('site_name').innerText = changedResult.site_name;
				if (changedResult.site_type !== "") {
					document.getElementById('site_type').innerText = changedResult.site_type;
				} else {
					document.getElementById('site_type').innerText = 'Не зазначено';
				}
				document.getElementById('site_addr').innerText = changedResult.site_addr;
				document.getElementById('firm_code').innerText = changedResult.firm_code;
				document.getElementById('firm_vat_code').innerText =
					changedResult.firm_vat_code;

				document.getElementById('shiftdt').innerText = changedResult.shiftdt
					? shiftOpenDate
					: 'Закрита';
				if (changedResult.offlineFisNum_VacantCount <= 0) {
					document.getElementById('offlineFisNum_VacantCount').innerText = 'Номери відсутні';
					offlineFisNum_VacantCount.className = 'red';
				}
				else {
					document.getElementById('offlineFisNum_VacantCount').innerText = changedResult.offlineFisNum_VacantCount;
					offlineFisNum_VacantCount.className = 'green';
				}


				shiftPosClassName &&
					document.getElementById('shiftdt').classList.add(shiftPosClassName);

				if (changedResult.prro_status === 10 || changedResult.prro_status === 12 || changedResult.prro_status === 20) {
					document.getElementById('prro_status').innerText =
						statusDesc[changedResult.prro_status].caption;
					offline_receipt_count = `<div class="line text offline_receipt_count_container"><span>Кількість виданих чеків в режимі offline за поточну сесію</span><div class="offline_receipt_count">${changedResult.offlineReceiptCount} 
						</div></div>`;
					document
						.getElementById('offlineFisNum_VacantCount')
						.parentNode.insertAdjacentHTML('afterend', offline_receipt_count);
					offline_str = `<div class="line text offline_time_container"><span>Час в офлайні (поточний / за місяць)</span><div class="offline_time">${formatOfflineTime(
						changedResult.offline_time1
					)} / ${formatOfflineTime(changedResult.offline_time2)}</div></div>`;
					document
						.getElementById('prro_status')
						.parentNode.insertAdjacentHTML('afterend', offline_str);
				} else if (changedResult.offline_time2) {
					offline_str = `<div class="line text offline_time_container"><span>Час в офлайні за місяць</span><div class="offline_time">${formatOfflineTime(
						changedResult.offline_time2
					)}</div></div>`;
					document
						.getElementById('prro_status')
						.parentNode.insertAdjacentHTML('afterend', offline_str);
					document.getElementById('prro_status').innerText =
						statusDesc[changedResult.prro_status].caption;
				} else {
					document.getElementById('prro_status').innerText =
						statusDesc[changedResult.prro_status].caption;
				}
				document
					.getElementById('prro_status')
					.classList.add(statusDesc[changedResult.prro_status].className);

				document.getElementById('device').value = changedResult.device;
				document.getElementById('can_offline').checked = changedResult.can_offline;
				document.getElementById('can_offline').value = changedResult.can_offline;
				document.getElementById('auto_open_shift').checked = changedResult.auto_open_shift;
				document.getElementById('auto_open_shift').value = changedResult.auto_open_shift;

				generatePrevKeyInfoBlock(signInfo, changedResult.shiftdt);

				if (acskList.length === 0) {
					getAcskList();
				}

				if (changedResult.use_emul) {
					toggleEmulationSwitchNode.checked = true;

					emulationStateNode.classList.remove('hidden');
 					emulationSettingsLink.classList.remove('hidden');
				}

				if (changedResult.emul_started) {
					emulationStateNode.innerText = 'Емулятор запущено';
				}
			}

			return changedResult;
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		})
		.finally(() => {
			toggleLoader();
		});

	const dfsAvailability = await fetch(`${urlLocation}/${apiUrl}dfs_availability`)
		.then(response => response.json())
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		});


	if (
		deviceInfo?.server_v &&
		dfsAvailability?.availability
	) {
		setAdditionalInfo(
			deviceInfo.server_v,
			dfsAvailability.availability
		);
	}

}
function formatDate(dateString, withTime = true) {
	let time = `${dateString.substr(6, 2)}.${dateString.substr(
		4,
		2
	)}.${dateString.substr(0, 4)}`;
	withTime &&
		(time +=
			`${dateString.substr(6, 2)}.${dateString.substr(
				4,
				2
			)}.${dateString.substr(0, 4)}` + withTime &&
			` ${dateString.substr(8, 2)}:${dateString.substr(
				10,
				2
			)}:${dateString.substr(12, 2)}`);
	return time;
}
function savePrro(redirect) {
	const device = document.getElementById('device').value;
	const can_offline = document.getElementById('can_offline').value;
	const auto_open_shift = document.getElementById('auto_open_shift').value;

	if (!device) {
		callTostSnackbar("Потрібно вказати ім'я пристрою");
		return;
	}

	toggleLoader();

	const data = {
		device: device,
		can_offline: can_offline,
		auto_open_shift : auto_open_shift,
	};
	const json = JSON.stringify(data);
	fetch(`${urlLocation}/${apiUrl}prro?dev_id=${deviceId}`, {
		method: 'POST',
		body: json,
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.res !== 0) {
				callTostSnackbar(result.errortxt);
			} else {
				callTostSnackbar('Дані успішно змінено');
				if (redirect) {
					setTimeout(function () {
						window.location = `${urlLocation}/dm/vchasno-kasa/dashboard.html`;
					}, 3000);
				} else {
					getDevice();
				}
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function testPrint() {
	toggleLoader();
	const devName = document.getElementById('device').value;
	const protId = 'E334AB99-3CDC-40CC-96E1-62927CA81F31';

	const url = `${urlLocation}/dm/testprint?dev_id=${deviceId}&prot_id=${protId}&dev_name=${devName}`;
	fetch(url)
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.res === 0) {
				callTostSnackbar('Тест пройдено успішно');
			} else if (result.errortxt) {
				callTostSnackbar(`Помилка ${result.res}: ${result.errortxt}`);
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
async function showPrroGroupsAsync(dataType) {
	const response = await fetch(
		`${urlLocation}/${apiUrl}prro/groups?dev_id=${deviceId}`
	);
	const result = await response.json();
	return result[dataType];
}
function deleteDevice() {
	toggleLoader();

	fetch(`${urlLocation}/${apiUrl}prro?dev_id=${deviceId}&ignore_lock=1`, {
		method: 'DELETE',
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				callTostSnackbar('Пристрій видалено');
				setTimeout(function () {
					window.location = `${urlLocation}/dm/vchasno-kasa/dashboard.html`;
				}, 3000);
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function fillHtmlWithGroups(result) {
	prroGroupsInfoNode.innerText = '';
	if (result.errortxt) {
		callTostSnackbar(result.errortxt);
	} else {
		if (result.fis_groups && result.fis_groups.length) {
			const fisGroupsNode = document.createElement('div');
			fisGroupsNode.insertAdjacentHTML(
				'beforeend',
				'<div class="subtitle">Податкові групи</div>'
			);
			for (let fisGroup of result.fis_groups) {
				let fisGroupRow = `<div class='line'><span class="num">${fisGroup.gr_id}</span><span>${fisGroup.caption}</span><span>(${fisGroup.tg_print})</span></div>`;
				fisGroupsNode.insertAdjacentHTML('beforeend', fisGroupRow);
			}
			prroGroupsInfoNode.appendChild(fisGroupsNode);
		}
		if (result.pay_types && result.pay_types.length) {
			const payTypesNode = document.createElement('div');
			payTypesNode.insertAdjacentHTML(
				'beforeend',
				'<div class="subtitle">Види оплат</div>'
			);
			for (let payType of result.pay_types) {
				let payTypeRow = `<div class='line'><span class="num">${payType.pay_id}</span><span>${payType.caption}</span></div>`;
				payTypesNode.insertAdjacentHTML('beforeend', payTypeRow);
			}
			prroGroupsInfoNode.appendChild(payTypesNode);
		}
	}
}
function showPrroGroups() {
	prroGroupsInfoNode.innerText = 'Loading...';

	fetch(`${urlLocation}/${apiUrl}prro/groups?dev_id=${deviceId}`)
		.then((response) => response.json())
		.then((result) => {
			fillHtmlWithGroups(result);
		});
}
function showPrroInfo() {
	prroInfoNode.innerText = 'Завантаження інформації...';

	fetch(`${urlLocation}/${apiUrl}prro?dev_id=${deviceId}`)
		.then((response) => response.json())
		.then((result) => {
			prroInfoNode.innerText = '';

			if (result.errortxt) {
				callTostSnackbar(result.errortxt);
			} else {
				const prroInfoContainer = document.createElement('div');
				const { shift_autoclosing, max_Offline_Time, max_MonthOffline_Time, ofn_limits, shift_cash_transfer_mode, billing } = result;

				const shiftAutoClose = `
					<div class='line'>
						<span class='title'>Час автозакриття зміни</span>
						<div>
							${shift_autoclosing
						? `${shift_autoclosing.start}-${shift_autoclosing.end}`
						: 'автозакриття зміни відключено'}
						</div>
					</div>
				`;
				const maxOfflineTime = `
					<div class='line'>
						<span class='title'>Максимальний час роботи в режимі офлайн за один перехід<br>(в годинах)</span>
						<div>${max_Offline_Time}</div>
					</div>
				`;
				const maxOfflineTimeMonth = `
					<div class='line'>
						<span class='title'>Максимальний час роботи в режимі офлайн на місяць<br>(в годинах)</span>
						<div>${max_MonthOffline_Time}</div>
					</div>
				`;
				const minOfflineNumbers = `
					<div class='line'>
						<span class='title'>Мінімальна кількість збережених офлайн номерів для роботи ПРРО в режимі офлайн</span>
						<div>${ofn_limits.min}</div>
					</div>
				`;
				const maxOfflineNumbers = `
					<div class='line'>
						<span class='title'>Максимальна кількість офлайн номерів яка запитується в ДПС для роботи ПРРО в режимі офлайн</span>
						<div>${ofn_limits.max}</div>
					</div>
				`;
				let shiftCashTransferModeTxt = 'Залишок готівки передається зі зміни в зміну';
				switch (shift_cash_transfer_mode) {
						case 1:
							shiftCashTransferModeTxt = 'Залишок не передається зі зміни в зміну. Обнулення залишку при відкритті нової зміни.';
							break;
						case 2:
							shiftCashTransferModeTxt = 'Залишок не передається зі зміни в зміну. Обнулення залишку під час закриття зміни, тобто при знятті z-звіту. ';
							break;
					}
				const shiftCashTransfer = `
					<div class='line'>
						<span class='title'>Передача залишку готівки із зміни у зміну</span>
						<div>${shiftCashTransferModeTxt}</div>
					</div>		
				`;
				const paidDateTo = `
					<div class='line'>
						<span class='title'>ПРРО оплачено до</span>
						<div>${billing && billing.paid_date_to ? `${billing.paid_date_to.substr(
					6, 2)}.${billing.paid_date_to.substr(
						4, 2)}.${billing.paid_date_to.substr(
							0, 4)} ${billing.paid_date_to.substr(
								8, 2)}:${billing.paid_date_to.substr(
									10, 2)}:${billing.paid_date_to.substr(
										12, 2)}` : 'Немає даних'}</div>
					</div>				
				`;
				let enoughToRenewSubscriptionTxt = 'Не вдалось визначити. Не вистачає коштів для активації усіх ПРРО в день деактивації по компанії. ПРРО може не активуватись автоматично якщо кошти будуть списані з балансу іншим ПРРО.';
				if (billing) {
					switch (billing.enough_to_renew_subscription) {
						case 1:
							enoughToRenewSubscriptionTxt = 'В наявності, підписка на ПРРО продовжиться автоматично після закінчення терміну дії поточної.';
							break;
						case 2:
							enoughToRenewSubscriptionTxt = 'Відсутні, для того, щоб каса продовжувала працювати після закінчення поточної підписки поповніть баланс в кабінеті Вчасно.Каса.';
							break;
					}
				}
				const enoughToRenewSubscription = `
					<div class='line'>
						<span class='title'>Наявність коштів на балансі для автоматичного продовження підписки</span>
						<div>${enoughToRenewSubscriptionTxt}</div>
					</div>		
				`;

				prroInfoContainer.insertAdjacentHTML('beforeend', shiftAutoClose);
				prroInfoContainer.insertAdjacentHTML('beforeend', maxOfflineTime);
				prroInfoContainer.insertAdjacentHTML('beforeend', maxOfflineTimeMonth);
				prroInfoContainer.insertAdjacentHTML('beforeend', minOfflineNumbers);
				prroInfoContainer.insertAdjacentHTML('beforeend', maxOfflineNumbers);
				prroInfoContainer.insertAdjacentHTML('beforeend', shiftCashTransfer);
				prroInfoContainer.insertAdjacentHTML('beforeend', paidDateTo);
				prroInfoContainer.insertAdjacentHTML('beforeend', enoughToRenewSubscription);
				prroInfoNode.appendChild(prroInfoContainer);
			}
		});
}
function postPrroGroups() {
	toggleLoader();
	fetch(`${urlLocation}/${apiUrl}prro/groups?dev_id=${deviceId}`, {
		method: 'POST',
		body: "{}",
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				fillHtmlWithGroups(result);
				callTostSnackbar('Налаштування синхронізовано');
				getDevice();
				showPrroGroups();
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function hideModalSignInfo() {
	document.getElementById('modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
}
function showModalSignInfo() {
	const sign_from_cloud = document.getElementById('sign_from_cloud');
	sign_from_cloud.addEventListener("change", (e) => {
		if (e.target.checked) {
			document.getElementById('key_block').classList.add('hidden');
		} else {
			document.getElementById('key_block').classList.remove('hidden');
		}
	});
	hideModalAsk();
	document.getElementById('modal').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}

function hideModalExecuteSql() {
	document.getElementById('executesql').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
	document.getElementById('error-text-sql').classList.add('hidden');
	document.getElementById('error-text-sql').innerText = '';
}
function showModalExecuteSql() {
	document.getElementById('executesql').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}

function showModalAsk(actionName) {
	document.getElementById('modal-ask-before-action').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
	if (actionName.name === 'openShift') {
		document.querySelector('.actionQuestion').innerHTML = 'Відкрити зміну?';
	} else if (actionName.name === 'renewHashChain') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b>Увага!</b></p><p>Дану функцію дозволено використовувати тільки після консультації зі службою підтримки.</p><p><b>!!!</b> Самостійне використання цієї функції може привести до втрати або дублювання документів.</p>';
		document
			.getElementById('modal-ask-before-action')
			.classList.add('renewHashChain');
	} else if (actionName.name === 'showModalSignInfo') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b>Увага!</b></p><p><b>!!!</b> Ви змінюєте ЕЦП впродовж відкритої зміни.</p ><p>Обов\'язково зареєструйте ключ ЕЦП в ДПС перед заміною. Після заміни ключа ПРРО блокується для проведення чеків та переходу в оффлайн, доступно лише закриття зміни. Потрібно одразу закрити зміну по ПРРО після чого можна продовжити роботу.</p> ';
		document
			.getElementById('modal-ask-before-action')
			.classList.add('renewHashChain');
		document.getElementById('is-alarm').value = true;
	} else if (actionName.name === 'getXReport') {
		document.querySelector('.actionQuestion').innerHTML = 'Запросити X-звіт?';
	} else if (actionName.name === 'getZReport') {
		document.querySelector('.actionQuestion').innerHTML = 'Запросити Z-звіт?';
	} else if (actionName.name === 'changeTokenVchasno') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p>Змінити токен Вчасно.Каса для даного ПРРО?</p><div class="line"><label for="new-token-vchasno">Новий токен сформований в кабінеті Вчасно.Каса</label><input type="text" name="vchasno_token" id="new-token-vchasno" /></div>';
	} else if (actionName.name === 'deleteDevice') {
		document
			.getElementById('modal-ask-before-action')
			.classList.add('renewHashChain');
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b>Увага!</b></p><p><b>!!!</b> Аварійне видалення ПРРО можна використати у випадку коли ПРРО знято з реєстрації або більше не фіскалізуватиме чеків. Видалення ПРРО призведе до втрати всіх нефіскалізованих чеків якщо ПРРО знаходиться в режиму офлайн</p>';
	} else if (actionName.name === 'postPrroGroups') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p>Оновити налаштування ПРРО з кабінету Вчасно.Каса ?</p>';
	} else if (actionName.name === 'restartPrro') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b>Увага!</b></p><p><b>!!!</b> Перезапуск ПРРО дозволений у випадку проведення технічних робіт з ПРРО. Рекомендовано використовувати у випадку "зависання" ПРРО та отримання помилки "Пристрій зайнятий".</p>';
	} else if (actionName.name === 'manualGoOffline') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b class="alert">Увага!</b></p><p>Виконання даної операції переведе ПРРО в режим роботи офлайн. За замовчуванням час роботи в офлайні 20хв після переходу. Після цього автоматично буде здійснено реєстрацію офлайнових чеків в ДПС і перехід до режиму онлайн.</p>';
	} else if (actionName.name === 'disablePrro') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b class="alert">Увага!</b></p><p>Виконання даної операції заблокує ПРРО для подальшої роботи. По ПРРО не будуть доступні будь які операції до розблокування.</p><p>Можна використовувати у випадках коли потрібно на якийсь час заблокувати ПРРО і точно бути впевненим що ПРРО не будуть проводитись ніякі операції.</p>';
	} else if (actionName.name === 'enablePrro') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b class="alert">Увага!</b></p><p>Виконання даної операції розблокує ПРРО для проведення чеків та виконання інших операцій. ПРРО може блокуватись автоматично якщо виникла помилка яка вимагатиме ручного втручання, або вручну, дана операція дозволяє примусово розблокувати ПРРО.</p>';
	} else if (actionName.name === 'deleteLastReceipt') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b class="alert">Увага!!!</b></p><p>Виконання даної операції дозволяє видалити останній проведений чек з ДПС та з додатку.<br> Наголошуємо що видалити можна <b>лише останній чек</b>, <b>лише один раз</b>, <b>лише якщо ПРРО знаходиться в режимі онлайн</b> і <b>лише якщо чек один із наступних:</b><br><b>Продаж(1)</b><br><b>Повернення(2)</b><br><b>Внесення коштів(3)</b><br><b>Винесення коштів(4)</b><br><b>Чек видачі готівки держателям ЕПЗ(14)</b><br><p><b class="alert">Наголошуємо що видалення кількох чеків підряд по схемі: "фіскалізація чеку - видалення чеку" призведе до помилок в роботі ПРРО і подальшої розбіжності в звітах.</b></p><p><b class="alert">Видаляти останній чек можна лише один раз!</b></p>Даний функціонал можна використовувати лише у випадку коли <b>лише одну операцію продажу/поверення чи внесення або видачі коштів</b> було проведено помилково.</p>';
	} else if (actionName.name === 'enableForcedOnlineMode') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b class="alert">Увага!</b></p><p>Дану функцію рекомендовано використовувати тільки після консультації зі службою підтримки.</p><p>Перед виконанням даної функції необхідно перевірити, що ПРРО знаходиться в offline режимі та не надсилає чеків на реєстрацію до ДФС.</p><p>Якщо виконання не допомогло касі зареєструвати офлайнові чеки та повернутись до режиму online - рекомендується звернутись на лінію підтримки та повідомити помилку, яку відображено нижче.</p><p><b class="alert">!!!</b> Самостійне використання цієї функції може призвести до втрати або дублювання документів.</p>';
	} else if (actionName.name === 'startReverseSync') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b class="alert">Увага!</b></p><p>Синхронізація чеків останньої зміни дозволяє завантажити відсутні чеки з кабінету Вчасно.Каса для продовження роботи ПРРО.</p><p><b class="alert">!!!</b> Якщо запущено синхронізацію без видалення чеків - буде перевірено чи наявні всі потрібні чеки в поточній зміні, та в разі їх відсутності завантажено, для продовження роботи. Рекомендовано використовувати у випадку якщо потрібно лише синхронізувати дані останньої зміни зі збереженням всієї історії чеків <br>При синхронізації з видаленням чеків після запуску буде видалено всі чеки що збережені локально в застосунку по касі і завантажено лише чеки за останню зміну по ПРРО. Рекомендовано використовувати якщо ПРРО працювало на іншому пристрої або тривалий час не працювало в цьому Device Manager.</p><p>Чеки за попередні зміни будуть доступні у кабінеті Вчасно.Каса</p><p><label><input type="checkbox" id="removeExistingReceipts" />&nbsp;Запуск з видаленням чеків</label</p>';
	} else if (actionName.name === 'splitShiftOffline') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b class="alert">Увага!</b></p><p>Дану функцію рекомендовано використовувати тільки після консультації зі службою підтримки.</p><p>Дана функція дозволяє виправити проблему з переходом каси з офлайн до онлайн режиму із за ситуації коли закінчився або був скасований ключ для підпису чеків посеред відкритої зміни. Після виконання даної дії у вас з\'явиться додатковий Z-звіт, тому необхідно врахувати що перший Z-звіт сформований та надрукований в період роботи каси в офлайн режимі буде зареєстрований в ДПС з іншими даними. На суму обігу, податку, залишок в касі і тд. дане розділення не впливає, всі дані будуть передані кореткно у вигляді 2-х окремих звітів.</p><p>Перед виконанням даної функції необхідно перевірити, що ПРРО знаходиться в offline режимі та має проблему з переходом до режиму офлайн із за заміни ключа.</p>';
	} else if (actionName.name === 'homeSweetHome') {
		document.querySelector('.actionQuestion').innerHTML =
			'<p><b class="alert">Увага!</b></p><p>Дану функцію рекомендовано використовувати тільки після консультації зі службою підтримки.</p><p>Дана функція дозволяє відновити роботу ПРРО у ситуації якщо по касі формувались чеки через іншого провайдера ПРРО.</p>';
	}
	document.querySelector('.approveActionButton').onclick = function () {
		actionName();
	};
}

/*add signInfo*/
document.signInfoForm.onsubmit = function (e) {
	e.preventDefault();
	toggleLoader();
	if (document.getElementById('sign_from_cloud').checked) {
		const json = JSON.stringify({
			device: document.getElementById('device').value,
			can_offline: document.getElementById('can_offline').checked,
			auto_open_shift: document.getElementById('auto_open_shift').checked,
			sign_mode: 2,
		});

		fetch(`${urlLocation}/dm/api/v3/prro?dev_id=${deviceId}`, {
			method: 'POST',
			body: json,
		})
			.then((response) => response.json())
			.then(async (result) => {
				toggleLoader();
				if (result.errortxt) {
					document.getElementById('error-prev-key').innerText = result.errortxt;
				} else {
					document.getElementById('error-prev-key').innerText = '';
					hideModalSignInfo();
					getDevice();
					callTostSnackbar(`Увімкнено підписання з хмарного сховища Вчасно.Каса`);
				}
			})
			.catch(function (error) {
				toggleLoader();
				callTostSnackbar(`Request failed: ${error}`);
			});
	} else {
		const sign = document.getElementById('prev-key-file').value;
		const acsk_name = document.getElementById('aCSKName').value;
		const alias = document.getElementById('aliasName').value;
		const pass = document.getElementById('prev-key-pass').value;
		const alarm = document.getElementById('is-alarm').value;
		const cloud_sign = document.getElementById('cloud-cap-button').classList.contains('active');
		const client_id = document.getElementById('clientId').value;
		let data;

		if (cloud_sign === true) {
			data = {
				cloud_sign,
				client_id,
				pass,
				alarm,
			}
		} else {
			data = {
				cloud_sign,
				sign,
				acsk_name,
				alias,
				pass,
				alarm,
			}
		}
		const json = JSON.stringify(data);
		fetch(`${urlLocation}/${apiUrl}prro/sign?dev_id=${deviceId}`, {
			method: 'POST',
			body: json,
		})
			.then((response) => response.json())
			.then(async (result) => {
				toggleLoader();
				if (result.errortxt) {
					document.getElementById('error-prev-key').innerText = result.errortxt;
				} else {
					document.getElementById('error-prev-key').innerText = '';
					hideModalSignInfo();
					getDevice();

					document.getElementById('loaded-keyfile').classList.add('hidden');


					if (document.getElementById('cloud-cap-button').classList.contains('active')) {
						callTostSnackbar(`Ключ завантажено, необхідно підтвердити сесію підписання`);
					} else {
						await checkKeyRegistered();
					}
				}
			})
			.catch(function (error) {
				toggleLoader();
				callTostSnackbar(`Request failed: ${error}`);
			});
	}
};
async function checkKeyRegistered() {
	toggleLoader();
	fetch(`${urlLocation}/dm/api/v3/check-registered-signer?dev_id=${deviceId}`, {
		method: 'GET',
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.key_is_registred === -1 && result.res === 0) {
				document.getElementById('modal-ask-before-action').classList.remove('hidden');
				document.getElementById('overlay').classList.remove('hidden');
				let modalTitle = document.querySelector('#modal-ask-before-action .modal-title');
				modalTitle.textContent = 'Перевірка реєстрації ключа ЕЦП в ДПС';
				document.querySelector('.actionQuestion').innerHTML = `
        <p>Сталась помилка при автоматичній перевірці реєстрації ключа ЕЦП в ДПС.</p>
        <p>Якщо ключ було зареєстровано, дане вікно можна закрити, якщо реєстрацію не виконували - перш ніж почати роботу з ПРРО необхідно зареєструвати ключ ЕЦП за допомогою форми "Реєстрація ключа" в кабінеті Вчасно.Каса (https://kasa.vchasno.ua/app/forms) або через кабінет податкової заповнивши форму 5ПРРО.</p>
		<p><b class="alert">Можлива проблема з доступом до кабінету Вчасно.Каса або внутрішня помилка.</b></p>`;
				document.querySelector('.approveActionButton').onclick = function () {
					window.open('https://kasa.vchasno.ua/app/forms', '_blank');
					hideModalAsk();
				};
				document.querySelector('.approveActionButton').textContent = 'Перейти до реєстрації';
			}
			else if (result.key_is_registred === 0) {
				document.getElementById('modal-ask-before-action').classList.remove('hidden');
				document.getElementById('overlay').classList.remove('hidden');
				let modalTitle = document.querySelector('#modal-ask-before-action .modal-title');
				modalTitle.textContent = 'Перевірка реєстрації ключа ЕЦП в ДПС';
				document.querySelector('.actionQuestion').innerHTML = '<p>Сталась помилка при автоматичній перевірці реєстрації ключа ЕЦП в ДПС.</p><p>Якщо ключ було зареєстровано, дане вікно можна закрити, якщо реєстрацію не виконували - перш ніж почати роботу з ПРРО необхідно зареєструвати ключ ЕЦП за допомогою форми "Реєстрація ключа" в кабінеті Вчасно.Каса (https://kasa.vchasno.ua/app/forms) або через кабінет податкової заповнивши форму 5ПРРО.</p><p><b class="alert">Не вдалось отримати інформацію від ДПС про реєстрацію ключа для підписання чеків.</b></p>';
				document.querySelector('.approveActionButton').onclick = function () {
					window.open('https://kasa.vchasno.ua/app/forms', '_blank');
					hideModalAsk();
				};
				document.querySelector('.approveActionButton').textContent = 'Перейти до реєстрації';
			}
			else if (result.key_is_registred === 1) {
				callTostSnackbar('Ключ ЕЦП успішно завантажено. Перевірку ключа в ДПС завершено. Ключ ЕЦП зареєстровано для піписання чеків');
			}
			else if (result.key_is_registred === 2) {
				document.getElementById('modal-ask-before-action').classList.remove('hidden');
				document.getElementById('overlay').classList.remove('hidden');
				let modalTitle = document.querySelector('#modal-ask-before-action .modal-title');
				modalTitle.textContent = 'Перевірка реєстрації ключа ЕЦП в ДПС';
				document.querySelector('.actionQuestion').innerHTML = '<p><b class="alert">Увага потрібно зареєструвати ключ ЕЦП!</b></p><p>Виконано автоматичну перевірку реєстрації ключа ЕЦП в ДПС. Ключ не зареєстровано для підписання чеків!</p> <p>Перш ніж почати роботу з ПРРО необхідно зареєструвати ключ ЕЦП за допомогою форми "Реєстрація ключа" в кабінеті Вчасно.Каса (https://kasa.vchasno.ua/app/forms) або через кабінет податкової заповнивши форму 5ПРРО.</p>';
				document.querySelector('.approveActionButton').onclick = function () {
					window.open('https://kasa.vchasno.ua/app/forms', '_blank');
					hideModalAsk();
				};
				document.querySelector('.approveActionButton').textContent = 'Перейти до реєстрації';
			}
			else if (result.key_is_registred === 3) {
				callTostSnackbar('Ключ ЕЦП успішно завантажено. Перевірка реєстрації ЕЦП в ДПС не виконується, каса тестова.');
			}
			else {
				document.getElementById('modal-ask-before-action').classList.remove('hidden');
				document.getElementById('overlay').classList.remove('hidden');
				let modalTitle = document.querySelector('#modal-ask-before-action .modal-title');
				modalTitle.textContent = 'Перевірка реєстрації ключа ЕЦП в ДПС';
				document.querySelector('.actionQuestion').innerHTML = `
        <p>Сталась помилка при автоматичній перевірці реєстрації ключа ЕЦП в ДПС.</p>
        <p>Якщо ключ було зареєстровано, дане вікно можна закрити, якщо реєстрацію не виконували - перш ніж почати роботу з ПРРО необхідно зареєструвати ключ ЕЦП за допомогою форми "Реєстрація ключа" в кабінеті Вчасно.Каса (https://kasa.vchasno.ua/app/forms) або через кабінет податкової заповнивши форму 5ПРРО.</p>
        <p><b class="alert">Можлива проблема з доступом до кабінету Вчасно.Каса або внутрішня помилка: ${result.errortxt}</b></p>`;
				document.querySelector('.approveActionButton').onclick = function () {
					window.open('https://kasa.vchasno.ua/app/forms', '_blank');
					hideModalAsk();
				};
				document.querySelector('.approveActionButton').textContent = 'Перейти до реєстрації';
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function keyTypeChangeHandler(cloud_sign) {
	if (cloud_sign === 'false') {
		document.getElementById('file-key-container').classList.remove('hidden');
		document.getElementById('acsk-name-container').classList.remove('hidden');
		document.getElementById('loaded-keyfile').classList.remove('hidden');
		document.getElementById('file-key-button').classList.add('active');
		document.getElementById('cloud-cap-button').classList.remove('active');
		document.getElementById('key-client-id-container').classList.add('hidden');
		if (loadedFileExtension === 'jks') {
			document.getElementById('key-alias').classList.remove('hidden');
		}
	} else {
		document.getElementById('file-key-container').classList.add('hidden');
		document.getElementById('acsk-name-container').classList.add('hidden');
		document.getElementById('loaded-keyfile').classList.add('hidden');
		document.getElementById('file-key-button').classList.remove('active');
		document.getElementById('cloud-cap-button').classList.add('active');
		document.getElementById('key-client-id-container').classList.remove('hidden');
		document.getElementById('key-alias').classList.add('hidden');
	}
}
function checkSignSessionState() {
	toggleLoader();
	fetch(`${urlLocation}/dm/api/v3/sign-session-state?dev_id=${deviceId}`, {
		method: 'GET'
	})
		.then((response) => response.json())
		.then((result) => {
			getDevice();
			toggleLoader();
			if (result.res > 0) {
				callTostSnackbar(`При перевірці сталась помилка ${result.errortxt}`);
			} else {
				callTostSnackbar(`Статус: ${result.session_state_code}, ${result.session_state_text}`);
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}

function getSignAliases(b64) {
	let b64Cut = b64.split('base64,')[1];
	const data = {
		sign: b64Cut
	};

	const jsonData = JSON.stringify(data);
	toggleLoader();
	fetch(`${urlLocation}/dm/api/v3/prro/sign_aliases`, {
		method: 'POST',
		headers: {
			'Content-Type': 'text/json',
		},
		body: jsonData,
	})
		.then((response) => response.json())
		.then((result) => {
			const nodeConfSelect = document.getElementById('aliasName');
			while (nodeConfSelect.options.length > 0) {
				nodeConfSelect.remove(0);
			}
			if (result) {
				for (let objVal of result) {
					nodeConfSelect.options[nodeConfSelect.options.length] = new Option(
						objVal,
						objVal
					);
				}
			}

			toggleLoader();
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}

document.executeSqlForm.onsubmit = function (e) {
	e.preventDefault();
	toggleLoader();
	const command = document.getElementById('sql-command').value;

	fetch(`${urlLocation}/dm/executesql`, {
		method: 'POST',
		headers: {
			'Content-Type': 'text/plain',
		},
		body: command,
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.res === 0) {
				hideModalExecuteSql();
				callTostSnackbar('Скрипт виконано успішно');
				getDevice();
			} else if (result.errortxt) {
				document.getElementById('error-text-sql').classList.remove('hidden');
				document.getElementById('error-text-sql').innerText = result.errortxt;
			} else {
				document.getElementById('error-text-sql').classList.remove('hidden');
				document.getElementById(
					'error-text-sql'
				).innerText = `Помилка ${result.res}`;
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
};
function deletePrevKey() {
	toggleLoader();
	fetch(`${urlLocation}/${apiUrl}prro/sign?dev_id=${deviceId}`, {
		method: 'DELETE',
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				callTostSnackbar(result.errortxt);
			} else {
				callTostSnackbar('Приватний ключ видалено');
				generatePrevKeyInfoBlock(false, false);
				getDevice();
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
document.getElementById('loaded-keyfile').querySelector('span').innerHTML = "Файл ключа ЕЦП не обрано";
/*format key data to base64 format*/
function addFilePrevKey(fileInput) {
	let file = fileInput.files[0],
		reader = new FileReader();

	if (!file) {
		document.getElementById('loaded-keyfile').classList.remove('hidden');
		document.getElementById('loaded-keyfile').querySelector('span').innerHTML = "Файл ключа ЕЦП не обрано";
		return;
	}

	// Check if the selected keyfile has a valid extension
	const allowedExtensions = ['dat', 'jks', 'zs2', 'pfx', 'pk8'];
	const fileExtension = file.name.split('.').pop().toLowerCase();
	loadedFileExtension = file.name.split('.').pop().toLowerCase();
	if (!allowedExtensions.includes(fileExtension)) {
		document.getElementById('loaded-keyfile').classList.remove('hidden');

		document.getElementById('loaded-keyfile').querySelector('span').innerHTML = "Некоректне розширення файлу ключа ЕЦП. Оберіть файл з розширенням із перелічених: '.dat', '.jks', '.zs2', '.pfx', '.pk8'";
		return;
	}

	reader.onload = function(e) {

	};

	reader.readAsDataURL(file);
	reader.onloadend = function () {
		let b64 = reader.result;
		setPrivKeyFile(file.name, b64);
		document.getElementById('loaded-keyfile').classList.remove('hidden');
		let loadedKeyFileDiv = document.getElementById('loaded-keyfile');
		loadedKeyFileDiv.innerHTML = '<img src="images/attached.png"><span>Обрано файл: ' + file.name + '</span>';

		if (fileExtension === 'jks') {
			getSignAliases(b64);
			document.getElementById('key-alias').classList.remove('hidden');
		} else {
			document.getElementById('key-alias').classList.add('hidden');
			const nodeConfSelect = document.getElementById('aliasName');
			while (nodeConfSelect.options.length > 0) {
				nodeConfSelect.remove(0);
			}
		}
	};
	if (!allowedExtensions.includes(fileExtension)) {
		document.getElementById('loaded-keyfile').classList.remove('hidden');

		document.getElementById('loaded-keyfile').querySelector('span').innerHTML = "Некоректне розширення файлу ключа ЕЦП. Оберіть файл з розширенням із перелічених: '.dat', '.jks', '.zs2', '.pfx', '.pk8'";
		return;
	}
}
/*write key data in hidden input prev-key-file and select acsk*/
function setPrivKeyFile(fileName, b64) {
	let b64Cut = b64.split('base64,')[1];
	let fileExtension = fileName.split('.')[1];
	fileExtension = fileExtension.toUpperCase();
	let aCSKNameNode = document.getElementById('aCSKName');

	document.getElementById('prev-key-file').value = b64Cut;

	if (fileExtension === 'JKS') {
		aCSKNameNode.value = 'КНЕДП АЦСК АТ КБ "ПРИВАТБАНК"';

	} else if (fileExtension === 'ZS2') {
		aCSKNameNode.value = 'КНЕДП ТОВ "Центр сертифікації ключів "Україна"';
	}
}
function disableEnableEdit(canEdit, showDeleteButton) {
	if (canEdit) {
		document.querySelector('.change-prev-key').classList.remove('hidden');
		showDeleteButton &&
			document.querySelector('.delete-prev-key').classList.remove('hidden');
		document.getElementById('can_offline').disabled = false;
		document.getElementById('auto_open_shift').disabled = false;
		document.getElementById('device').disabled = false;
	} else {
		document.querySelector('.change-prev-key').classList.add('hidden');
		document.querySelector('.delete-prev-key').classList.add('hidden');
		document.getElementById('can_offline').disabled = true;
		document.getElementById('auto_open_shift').disabled = true;
		document.getElementById('device').disabled = true;
	}
}
function getAcskList() {
	fetch(
		`${urlLocation}/dm/protocollist?model_id=5D4E5A1E-EF3E-40E8-AA58-CBE3B6F28A01`
	)
		.then((response) => response.json())
		.then((result) => {
			if (result.errortxt) {
				callTostSnackbar(result.errortxt);
			} else {
				acskList = JSON.parse(result.protocolList[0]['specConfT'])[
					'ACSKName'
				];
				const nodeConfSelect = document.getElementById('aCSKName');
				nodeConfSelect.onchange = () => {
					document.getElementById('prev-key-pass').value = '';
				};
				if (acskList) {
					for (let objVal of acskList) {
						nodeConfSelect.options[nodeConfSelect.options.length] = new Option(
							objVal,
							objVal
						);
					}
				}
			}
		});
}
function validateCheckBox(checkboxNode) {
	if (checkboxNode.checked) {
		checkboxNode.value = true;
		checkboxNode.checked = true;
	} else {
		checkboxNode.value = false;
		checkboxNode.checked = false;
	}
}
function getCurrentDateForExecute() {
	const currentDate = new Date();
	const currentDateDate =
		currentDate.getDate() < 10
			? `0${currentDate.getDate()}`
			: currentDate.getDate();
	const currentDateMinutes =
		currentDate.getMinutes() < 10
			? `0${currentDate.getMinutes()}`
			: currentDate.getMinutes();
	const currentDateSeconds =
		currentDate.getSeconds() < 10
			? `0${currentDate.getSeconds()}`
			: currentDate.getSeconds();
	const currentDateHours =
		currentDate.getHours() < 10
			? `0${currentDate.getHours()}`
			: currentDate.getHours();

	let currentDateMonth = currentDate.getMonth() + 1;
	currentDateMonth =
		currentDateMonth < 10 ? `0${currentDateMonth}` : currentDateMonth;
	const dateFormatted = `${currentDate.getFullYear()}${currentDateMonth}${currentDateDate}${currentDateHours}${currentDateMinutes}${currentDateSeconds}`;
	return dateFormatted;
}
function openShift() {
	toggleLoader();
	let dateFormatted = getCurrentDateForExecute();
	const data = {
		ver: 6,
		source: 'vkUi',
		device: document.getElementById('device').value,
		tag: '',
		sign: '',
		dt: dateFormatted,
		type: 1,
		fiscal: {
			task: 0,
		},
	};
	const jsonData = JSON.stringify(data);

	fetch(`${urlLocation}/dm/execute`, {
		method: 'POST',
		body: jsonData,
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();

			if (result.errortxt || result.aq_errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					`<p>${result.errortxt || ''}</p>
					<p>${result.aq_errortxt || ''}</p>`;
			} else {
				hideModalAsk();
				callTostSnackbar('Зміну відкрито');
				getDevice();
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function changeTokenVchasno() {
	toggleLoader();
	const vchasno_token = document.getElementById('new-token-vchasno').value;
	const data = {
		vchasno_token,
	};
	const json = JSON.stringify(data);
	fetch(`${urlLocation}/${apiUrl}prro/token_vchasno?dev_id=${deviceId}`, {
		method: 'POST',
		body: json,
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				callTostSnackbar('Токен змінено');
				getDevice();
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function renewHashChain() {
	toggleLoader();
	fetch(`${urlLocation}/${apiUrl}hash-chain?dev_id=${deviceId}`)
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				callTostSnackbar('Послідовність чеків відновлено');
				getDevice();
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function restartPrro() {
	toggleLoader();
	fetch(`${urlLocation}/${apiUrl}device_off?dev_id=${deviceId}`)
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				callTostSnackbar('Перезапуск ПРРО виконано успішно');
				getDevice();
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function fillXReportData(data, reportDate, zReport) {
	showModalXReport();
	zReport && (modalXReport.querySelector('.modal-title').innerText = 'Z-звіт');
	const modalXReportBody = modalXReport.querySelector('.body');
	modalXReportBody.innerText = '';
	const topBox = document.createElement('div');
	topBox.classList.add('shadow-box');
	const zReportDocNum = zReport
		? `<div class="line"><span>Фіскальний номер документу:</span><b>${data.doccode}</b></div>`
		: '';
	const header_line = `<div class="line"><span>${formatDate(
		reportDate
	)}</span><b>${data.fisid}</b></div>`;

	const checkCountLine = `<div class="line-box"><span>Кількість чеків <b>${data.receipt.count_p + data.receipt.count_m
		}</b></span>
	<div class="checks"><div><label>Продаж</label>${generateInput(
			data.receipt.count_p,
			'text',
			true
		)}</div>
	<div><label>Повернення</label>${generateInput(
			data.receipt.count_m,
			'text',
			true
		)}</div></div></div>`;
	const safeStartShiftLine = `<div class="line-box"><span>Залишок на початок зміни<b>&nbsp;${formatNumber(data.safe_start_shift)}</b></span></div>`;
	const safeSummLine = `<div class="line-box"><span>Залишок у фіскальній касі<b>&nbsp;${formatNumber(data.safe)}</b></span></div>`;
	zReport && topBox.insertAdjacentHTML('beforeend', zReportDocNum);
	topBox.insertAdjacentHTML('beforeend', header_line);
	topBox.insertAdjacentHTML('beforeend', checkCountLine);
	topBox.insertAdjacentHTML('beforeend', safeStartShiftLine);
	topBox.insertAdjacentHTML('beforeend', safeSummLine);
	modalXReportBody.appendChild(topBox);

	/* Tax box */
	if (data.taxes && data.taxes.length) {
		const taxesNode = document.createElement('div');
		taxesNode.classList.add('shadow-box');
		const taxesHead = `<div class="subheader">Податки</div><div class="taxes-head"><div>Код</div><div>Операція</div><div>База оподатк.</div><div>Податок</div><div>Сума податку</div><div>Акциз</div><div>Сума акцизу</div></div>`;
		taxesNode.insertAdjacentHTML('beforeend', taxesHead);
		for (let tax of data.taxes) {
			let taxesRow = `<div class="taxes-row">
		<div>${tax.gr_code}</div>
		<div class="with-label">
			<div class="save-with-label"><label>Продаж</label>${generateInput(
				formatNumber(tax.base_sum_p),
				'text',
				true
			)}</div>
			<div class="return-with-label"><label>Повернення</label>${generateInput(
				formatNumber(tax.base_sum_m),
				'text',
				true
			)}</div>
		</div>
		<div>${tax.tax_name}</div>
		<div>
			<div class="save">${generateInput(formatNumber(tax.tax_sum_p), 'text', true)}</div>
			<div class="return">${generateInput(formatNumber(tax.tax_sum_m), 'text', true)}</div>
		</div>
		<div>${tax.ex_name}</div>
		<div>
			<div class="save">${generateInput(formatNumber(tax.ex_sum_p), 'text', true)}</div>
			<div class="return">${generateInput(formatNumber(tax.ex_sum_m), 'text', true)}</div>
		</div>
		</div>`;

			taxesNode.insertAdjacentHTML('beforeend', taxesRow);
		}
		modalXReportBody.appendChild(taxesNode);
	}

	/* Payment box */
	if (data.pays && data.pays.length) {
		const paymentsNode = document.createElement('div');
		paymentsNode.classList.add('shadow-box');
		const paymentsHead = `<div class="subheader">Оплати</div><div class="payment-head"><div>Код</div><div>Назва</div><div>Продаж</div><div>Повернення</div><div>Округлення продажу +</div><div>Округлення продажу  &nbsp;-</div><div>Округлення видачі  +</div><div>Округлення видачі  &nbsp;-</div></div>`;
		paymentsNode.insertAdjacentHTML('beforeend', paymentsHead);

		for (let payment of data.pays) {
			let paymentRow = `<div class="payment-row">
		<div>${payment.type}</div>
		<div>${payment.name}</div>
		<div>${generateInput(formatNumber(payment.sum_p), 'text', true)}</div>
		<div>${generateInput(formatNumber(payment.sum_m), 'text', true)}</div>
		<div>${generateInput(formatNumber(payment.round_pu), 'text', true)}</div>
		<div>${generateInput(formatNumber(payment.round_pd), 'text', true)}</div>
		<div>${generateInput(formatNumber(payment.round_mu), 'text', true)}</div>
		<div>${generateInput(formatNumber(payment.round_md), 'text', true)}</div>
		</div>`;
			paymentsNode.insertAdjacentHTML('beforeend', paymentRow);
		}
		modalXReportBody.appendChild(paymentsNode);
	}
	/* Money box */
	if (data.money && data.money.length) {
		const moneyNode = document.createElement('div');
		moneyNode.classList.add('shadow-box');
		const moneyHead = `<div class="subheader">Службові внесення/винесення грошей</div><div class="payment-head"><div>Код</div><div>Назва</div><div>Внесення</div><div>Винесення</div></div>`;
		moneyNode.insertAdjacentHTML('beforeend', moneyHead);

		for (let money of data.money) {
			let moneyRow = `<div class="money-row">
						<div>${money.type}</div>
						<div>${money.name}</div>
						<div>${generateInput(formatNumber(money.sum_p), 'text', true)}</div>
						<div>${generateInput(formatNumber(money.sum_m), 'text', true)}</div>
						</div>`;
			moneyNode.insertAdjacentHTML('beforeend', moneyRow);
		}
		modalXReportBody.appendChild(moneyNode);
	}
	/* Cash output */
	if (data.cash && data.cash.length) {
		const paymentOutputNode = document.createElement('div');
		paymentOutputNode.classList.add('shadow-box');
		const paymentOutputHead = `<div class="subheader">Видачі коштів</div><div class="cash-head"><div>Загальна сума видачі</div><div>Загальна сума комісії</div></div>`;
		paymentOutputNode.insertAdjacentHTML('beforeend', paymentOutputHead);

		for (let cash of data.cash) {
			let cashRow = `<div class="cash-row">
						<div>${generateInput(formatNumber(cash.sum_m), 'text', true)}</div>
						<div>${generateInput(formatNumber(cash.round_mu), 'text', true)}</div>
						</div>`;
			paymentOutputNode.insertAdjacentHTML('beforeend', cashRow);
		}
		modalXReportBody.appendChild(paymentOutputNode);
	}
}
function getZReport() {
	toggleLoader();
	let dateFormatted = getCurrentDateForExecute();
	const data = {
		ver: 6,
		source: 'vkUi',
		device: document.getElementById('device').value,
		tag: '',
		sign: '',
		dt: dateFormatted,
		type: 1,
		fiscal: {
			task: 11,
		},
	};
	const jsonData = JSON.stringify(data);

	fetch(`${urlLocation}/dm/execute`, {
		method: 'POST',
		body: jsonData,
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				callTostSnackbar('Звіт успішно виконано');
				getDevice();
			}
			if (result.errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				fillXReportData(result.info, result.dt, true);
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function getXReport() {
	toggleLoader();
	const modalXReportBody = modalXReport.querySelector('.body');

	fetch(`${urlLocation}/${apiUrl}Xreport?dev_id=${deviceId}`)
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				fillXReportData(result.info, result.dt);
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}

function generateInput(inputValue, inputType, inputDisabled) {
	return `<input type="${inputType}" value="${inputValue}" ${inputDisabled ? 'disabled' : ''
		}>`;
}
function showModalXReport() {
	modalXReport.classList.remove('hidden');
	overlay.classList.remove('hidden');
}
function hideModalXReport() {
	modalXReport.classList.add('hidden');
	overlay.classList.add('hidden');
	modalXReport.querySelector('.modal-title').innerText = 'X-звіт';
}
function goToLogs() {
	window.location = `${urlLocation}/dm/vchasno-kasa/logs.html?dev_id=${deviceId}`;
}

function goToBatchSettings() {
	window.location = `${urlLocation}/dm/vchasno-kasa/batch-settings.html?dev_id=${deviceId}`;
}

function goToDashboard() {
	window.location = `${urlLocation}/dm/vchasno-kasa/dashboard.html`;
}

function goToEmulationSettings() {
	window.location = `${urlLocation}/dm/vchasno-kasa/emulation-settings.html?dev_id=${deviceId}`;
}
function hideModalSafeSumm() {
	document.getElementById('safeSumm').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
	document.getElementById('error-text-safe-summ').classList.add('hidden');
	document.getElementById('error-text-safe-summ').innerText = '';
	safeSumm.value = "0";
	postSafeSummButton.disabled = false;
}
function showModalSafeSumm() {
	document.getElementById('safeSumm').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}
document.executeSafeSummForm.onsubmit = function (e) {
	e.preventDefault();
	toggleLoader();

	const url = `${urlLocation}/dm/vchasno-kasa/api/v1/setshiftsafe?dev_id=${deviceId}`;

	fetch(url, {
		method: 'POST',
		headers: {
			'Content-Type': 'application/json',
		},
		body: JSON.stringify({
			safe: Number.parseFloat(safeSumm.value),
		})
	})
		.then(response => response.json())
		.then(result => {
			toggleLoader();
			if (result.res === 0) {
				hideModalSafeSumm();
				callTostSnackbar('Початкова сума зафіксована');
			} else if (result.errortxt) {
				document.getElementById('error-text-safe-summ').classList.remove('hidden');
				document.getElementById('error-text-safe-summ').innerText = result.errortxt;
			} else {
				document.getElementById('error-text-safe-summ').classList.remove('hidden');
				document.getElementById(
					'error-text-safe-summ'
				).innerText = `Помилка ${result.res}`;
			}
		})
		.catch(err => {
			toggleLoader();
			callTostSnackbar(`Request failed: ${err}`);
		})
};

function disablePrro() {
	toggleLoader();
	fetch(`${urlLocation}/dm/api/v3/disableprro?dev_name=${document.getElementById('device').value}`, {
		method: 'GET',
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.res !== 0 && result.errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				callTostSnackbar(`${result.errortxt}`);
				getDevice();
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}

function enablePrro() {
	toggleLoader();
	fetch(`${urlLocation}/dm/api/v3/enableprro?dev_name=${document.getElementById('device').value}`, {
		method: 'GET',
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.res !== 0 && result.errortxt) {
				document
					.getElementById('error-text-action-ask')
					.classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				callTostSnackbar(`${result.errortxt}`);
				getDevice();
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}

function deleteLastReceipt() {
	toggleLoader();

	const url = `${urlLocation}/dm/execute`;
	const data = {
		ver: 6,
		source: 'VK_UI',
		device: document.getElementById('device').value,
		type: 1,
		fiscal: {
			task: 17
		}
	};
	const jsonData = JSON.stringify(data);
	const errorTextActionAsk = document.getElementById('error-text-action-ask');

	fetch(url, {
		method: 'POST',
		headers: {
			'Content-Type': 'application/json',
		},
		body: jsonData
	})
		.then((response) => response.json())
		.then((result) => {
			if (result.errortxt) {
				errorTextActionAsk.classList.remove('hidden');
				errorTextActionAsk.innerHTML = result.errortxt;
			} else if (result.res === 0) {
				hideModalAsk();
				callTostSnackbar('Останній чек по ПРРО успішно видалено з ДПС та з Device Manager');
				getDevice();
			}
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		}).finally(() => {
		toggleLoader();
	});
}

function manualGoOffline() {
	toggleLoader();

	const url = `${urlLocation}/dm/execute`;
	const data = {
		ver: 6,
		source: 'VK_UI',
		device: document.getElementById('device').value,
		type: 1,
		fiscal: {
			task: 8,
			subtask: 1
		}
	};
	const jsonData = JSON.stringify(data);
	const errorTextActionAsk = document.getElementById('error-text-action-ask');

	fetch(url, {
		method: 'POST',
		headers: {
			'Content-Type': 'application/json',
		},
		body: jsonData
	})
		.then((response) => response.json())
		.then((result) => {
			if (result.errortxt) {
				errorTextActionAsk.classList.remove('hidden');
				errorTextActionAsk.innerHTML = result.errortxt;
			} else if (result.res === 0) {
				hideModalAsk();
				callTostSnackbar('Здійснено перехід в офлайн');
				getDevice();
			}
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		}).finally(() => {
			toggleLoader();
		});
}

function enableForcedOnlineMode() {
	toggleLoader();

	const url = `${urlLocation}/dm/execute`;
	const data = {
		ver: 6,
		source: 'VK_UI',
		device: document.getElementById('device').value,
		type: 1,
		fiscal: {
			task: 9
		}
	};
	const jsonData = JSON.stringify(data);
	const errorTextActionAsk = document.getElementById('error-text-action-ask');

	fetch(url, {
		method: 'POST',
		headers: {
			'Content-Type': 'application/json',
		},
		body: jsonData
	})
		.then((response) => response.json())
		.then((result) => {
			if (result.errortxt) {
				errorTextActionAsk.classList.remove('hidden');
				errorTextActionAsk.innerHTML = result.errortxt;
			} else if (result.res === 0) {
				hideModalAsk();
				callTostSnackbar('Перехід в онлайн здійснено успішно');
				getDevice();
			}
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		}).finally(() => {
			toggleLoader();
		});
}

function splitShiftOffline() {
	toggleLoader();
	const errorTextActionAsk = document.getElementById('error-text-action-ask');

	fetch(`${urlLocation}/dm/api/v3/split_shift_offline?dev_id=${deviceId}`, {
		method: 'GET',
	})
		.then((response) => response.json())
		.then((result) => {
			if (result.errortxt) {
				errorTextActionAsk.classList.remove('hidden');
				errorTextActionAsk.innerHTML = result.errortxt;
			} else if (result.res === 0) {
				hideModalAsk();
				callTostSnackbar('Розділення зміни завершено.');
				getDevice();
			}
		})
		.catch(function (error) {
			callTostSnackbar(`Помилка запиту: ${error}`);
		}).finally(() => {
		toggleLoader();
	});
}

function homeSweetHome() {
	toggleLoader();
	const errorTextActionAsk = document.getElementById('error-text-action-ask');

	fetch(`${urlLocation}/dm/api/v3/hsh?dev_id=${deviceId}`, {
		method: 'GET',
	})
		.then((response) => response.json())
		.then((result) => {
			if (result.errortxt) {
				errorTextActionAsk.classList.remove('hidden');
				errorTextActionAsk.innerHTML = result.errortxt;
			} else if (result.res === 0) {
				hideModalAsk();
				callTostSnackbar('Відновлення роботи ПРРО виконано успішно.');
				getDevice();
			}
		})
		.catch(function (error) {
			callTostSnackbar(`Помилка запиту: ${error}`);
		}).finally(() => {
		toggleLoader();
	});
}

function startReverseSync() {
	removeExistingReceiptsInReverseSync = document.getElementById('removeExistingReceipts').checked;
	isReverseSyncStarted = true;

	hideModalAsk();
	openReverseSyncModal();
}

function openReverseSyncModal() {
	document.getElementById('modal-reverse-sync').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');

	startReverseSyncModal();
}

function closeReverseSyncModal() {
	if (!isReverseSyncStarted) return;

	const url = `${urlLocation}/${apiUrl}sync_stop`;

	fetch(url)
		.then(response => response.json())
		.then(({ res, errortxt }) => {
			const reverseSyncErrorText = document.getElementById('reverse-sync-error-text');
			const modalReverseSync = document.getElementById('modal-reverse-sync');
			const overlay = document.getElementById('overlay');

			if (res === 0) {
				overlay.classList.add('hidden');
				modalReverseSync.classList.add('hidden');
				reverseSyncErrorText.classList.add('hidden');

				reverseSyncErrorText.innerHTML = '';
				isReverseSyncStarted = false;
			} else if (errortxt) {
				reverseSyncErrorText.classList.remove('hidden');
				reverseSyncErrorText.innerHTML = result.errortxt;
			}
		})
		.catch(err => {
			callTostSnackbar(`Request failed: ${err}`);
		});
}

function startReverseSyncModal() {
	const url = `${urlLocation}/${apiUrl}sync_start?dev_id=${deviceId}&del_recs=${removeExistingReceiptsInReverseSync}`;

	fetch(url)
		.then(response => response.json())
		.then(({ res, errortxt }) => {
			const reverseSyncErrorText = document.getElementById('reverse-sync-error-text');
			const reverseSyncLoaderBox = document.getElementById('reverse-sync-loader-box');

			if (res === 0) {
				reverseSyncInterval = setInterval(updateReverseSyncProgress, 2000);
			}

			if (errortxt) {
				reverseSyncErrorText.classList.remove('hidden');
				reverseSyncLoaderBox.classList.add('hidden');
				reverseSyncErrorText.innerHTML = errortxt;
			}
		})
		.catch(err => {
			callTostSnackbar(`Request failed: ${err}`);
		});
}
function showPassword() {
	if (passwordInput.type === "password") {
		passwordInput.type = "text";
	} else {
		passwordInput.type = "password";
	}
}

function updateReverseSyncProgress() {
	const url = `${urlLocation}/${apiUrl}sync_state?dev_id=${deviceId}`;
	const reverseSyncLoaderBox = document.getElementById('reverse-sync-loader-box');

	fetch(url)
		.then(response => response.json())
		.then(({ res, res_action, errortxt }) => {
			const reverseSyncErrorText = document.getElementById('reverse-sync-error-text');

			if (res === 0 && res_action > 0 && res_action <= 100) {
				reverseSyncLoaderBox.classList.remove('hidden');

				document
					.getElementById('reverse-sync-progress')
					.innerHTML = `Виконується синхронізація:&nbsp;&nbsp;&nbsp;${res_action}%`;
			}

			if (res_action === 100 && reverseSyncInterval) {
				clearInterval(reverseSyncInterval);
				closeReverseSyncModal();
			}

			if (errortxt) {
				reverseSyncErrorText.classList.remove('hidden');
				reverseSyncErrorText.innerHTML = errortxt;
			}
		})
		.catch(err => {
			callTostSnackbar(`Request failed: ${err}`);
		});
}

async function toggleEmulation(updatedState) {
	try {
		const response = await fetch(
		   `${urlLocation}/dm/api/v3/emul/${updatedState ? 'seton' : 'setoff'}?dev_id=${deviceId}`, {
				method: 'POST',
		   		body: JSON.stringify({}),
	   		}
		);

	   const result = await response.json();

	   if (result.res !== 0) {
			callTostSnackbar(result.errortxt);
			return false;
	   } else {
		   callTostSnackbar(`${updatedState ? 'Режим емуляції увімкнено' : 'Вимкнено режим емуляції'}`);
	   }

	   return true;
	} catch (err) {
		console.log(err)
		return false;
	}
 
}

async function toggleEmulationSwitch(switchNode) {
	const isSuccessful = await toggleEmulation(switchNode.checked);
	
	if (!isSuccessful) {
		switchNode.checked = !switchNode.checked;
		return;
	}

	if (!switchNode.checked) {
	  	emulationStateNode.classList.add('hidden');
		emulationSettingsLink.classList.add('hidden');
	} else {
		emulationStateNode.classList.remove('hidden');
		emulationSettingsLink.classList.remove('hidden');
	}
}

async function getSysInfo() {
	return fetch(`${urlLocation}/dm/api/v1/sys_info`, {
		method: 'GET',
	})
		.then((response) => response.json())
		.then((result) => {
			return result;
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		});
}

getDevice();
showPrroGroups();