const dictionary = {
    ua:{
        common: {
            save: "Зберегти",
            delete: "Видалити",
            decline: "Скасувати",
            edit: 'Редагувати',
            isPay: "Банківський Термінал",
            isWeight: "Ваги",
            isFis: "Фіскальний реєстратор",
            isDoc: "Принтер чеків",
            saved: "Дані збережено",
            shiftClosed: "Зміну закрито",
            deleted: "Пристрій видалено",
            generate: "Згенерувати",
            created: "Пристрій створено",
            en: "ENG",
            ua: "УКР",
            downloaded: "Данні завантаженно"
        },
        month: {
			january: 'Січень',
			february: 'Лютий',
			march: 'Березень',
			april: 'Квітень',
			may: 'Травень',
			june: 'Червень',
			july: 'Липень',
			august: 'Серпень',
			september: 'Вересень',
			october: 'Жовтень',
			november: 'Листопад',
			december: 'Грудень',
        },
        deviceList:{
            emptyPage: {
                noDevices: "У вас ще нема пристроїв",
                description: "Додайте всі ваші пристрої, щоб почати роботу з ними"
            },
            title:"Всі пристрої",
            add:"додати пристрій",
            getAllLogs: "вигрузити логи всіх пристроїв",
            table: {
                name : "Назва пристрою",
                type: "Тип пристрою",
                model: "Модель пристрою",
                prot: "Протокол",
                interface: "Інтерфейс",
                actions: "Дії"
            },
            modalCreate: {
                title: "Додати новий пристрій",
                submit: "Додати пристрій",
                filters: "Фільтри",
                devCode: "Введіть унікальну назву для пристрою",
                devCodeLabel: "Назва або код пристрою *",
                search: "Пошук",
                filterByType: "Фільтр за типом пристрою (Не обов’язково)",
                filterByManuf: "Фільтр за виробником (Не обов’язково)",
                model: "Модель пристрою *"
            }
        },
        deviceDetail:{
            backToDevices: "Назад до списку пристроїв",
            title: "Налаштування",
            devCodeLabel: "Назва або код пристрою *",
            prot: "Протокол",
            interface: "Інтерфейс підключення",
            codepage: "Кодування тексту при друку. Рекомендовано обрати 73:WPC1251(Cyril)",
            clogin: "Логін касира",
            cpwd: "Пароль касира",
            fisid: "Фіскальний номер",
            line_width: "Кількість символів у рядку залежно від розміру стрічки (32 - 58мм, 48 - 80мм)",
            pixel_width: "Розмір QR коду (рекомендоване значення 8-12)",
            whites_count: "Друк порожніх рядків в кінці (у випадку якщо принтер не до кінця друкує чек)",
            top_image: "Лого зверху. Формат: монохромний .bmp (Не обов’язково)",
            bottom_image: "Лого знизу. Формат: монохромний .bmp (Не обов’язково)",
            upload_image: "Завантажити лого",
            intf_info: "Додаткова інформація про інтерфейс",
            intf_info1: "Швидкість com-порту",
            dev_code_requiered: "Потрібно вказати ім'я пристрою",
        },
        modalZipLog: {
            title: "Оберіть інтервал дат",
            from: "Дата з",
            to: "Дата по",
            all: "За весь період",
            download: "Завантажити"
        },
        modalDelete: {
            title: "Видалити пристрій?",
            text: "Видаляючи пристрій, всі його дані також буде видалено",
            confirm: "видалити пристрій"
        },
        settings: {
            title: "Налаштування",
            extAccess: "Зовнішній доступ",
            logdays: "Видалення логів через (днів)",
            supmail: "E-mail для відправки даних при необхідності",
            table: {
                date: "Дата",
                time: "Час",
                source: "Джерело",
                tag: "Тег",
                level: "Рівень",
                device_name: "Пристрій",
                info: "Інфо"
            },
            level: {
                error: "Помилка",
                warning: "Попередження",
                info: "Інфо",
                debug: "Тех. інфо"
            }
        },
        logs: {
            title: "Журнал подій"
        }
    },
    en: {
        common: {
            save: "Save",
            delete: "Delete",
            decline: "Cancel",
            edit: 'Edit',
            isPay: "Bank terminal",
            isWeight: "Scales",
            isFis: "Fiscal register",
            isDoc: "Termoprinter",
            saved: "Successfully saved",
            shiftClosed: "Shift is closed",
            deleted: "Successfully deleted",
            generate: "Generate",
            created: "Device successfully created",
            en: "ENG",
            ua: "УКР",
            downloaded: "Succesfully downloaded"
        },
        month: {
			january: 'january',
			february: 'february',
			march: 'march',
			april: 'april',
			may: 'may',
			june: 'june',
			july: 'july',
			august: 'august',
			september: 'september',
			october: 'october',
			november: 'november',
			december: 'december',
        },
        deviceList:{
            emptyPage: {
                noDevices: "You don’t have connected devices",
                description: "Add your devices to start"
            },
            title:"Devices",
            add:"add new",
            getAllLogs: "logs export",
            table: {
                name : "Name",
                type: "Type",
                model: "Model",
                prot: "Protocol",
                interface: "Interface",
                actions: "Actions"
            },
            modalCreate: {
                title: "Add new device",
                submit: "confirm",
                filters: "Filters",
                devCode: "Create unique name for device",
                devCodeLabel: "Device name *",
                search: "Search",
                filterByType: "Filter by type",
                filterByManuf: "Filter by manufacturer",
                model: "Device model *"
            }

        },
        deviceDetail:{
            backToDevices: "Back to devices",
            title: "Settings",
            devCodeLabel: "Device name *",
            prot: "Protocol",
            interface: "Interface",
            codepage: "Codepage",
            clogin: "Cashier login (default)",
            cpwd: "Cashier password",
            fisid: "Fiscal ID",
            line_width: "line_width",
            pixel_width: "pixel_width",
            whites_count: "white lines",
            top_image: "Top logo",
            bottom_image: "Bottom logo",
            upload_image: "upload logo",
            intf_info: "Interface info",
            intf_info1: "Com port speed",
            dev_code_requiered: "Device name is required",
        },
        modalDelete: {
            title: "Do you want to delete this device?",
            text: "If you delete this device all it’s data will be deleted as well",
            confirm: "delete device"
        },
        modalZipLog: {
            title: "Select date interval",
            from: "Date from",
            to: "Date to",
            all: "All period",
            download: "Download"
        },
        settings: {
            title: "Settings",
            extAccess: "External access",
            logdays: "Clear logs history after",
            supmail: "Email for notifications",
            table: {
                date: "Date",
                time: "Time",
                source: "Source",
                tag: "Tag",
                level: "Level",
                device_name: "Device",
                info: "Info"
            },
            level: {
                error: "Error",
                warning: "Warning",
                info: "Info",
                debug: "Debug"
            }
        },
        logs: {
            title: "Logs"
        }
    }
}

if(!localStorage.getItem('langCode')) localStorage.setItem('langCode', 'ua');
/* Вирізаємо англ локалізацію. Ставлю поки ua за замовчуванням*/
localStorage.setItem('langCode', 'ua');
let selectedLanguage = localStorage.getItem('langCode');

/*select dictionary due to selected lang code*/
let selectedDictionary = dictionary[selectedLanguage];

document.getElementById("selected-lang").innerHTML = getTranslation(`common.${selectedLanguage}`);
document.getElementById("language-select").querySelector(`.${selectedLanguage}`).classList.add('active');

function initTranslation(){
    /*collect all nodes with data-lang-text attribute*/
    const allNodes = document.querySelectorAll('[data-lang-text]');
    /*set actual translation to nodes*/
    for(let node of allNodes){
        const langCode = node.getAttribute('data-lang-text');
        const translation = getTranslation(langCode);

        if(node instanceof HTMLInputElement && node.type == 'text'){
            /* if node is input we should place translation to placeholder */
            node.placeholder = translation;
        } else {
            node.innerHTML = translation;
        }
    }
}
function getTranslation(langCode){
    let arr = selectedDictionary;
    for (let lang of langCode.split('.')){
            if(typeof(arr[lang]) === 'object') {
                arr = arr[lang];
            } else {
                return arr[lang];
            }
    }
}
function setSelectedLangClass(){
    document.getElementById("language-select").querySelector('.ua').classList.toggle('active');
    document.getElementById("language-select").querySelector('.en').classList.toggle('active');
}

function setLang(lang){
    localStorage.setItem('langCode', lang);
    selectedLanguage = localStorage.getItem('langCode');
    selectedDictionary = dictionary[selectedLanguage];
    document.getElementById("selected-lang").innerHTML = getTranslation(`common.${lang}`);
    document.getElementById('language-select').classList.remove('active');

    setSelectedLangClass(lang);
    initTranslation();
}
initTranslation();
setSelectedLangClass(selectedLanguage);