const urlLocation = location.origin;
// const urlLocation = 'http://localhost:3939';
const apiUrl = '/dm/api/v1/';

const packdaysContainerNode = document.getElementById(
    'packdays-container'
);

function getData() {
    toggleLoader();
    fetch(`${urlLocation}${apiUrl}getsettings`)
        .then((response) => response.json())
        .then((result) => {
            toggleLoader();
            document.getElementById('supmail').value = result.supmail;
            document.getElementById('logdays').value = result.logdays;
            document.getElementById('extAccess').checked = result.extAccess;
        })
        .catch(function (error) {
            toggleLoader();
            callTostSnackbar(`Request failed: ${error}`);
        });
}
function saveSettings(){
    toggleLoader();
    let set_data = new FormData(document.getElementById('globalSet'));
    var object = {};
    set_data.forEach((value, key) => {
        object[key] = value;
    });
    var json = JSON.stringify(object);
    fetch(`${urlLocation}${apiUrl}setsettings`, {
        method: 'POST',
        body: json,
    })
    .then((response) => response.json())
    .then((result) => {
        toggleLoader();
        getData();
        callTostSnackbar(getTranslation('common.saved'));
    })
    .catch(function (error) {
        toggleLoader();
        callTostSnackbar(`Request failed: ${error}`);
    });
}
getData();