const urlLocation = location.origin;
// const urlLocation = "http://localhost:3939";
const apiUrl = 'dm/vchasno-kasa/api/v1/';

let device = null;
let version = null;
let need_upd = null;
let dfs = null;
let show_service_info = false;

let prndevId = null;
let prndevName  = null;
let devCount = 0;
let copies;
let opendrawer;
let commandsArray;
let deviceList;
let prroList;
let prrodevId = null;
let fisn;

const pagNode = document.getElementById('pagination');
const perPageNode = document.getElementById('perPage');
const mainTable = document.getElementById('main-table');
const emptyShifts = document.getElementById('empty-shifts');
const paginationContainer = document.querySelector('.pagination-container');

const actionPreview = "<span class='image-preview'><img src='./images/image-preview.png' /></span>";
const actionShiftDocuments = "<span class='shift-documents'><img src='./images/full-arrow.png' /></span>";

/* Current Day logs block */
const logsContainer = document.getElementById('current-day-logs-container');
const logsRefreshButton = document.getElementById('current-day-logs-refresh');
const logsError = document.getElementById('error-text-current-day-logs');
const DEFAULT_LOGS_SIZE = 64000;
let logsOffset = 0;
let logsSize = DEFAULT_LOGS_SIZE;
let stopFetchingLogs = false;

let Pagination = {
	code: '',
	// converting initialize data
	Extend: function (data) {
		data = data || {};
		Pagination.size = data.size || 300;
		Pagination.page = data.page || 1;
		Pagination.step = data.step || 3;
	},
	// add pages by number (from [s] to [f])
	Add: function (s, f) {
		for (var i = s; i < f; i++) {
			Pagination.code += `<div onclick="changePage(${i},${
				document.getElementById('perPage').value
			})">${i}</div>`;
		}
	},
	// add last page with separator
	Last: function () {
		Pagination.code += `<div>...</div><div onclick="changePage(${
			Pagination.size
		},${document.getElementById('perPage').value})">${Pagination.size}</div>`;
	},
	// add first page with separator
	First: function () {
		Pagination.code += `<div onclick="changePage(1,${
			document.getElementById('perPage').value
		})">1</div><div>...</div>`;
	},

	// --------------------
	// Handlers
	// --------------------

	// change page
	Click: function () {
		Pagination.page = +this.innerHTML;
		Pagination.Start();
	},

	// previous page
	Prev: function () {
		Pagination.page--;
		if (Pagination.page < 1) {
			Pagination.page = 1;
		}
		changePage(Pagination.page, document.getElementById('perPage').value);
		Pagination.Start();
	},

	// next page
	Next: function () {
		Pagination.page++;
		if (Pagination.page > Pagination.size) {
			Pagination.page = Pagination.size;
		}
		changePage(Pagination.page, document.getElementById('perPage').value);
		Pagination.Start();
	},

	// --------------------
	// Script
	// --------------------

	// binding pages
	Bind: function () {
		var div = Pagination.e.getElementsByTagName('div');
		for (var i = 0; i < div.length; i++) {
			if (+div[i].innerHTML === Pagination.page) div[i].className = 'current';
			div[i].addEventListener('click', Pagination.Click, false);
		}
	},

	// write pagination
	Finish: function () {
		Pagination.e.innerHTML = Pagination.code;
		Pagination.code = '';
		Pagination.Bind();
	},

	// find pagination type
	Start: function () {
		if (Pagination.size < Pagination.step * 2 + 6) {
			Pagination.Add(1, Pagination.size + 1);
		} else if (Pagination.page < Pagination.step * 2 + 1) {
			Pagination.Add(1, Pagination.step * 2 + 2);
			Pagination.Last();
		} else if (Pagination.page > Pagination.size - Pagination.step * 2) {
			Pagination.First();
			Pagination.Add(
				Pagination.size - Pagination.step * 2 - 2,
				Pagination.size + 1
			);
		} else {
			Pagination.First();
			Pagination.Add(
				Pagination.page - Pagination.step,
				Pagination.page + Pagination.step + 1
			);
			Pagination.Last();
		}
		Pagination.Finish();
	},

	// --------------------
	// Initialization
	// --------------------

	// binding buttons
	Buttons: function (e) {
		var nav = e.getElementsByTagName('div');
		nav[0].addEventListener('click', Pagination.Prev, false);
		nav[1].addEventListener('click', Pagination.Next, false);
	},

	// create skeleton
	Create: function (e) {
		var html = [
			'<div class="left-arrow"><img src="./images/arrow.png" /></div>', // previous button
			'<span class="pages"></span>', // pagination container
			'<div class="right-arrow"><img src="./images/arrow.png" /></div>', // next button
		];

		e.innerHTML = html.join('');
		Pagination.e = e.getElementsByTagName('span')[0];
		Pagination.Buttons(e);
	},

	// init
	Init: function (e, data) {
		Pagination.Extend(data);
		Pagination.Create(e);
		Pagination.Start();
	},
};

document.addEventListener('DOMContentLoaded', function (event) {
	const pageTitleHeader = document.querySelector('.with-go-back > h1');
	const backButton = document.querySelector('.with-go-back > img');
	
	initializeFromQueryParams();

	pageTitleHeader.textContent = `Реєстр змін пристрою ${device}`;
	
	setAdditionalInfo(version, need_upd, dfs);
	backButton.addEventListener('click', handleBack);
	changePage(1, perPageNode.value);

	logsContainer.addEventListener('scroll', () => {
		if (logsContainer.scrollTop === 0 && !stopFetchingLogs) {
			logsContainer.classList.add('no-scroll');
			fetchDayLogs();
		}
	});

	logsRefreshButton.addEventListener('click', () => {
		logsSize = DEFAULT_LOGS_SIZE;
		stopFetchingLogs = false;
	
		fetchDayLogs(true);
	});
});

function getShifts(extraParam) {
	!extraParam && (extraParam = '');
	const devIdParam = device ? `dev_code=${device}&` : '';
	toggleLoader();

	fetch(`${urlLocation}/${apiUrl}shifts?${devIdParam}${extraParam}`)
		.then(response => response.json())
		.then(result => {
			perPageNode.value = result.paging.page_size;
			pagNode.innerHTML = '';

			if (result.res !== 0) {
				throw new Error(result.errortxt || 'Сталася помилка');
			}
			
			toggleLoader();

			if (result.shifts.length) {
				fillShiftTableData(result.shifts);
				updateActionEventListeners(result.shifts);

				if (paginationContainer.classList.contains('hidden')) {
					paginationContainer.classList.remove('hidden');
					mainTable.classList.remove('hidden');
					emptyShifts.classList.add('hidden');
				} 
			} else {
				mainTable.classList.add('hidden');
				paginationContainer.classList.add('hidden');
				emptyShifts.classList.remove('hidden');
			}

			if (result.paging.total_pages > 1) {
				Pagination.Init(document.getElementById('pagination'), {
					size: result.paging.total_pages, // pages size
					page: result.paging.page_number, // selected page
					step: 2, // pages before and after current
				});
			}
		})
		.catch(error => {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}

function fillShiftTableData(shifts) {
	const table = document.getElementById('main-table-container');
	table.innerHTML = '';

	shifts.map(({ id, begin_dt, end_dt, localn, fisn, openIsOffline, sum_all_p, sum_all_m, tax_all_p, tax_all_m }) => {
		const beginDate = formatDate(begin_dt, true);
		const endDate = formatDate(end_dt, true);

		const trNode = `
			<tr data-id="${id}" class="row">
				<td class="first-row service-info">
					<span class="visible-xs">ID:</span>	
					${id}
				</td>
				<td class="${show_service_info ? '' : 'first-row'}">
					<span class="visible-xs">Дата відкриття:</span>
					${beginDate}
				</td>
				<td>
					<span class="visible-xs">Дата закриття:</span>
					${endDate}
				</td>
				<td class="center">
					<span class="visible-xs">Номер Z-звіту:</span>
					${localn}
				</td>
				<td>
					<span class="visible-xs">Фіскальний номер Z-звіту:</span>
					${fisn}
				</td>
				<td class="service-info">
					<span class="visible-xs">Статус:</span>
					<span>${openIsOffline === 0 ? 'online' : 'offline'}</span>
				</td>
				<td class="right">
					<span class="visible-xs">Сума по продажам:</span>
					${formatNumber(sum_all_p)}
				</td>
				<td class="right">
					<span class="visible-xs">Сума по поверненням:</span>
					${formatNumber(sum_all_m)}
				</td>
				<td class="right">
					<span class="visible-xs">Сума податку по продажам:</span>
					${formatNumber(tax_all_p)}
				</td class="right">
				<td>
					<span class="visible-xs">Сума податку по поверненням:</span>
					${formatNumber(tax_all_m)}
				</td>
				<td>
					<div class="visible-xs flex image-preview-button">
						<span class='image-preview'><img src='./images/image-preview.png' /></span>
						<p>Z-звіт</p>
					</div>
					<div class="visible-xs flex shift-document-button">
						<p>Деталі зміни</p>
						<span class='shift-documents'><img src='./images/full-arrow.png' /></span>
					</div>
					<div class="space-around visible-lg">${actionPreview}${actionShiftDocuments}</div>
				</td>
				</tr>
				`;

		table.insertAdjacentHTML('beforeend', trNode);
	});

	toggleServiceInfo(false);
}

function updateActionEventListeners(shifts) {
	const imagePreviewButtons = document.querySelectorAll('#main-table .image-preview');
	const imagePreviewXSButtons = document.querySelectorAll('#main-table .image-preview-button');
	const shiftDocumentButtons = document.querySelectorAll('#main-table .shift-documents');
	const shiftDocumentXSButtons = document.querySelectorAll('#main-table .shift-document-button');
	const tableRows = document.querySelectorAll('#main-table tr');
	
	const showImagePreviewHandler = function (element) {
		const shiftId = element.closest('.row').getAttribute('data-id');
		fisn = shifts.find(({ id }) => id === shiftId).fisn;
		toggleLoader();

		fetch(`${urlLocation}/${apiUrl}doc?fisn=${fisn}&dev_code=${device}&form=img`)
			.then(response => {
				if (response.status === 404) {
					throw new Error(response.statusText || response.errortxt || 'Сталася помилка');
				}

				return response.blob();
			})
			.then(blob => URL.createObjectURL(blob))
			.then(url => {
				toggleLoader();
				showImagePreview(url);
			}).catch(error => {
				toggleLoader();
				callTostSnackbar(`Request failed: ${error}`);
			});
	}

	const showShiftDocuments = function (element) {
		const shiftId = element.closest('.row').getAttribute('data-id');
		const localn = shifts.find(({ id }) => id === shiftId).localn;

		window.location = `./shift-documents.html?shift_id=${shiftId}&localn=${localn}&version=${version}&need_upd=${need_upd}&dfs=${dfs}&device=${device}`;
	}

	for (let imagePreviewButton of imagePreviewButtons) {
		imagePreviewButton.onclick = () => showImagePreviewHandler(imagePreviewButton);
	}

	for (let imagePreviewXSButton of imagePreviewXSButtons) {
		imagePreviewXSButton.onclick = () => showImagePreviewHandler(imagePreviewXSButton);
	}

	for (let shiftDocumentButton of shiftDocumentButtons) {
		shiftDocumentButton.onclick = () => showShiftDocuments(shiftDocumentButton);
	}

	for (let shiftDocumentXSButton of shiftDocumentXSButtons) {
		shiftDocumentXSButton.onclick = () => showShiftDocuments(shiftDocumentXSButton);
	}

	for (let tableRow of tableRows) {
		tableRow.onclick = function(e) {
			if (window.innerWidth < 768 && e.target.classList.contains('first-row')) {
				tableRow.classList.toggle('opened');			
			}
		}
	}
}

function changePage(page, count) {
	getShifts(`pg_no=${page}&pg_cnt=${count}`);
}

function changePerPage(count) {
	getShifts(`pg_no=1&pg_cnt=${count}`);
}

function initializeFromQueryParams() {
	const urlParams = new URLSearchParams(window.location.search);

	device = urlParams.get('device');
	version = urlParams.get('version');
	need_upd = Number.parseFloat(urlParams.get('need_upd'));
	dfs = Number.parseFloat(urlParams.get('dfs'));
}

function setAdditionalInfo(version, need_upd, dfs) {
	const versionContainerNode = document.querySelector('.additional-info .version');
	versionContainerNode.innerHTML = '';

	let dfsClass = 'green';
	let needUpdNode = document.createElement('span');
	const versionNode = document.createElement('span');
	const updateDeviceManager = document.createElement('span')
	updateDeviceManager.innerText = 'Оновити версію';
	updateDeviceManager.className = 'update-device-manager';
	updateDeviceManager.addEventListener('click', updateDeviceManagerVersion);
	versionNode.innerText = version;

	dfs < 95 && dfs > 50 && (dfsClass = 'orange');
	dfs <= 50 && (dfsClass = 'red');

	document.querySelector('.additional-info .dfs span').classList.add(dfsClass);
	document.querySelector('.additional-info .dfs span').innerText =
		dfs < 0 ? 'Не доступна' : `${dfs}%`;

	if(need_upd === 1){
		needUpdNode.innerText = ' (доступна нова версія)';
		needUpdNode.className = 'red';
	}else if(need_upd === 2){
		needUpdNode.innerText = ' (поточна версія)';
		needUpdNode.className = 'green';
	}
	versionContainerNode.insertAdjacentElement('beforeend', versionNode);
	versionContainerNode.insertAdjacentElement('beforeend', needUpdNode);
	need_upd === 1 && versionContainerNode.insertAdjacentElement('beforeend', updateDeviceManager);
}
function updateDeviceManagerVersion() {
	fetch(`${urlLocation}/dm/api/v1/app-update`, { method: 'POST', body: JSON.stringify({}) })
		.then((response) => response.json())	
		.then(result => {
			if (result.errortxt) {
				callTostSnackbar(result.errortxt);
			} else {
				callTostSnackbar('Оновлення запущено');
			}
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		});
};

function handleBack() {
	window.history.back();
};

function showModalZipLogs() {
	document.getElementById('zip-logs-modal').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
};

function hideModalZipLogs() {
	document.getElementById('zip-logs-modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
	document.getElementById('error-text-zip-logs').classList.add('hidden');
	document.getElementById('error-text-zip-logs').innerHTML = '';
};

function showModalCurrentDayLogs() {
	document.getElementById('current-day-logs-modal').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');

	fetchDayLogs(true);
}
function hideModalCurrentDayLogs() {
	document.getElementById('current-day-logs-modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');

	logsError.classList.add('hidden');
	logsError.innerHTML = '';
}
function fetchDayLogs(isInitialLoad = false) {
	fetch(isInitialLoad
			? `${urlLocation}/dm/logfilepart?length=${logsSize}`
			: `${urlLocation}/dm/logfilepart?length=${logsSize}&offset=${logsOffset}`
		)
		.then(parseLog)
		.then(log => writeLogToPage(log, isInitialLoad))
		.catch(() => {
			logsError.classList.remove('hidden');
			logsError.innerText = 'При завантаженні логів сталася помилка';
		}); 
}
function parseLog(response) {
	const logsOffsetResponseHeader = response.headers.get('X-Log-Offset');
	const logsOffsetNumber = Number.parseFloat(logsOffsetResponseHeader);

	if (logsOffsetNumber === 0)	stopFetchingLogs = true;

	if (logsOffsetNumber >= 64000) {
		logsOffset = logsOffsetNumber - 64000;
	} else {
		logsOffset = 0;
		logsSize = logsOffsetNumber;
	}

	return response.text();
}
function writeLogToPage(log, isInitialLoad) {
	const logDiv = document.createElement('div');
	logDiv.innerText = `--------------------------------------------------------------------------------------\n${log}`;

	if (isInitialLoad) {
		logsContainer.innerHTML = '';
	}

	logsContainer.insertAdjacentElement('afterbegin', logDiv);

	if (isInitialLoad) {
		logsContainer.scrollTop = logsContainer.scrollHeight;
	} else {
		logsContainer.scrollTop = logsContainer.scrollTop + logDiv.offsetHeight;
	}

	logsContainer.classList.remove('no-scroll');
}

function showImagePreview(image) {
	const imagePreview = document.getElementById('image-preview-modal');
	const imagePreviewContainer = document.querySelector('.image-preview-container > div'); 
	
	imagePreview.classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');

	const imgNode = `<img class="image-preview" src="${image}" />`;
	imagePreviewContainer.insertAdjacentHTML('afterbegin', imgNode);
	document.body.style.overflow = 'hidden';
}

function closeImagePreview() {
	const imagePreviewContainer = document.querySelector('.image-preview-container > div'); 

	document.getElementById('image-preview-modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');

	imagePreviewContainer.innerText = '';
	document.body.style.overflow = 'auto';
}

function validateZipLogs(checkbox) {
	if (checkbox.checked) {
		document.getElementById('log-date-from').disabled = true;
		document.getElementById('log-date-to').disabled = true;
	} else {
		document.getElementById('log-date-from').removeAttribute('disabled');
		document.getElementById('log-date-to').removeAttribute('disabled');
	}
}

function toggleLoader() {
	document.getElementById('loader-box').classList.toggle('active');
}

function toggleServiceInfo(changeFlag = true) {
	if (changeFlag) {
		show_service_info = !show_service_info;
	}

	const serviceColumns =  document.querySelectorAll('.service-info');

	
	for (serviceColumn of serviceColumns) {
		serviceColumn.style.display = show_service_info ? '' :'none';
	}
}

function formatDate(dateString, withTime = true) {
	let time = `${dateString.substr(6, 2)}.${dateString.substr(
		4,
		2
	)}.${dateString.substr(0, 4)}`;
	withTime &&
		(time +=
			`${dateString.substr(6, 2)}.${dateString.substr(
				4,
				2
			)}.${dateString.substr(0, 4)}` + withTime &&
			` ${dateString.substr(8, 2)}:${dateString.substr(
				10,
				2
			)}:${dateString.substr(12, 2)}`);
	return time;
}

function goToLogs() {
	window.location = `${urlLocation}/dm/vchasno-kasa/logs.html`;
}

function goToSettings() {
	window.location = `${urlLocation}/dm/vchasno-kasa/settings.html`;
}

document.zipLogs.onsubmit = function (e) {
	e.preventDefault();
	toggleLoader();
	let zip_logs_data = new FormData(this);
	let object = {};
	let buttonNode = this.querySelector('.modal-footer button');
	let contentType;
	zip_logs_data.forEach((value, key) => {
		object[key] = value;
	});
	if (object.all_logs) {
		object.date_begin = '';
		object.date_end = '';
	}
	buttonNode.innerText = 'Завантаження...';
	buttonNode.disabled = true;
	fetch(
		`${urlLocation}/${apiUrl}ziplogs?date_begin=${object.date_begin}&date_end=${object.date_end}`,
		{
			method: 'GET',
		}
	)
		.then((response) => {
			contentType = response.headers.get('Content-Type');
			if (response.ok && contentType.includes('application/zip')) {
				return response.blob(); // Convert response to Blob
			} else if (contentType && contentType.includes('application/json')) {
				return response.json();
			} else if (contentType && contentType.includes('text/html')) {
				return response.text();
			} else {
				throw "Невідома помилка при завантаженні логів";
			}
		})
		.then((data) => {
			if (typeof data === 'string') {
				throw data;
			} else {
				if (contentType.includes('application/json')) {
					throw data.errortxt;
				} else {
					let a = document.createElement('a');
					let url = URL.createObjectURL(data);
					a.href = url;
					if (object.all_logs) {
						a.download = 'All_EDM_Logs.zip';
					} else {
						a.download = object.date_begin + '_' + object.date_end + '_EDM_Logs.zip';
					}

					document.body.appendChild(a);
					a.click();
					document.body.removeChild(a);
					toggleLoader();
					buttonNode.innerText = 'Завантажити';
					buttonNode.removeAttribute('disabled');
					callTostSnackbar('Логи завантажено');
					hideModalZipLogs();
				}
			}
		})
		.catch(function (error) {
			toggleLoader();
			document
				.getElementById('error-text-zip-logs')
				.classList.remove('hidden');
			document.getElementById('error-text-zip-logs').innerHTML = `Помилка: ${error}`;
			buttonNode.innerText = 'Завантажити';
			buttonNode.disabled = false;
		});
};

document.getElementById('log-date-from').onclick = function (e) {
	e.preventDefault();
	e.cancelBubble = true;
	this.select();
	_Calendar.lcs(this);
};
document.getElementById('log-date-to').onclick = function (e) {
	e.preventDefault();
	e.cancelBubble = true;
	this.select();
	_Calendar.lcs(this);
};

(function () {
	document.getElementById('log-date-to').value = _Calendar.addnull(
		_Calendar.now.getDate(),
		_Calendar.now.getMonth() + 1,
		_Calendar.now.getFullYear()
	);
	document.getElementById('log-date-from').value = _Calendar.addnull(
		_Calendar.now.getDate(),
		_Calendar.now.getMonth() + 1,
		_Calendar.now.getFullYear()
	);
})();


function getPrro() {
	const data = 'A375515EF0FB2E0C7AE822B18EFE71E686FC8BD46E17AA25D76C4E4D6E6B4BCFE001BF16274FA88595948CFEC5A67BFC27DA9D4513182D3E47AF532471EA0BC0392C3651177D599F8EC8F91D1B787F2BDC262A79E13A90';

	return fetch(`${urlLocation}/dm/executesql?ret_dataset=true`, {
		method: 'POST',
		body: data
	})
		.then((response) => {
			if (!response.ok) {
				throw "Помилка при отриманні списку ПРРО"
			}
			return response.json();
		})
		.then((result) => {
			prroList = result.data;
		})
		.catch(function (error) {
			throw error;
		});
}
async function getPackModeDevices() {
	await getPrro();
	for (let i = 0; i < prroList.length; i++) {
		if (prroList[i].device === device) {
			prrodevId = prroList[i].dev_id;
		}
	}
	return fetch(`${urlLocation}/${apiUrl}prro/pack-mode?dev_id=${prrodevId}`, {
		method: 'GET',
	})
		.then((response) => {
			if (!response.ok) {
				throw "Помилка при отриманні інформації про підключений принтер до пакетного режиму"
			}
			return response.json();
		})
		.then((result) => {
			let pckPrn = result.pck_prn;
			if (pckPrn !== ""){
				prndevId = pckPrn;
			}
		})
		.catch(function (error) {
			throw error;
		});
}

async function fetchDevices() {
	await getPackModeDevices();
	return fetch(`${urlLocation}/dm/api/v3/devices`)
		.then((response) => {
			if (!response.ok) {
				throw "Помилка при отриманні списку принтерів"
			}
			return response.json();
		})
		.then((result) => {
			deviceList = result.devices;
			let prnList = [];
			for (let i = 0; i < deviceList.length; i++) {
				if (deviceList[i].is_doc === true) {
					devCount++;
					prnList.push(deviceList[i]);
				}
			}

			if (prndevId !== null) {
				for (let i = 0; i < deviceList.length; i++) {
					if (deviceList[i].dev_id === prndevId) {
						prndevName = deviceList[i].dev_code;
					}
				}
				devCount = 0;
			}
			else if (prnList && prnList.length && devCount === 1){
				prndevId = prnList[0].dev_id;
				prndevName = prnList[0].dev_code;
				devCount = 0;
			}
			else if (devCount > 1) {
				devCount = 0;
				throw "Необхідно додати принтер в налаштуваннях пакетного режиму"
			}
			else {
				devCount = 0;
				throw "Немає підключених принтерів"
			}
		})
		.catch(function (error) {
			throw error;
		});
}

function getDocForm() {
	return fetch(`${urlLocation}/${apiUrl}doc?fisn=${fisn}&form=doc`, {
		method: 'GET',
	})
		.then((response) => {
			if (!response.ok) {
				throw "Помилка при отриманні форми документа"
			}
			return response.json();
		})
		.then((result) => {
			copies = result.copies;
			opendrawer = result.opendrawer;
			commandsArray = result.commands;
		})
		.catch(function (error) {
			throw error;
		});
}
async function printReceipt() {
	try {
		toggleLoader();
		await fetchDevices();
		await getDocForm();

		const data = {
			ver: 6,
			source: 'VK_UI',
			device: prndevName,
			type: 2,
			doc: {}
		};
		data.doc.commands = commandsArray;
		data.doc.copies = copies;
		data.doc.opendrawer = opendrawer;
		const jsonData = JSON.stringify(data);
		fetch(`${urlLocation}/dm/execute`, {
			method: 'POST',
			headers: {
				'Content-Type': 'application/json',
			},
			body: jsonData
		})
			.then((response) => response.json())
			.then((result) => {
				toggleLoader();
				if (result.errortxt) {
					callTostSnackbar(`Помилка при друку: ${result.errortxt}`);
				} else {
					callTostSnackbar(`Документ відправлено на друк`);
				}
			})
			.catch(function (error) {
				toggleLoader();
				callTostSnackbar(`${error}`);
			});
	}
	catch (error) {
		toggleLoader();
		callTostSnackbar(`${error}`);
	}
}

function saveReceipt(type) {
	try {
		fetch(`${urlLocation}/${apiUrl}doc?fisn=${fisn}&form=${type}`, {
			method: 'GET',
		})
			.then((response) => {
				if (!response.ok) {
					throw new Error('Помилка при отриманні форми документа');
				} else {
					// for supporting downloading from android webview
					window.location.href = `${urlLocation}/${apiUrl}doc?fisn=${fisn}&form=${type}`;
					closeImagePreview();
					callTostSnackbar(`Документ завантажено`);
				}
			})
			.catch(function (error) {
				callTostSnackbar(`${error.message || error}`);
			});
	}
	catch (error) {
		callTostSnackbar(`${error.message || error}`);
	}
}

function showGlobalDropdown(buttonElement) {
	const dropdown = document.getElementById('global-dropdown-menu');

	if (!dropdown.classList.contains('hidden')) {
		hideGlobalDropdown();
		return;
	}

	dropdown.innerHTML = '';

	const options = [
		{ label: 'Надрукувати на принтері', value: 'print' },
		{ label: 'Завантажити (txt)', value: 'savetxt' },
		{ label: 'Завантажити (img)', value: 'saveimg' },
		{ label: 'Завантажити (pdf)', value: 'savepdf' }
	];

	options.forEach(option => {
		const item = document.createElement('div');
		item.textContent = option.label;
		item.style.whiteSpace = 'nowrap';
		item.onclick = () => {
			handleOptionClick(option.value);
			hideGlobalDropdown();
		};
		dropdown.appendChild(item);
	});

	const rect = buttonElement.getBoundingClientRect();
	const dropdownHeight = 177;
	dropdown.style.top = `${rect.top + window.scrollY - dropdownHeight}px`;
	dropdown.style.left = `${rect.left}px`;

	dropdown.classList.remove('hidden');
}

function hideGlobalDropdown() {
	const dropdown = document.getElementById('global-dropdown-menu');
	dropdown.classList.add('hidden');
}

//Hide dropdown
document.addEventListener('click', (event) => {
	const dropdown = document.getElementById('global-dropdown-menu');
	if (!dropdown.contains(event.target) &&
		!event.target.closest('button')?.onclick?.toString().includes('showGlobalDropdown')) {
		hideGlobalDropdown();
	}
});
window.addEventListener('resize', hideGlobalDropdown);
window.addEventListener('scroll', hideGlobalDropdown, true);

function handleOptionClick(action) {
	switch (action) {
		case 'print':
			printReceipt();
			break;
		case 'savetxt':
			saveReceipt('txt');
			break;
		case 'saveimg':
			saveReceipt('img');
			break;
		case 'savepdf':
			saveReceipt('pdf');
			break;
	}
}