const urlLocation = location.origin;
// const urlLocation = "http://localhost:3939";
const apiUrl = 'dm/vchasno-kasa/api/v1/';
const packdaysContainerNode = document.getElementById('packdays-container');
const packdaysInputNode = document.getElementById('packdays');
const switchPackDaysNode = document.getElementById('switch-pack-days');
const switchAutoUpdateNode = document.getElementById('switch-auto-update');
const switchSendStatNode = document.getElementById('send_stat');
const autoUpdateTimeInput = document.getElementById('auto-update-time');
const pfIsCustomNode = document.getElementById('pf_is_custom');

const proxyConfigNode = document.getElementsByClassName('proxy-config').item(0);
const switchUseProxy = document.getElementById('switch-use-proxy');
const proxyAddress = document.getElementById('proxy-address');
const proxyPort = document.getElementById('proxy-port');
const proxyLogin = document.getElementById('proxy-login');
const proxyPassword = document.getElementById('proxy-password');
const proxySettings = document.getElementById('proxy-settings');
const databaseConfig = document.getElementById('database-config-container');
const databaseMigration = document.getElementById('db-migration-container');
const passwordInput = document.getElementById('database-pass');

let dbMigrationStateInterval = null;
let isMigrationStarted = false;
let printFormB64, user_login, isNeedAuth;

function clearCerts() {
	fetch(`${urlLocation}/${apiUrl}clear_certs`)
		.then(result => {
			if (result.errortxt) {
				callTostSnackbar(result.errortxt);
			} else if (result?.status === 200) {
				callTostSnackbar('Сертифікати очищено');
			} else {
				callTostSnackbar('При очищенні сертифікатів сталася помилка');
			}
		})
		.catch(error => {
			callTostSnackbar(`Request failed: ${error}`);
		})
}

async function getData() {
	document.getElementById('pf_del_custom').checked = false;

	await fetch(`${urlLocation}/dm/api/v1/sys_info`)
		.then((response) => response.json())
		.then(async (result) => {

			document.getElementById('dm_version').innerText = result.dm_version;
			document.getElementById('platform').innerText = result.platform;
			document.getElementById('architecture').innerText = result.architecture;
			document.getElementById('platform_name_version').innerText = `${result.platform_name} ${result.platform_version}`;
			document.getElementById('database-fullname').innerText = result.database;
			if (result.database === "SQLite") {
				document.getElementById('db_size').style.display = 'flex';
				document.getElementById('dm_db_size').innerText = `${result.dm_db_size} ГБ`;
			}
			const platform = result.platform.toLowerCase();

			if (platform === 'windows') {
				proxySettings.classList.remove('hidden');
			}
			if (platform !== 'android') {
				databaseConfig.classList.remove('hidden');
				databaseMigration.classList.remove('hidden');
			}

			await fetch(`${urlLocation}/dm/api/v3/database`)
				.then((response) => response.json())
				.then((result) => {
					let databaseTypeNode = document.getElementById('dbType');
					if (!result.hasOwnProperty("res")) {
					if (result.db_type !== 0) {
						if (result.db_type === 1) {
							document.getElementById('database-shortname').innerText = 'MSSQL';
							databaseTypeNode.value = '1';

						} else {
							document.getElementById('database-shortname').innerText = 'Postgresql';
							databaseTypeNode.value = '2';
						}
						document.getElementById('info-db-fullname').classList.remove('hidden');
						document.getElementById('database-server-ip').value = result.server_ip;
						document.getElementById('database-port').value = result.port;
						document.getElementById('database-name').value = result.database_name;
						document.getElementById('database-login').value = result.login;
						document.getElementById('database-pass').value = result.pass;
					} else {
						document.getElementById('info-db-fullname').classList.add('hidden');
						document.getElementById('database-shortname').innerText = 'SQLite';
					}
				} else {
						document.getElementById('info-db-fullname').classList.add('hidden');
						document.getElementById('database-shortname').innerText = 'SQLite';
					}
				});

			await fetch(`${urlLocation}/${apiUrl}settings`)
				.then((response) => response.json())
				.then((result) => {
					document.getElementById('logdays').value = result.logdays;
					document.getElementById('archdays').value = result.archdays;
					document.getElementById('extAccess').checked = result.extAccess;
					document.getElementById('supmail').value = result.supmail;
					document.getElementById('pf_charcount').value = result.pf_charcount;
					document.getElementById('pf_charwidth').value = result.pf_charwidth;
					document.getElementById('line_spacing').value = result.line_spacing;

					document.getElementById('pf_aspdf').checked = result.pf_aspdf;
					document.getElementById('pf_asimage').checked = result.pf_asimage;
					document.getElementById('pf_astext').checked = result.pf_astext;

					document.getElementById('usr_uiauth').checked = result.usr_uiauth;
					document.getElementById('usr_confpass').value = result.usr_confpass;
					document.getElementById('usr_pass').value = result.usr_pass;
					document.getElementById('usr_login').value = result.usr_login;
					document.getElementById('server_alias').value = result.server_alias;

					user_login = result.usr_login;
					isNeedAuth = result.usr_uiauth;

					document.getElementById('download-print-forms').href = `${urlLocation}/${apiUrl}settings/printforms`;

					if (result.usr_uiauth === true && result.x_api_key) {
						document.getElementById('x_api_key').placeholder = 'ключ приховано, якщо загубили - придумайте новий';
					}

					if (result.packdays) {
						switchPackDaysNode.checked = true;
						packdaysContainerNode.querySelector('p').classList.add('hidden');
						packdaysContainerNode.querySelector('div').classList.remove('hidden');
						packdaysInputNode.value = result.packdays;
					} else {
						switchPackDaysNode.checked = false;
						packdaysContainerNode.querySelector('p').classList.remove('hidden');
						packdaysContainerNode.querySelector('div').classList.add('hidden');
						packdaysInputNode.value = 0;
					}
					if (result.pf_is_custom) {
						pfIsCustomNode.innerHTML = 'Користувацькі друковані форми <b>завантажено</b>';
						document.getElementById('delete_print_forms').classList.remove('hidden');
						document.getElementById('download-print-forms').classList.remove('hidden');
					} else {
						pfIsCustomNode.innerHTML = 'Користувацькі друковані форми не завантажено';
						document.getElementById('delete_print_forms').classList.add('hidden');
						document.getElementById('download-print-forms').classList.add('hidden');
					}

					switchAutoUpdateNode.checked = result.autoupdate;
					autoUpdateTimeInput.value = result.autoupdatetime;
					switchSendStatNode.checked = result.send_stat;

					switchUseProxy.checked = result.proxy_use;
					proxyAddress.value = result.proxy_ip;
					proxyPort.value = result.proxy_port ? Number(result.proxy_port) : '';
					proxyLogin.value = result.proxy_login;

					if (result.proxy_use) {
						proxyConfigNode.classList.remove('hidden');
					} else {
						proxyConfigNode.classList.add('hidden');
					}
					document.querySelector('#dbType').addEventListener('change', dbTypeChangeHandler);
					document.getElementById('server-db-conf').classList.remove('hidden');
					dbTypeChangeHandler({target: {value: document.querySelector('#dbType').value}});
				});
		})
}
function dbTypeChangeHandler({ target: { value } }) {
	if (dbType.value !== '0') {
		document.getElementById('server-db-conf').classList.remove('hidden');
	} else {
		document.getElementById('server-db-conf').classList.add('hidden');

	}
}
getData();
function submitData() {
	const logdays = document.getElementById('logdays').value;
	const archdays = document.getElementById('archdays').value;
	const extAccess = document.getElementById('extAccess').value;
	const supmail = document.getElementById('supmail').value;

	const pf_charcount = document.getElementById('pf_charcount').value;
	const pf_charwidth = document.getElementById('pf_charwidth').value;
	const line_spacing  = document.getElementById('line_spacing').value;

	const pf_aspdf = document.getElementById('pf_aspdf').checked;
	const pf_asimage = document.getElementById('pf_asimage').checked;
	const pf_astext = document.getElementById('pf_astext').checked;
	const pf_del_custom = document.getElementById('pf_del_custom').checked;

	const usr_uiauth = document.getElementById('usr_uiauth').checked;
	const usr_confpass = document.getElementById('usr_confpass').value;
	const usr_pass = document.getElementById('usr_pass').value;
	const usr_login = document.getElementById('usr_login').value;
	const x_api_key = document.getElementById('x_api_key').value;
	const server_alias = document.getElementById('server_alias').value;
	const autoupdate = switchAutoUpdateNode.checked;
	const autoupdatetime = autoUpdateTimeInput.value;
	const usr_chuser = Boolean((user_login != usr_login) || isNeedAuth != usr_uiauth || usr_pass);
	const send_stat = switchSendStatNode.checked;

	const proxy_use = switchUseProxy.checked;
	const proxy_ip = proxyAddress.value;
	const proxy_port = proxyPort.value;
	const proxy_login = proxyLogin.value;
	const proxy_pass = proxyPassword.value;

	const data = {
		logdays: logdays,
		archdays: archdays,
		extAccess: extAccess,
		supmail: supmail,
		packdays: packdaysInputNode.value,
		pf_aspdf,
		pf_asimage,
		pf_astext,
		pf_del_custom,
		pf_charcount,
		pf_charwidth,
		line_spacing,
		pf_custom: printFormB64,
		usr_uiauth,
		usr_chuser,
		usr_confpass,
		usr_pass,
		usr_login,
		x_api_key,
		server_alias,
		autoupdate,
		autoupdatetime,
		send_stat,

		proxy_use,
		proxy_ip: proxy_use ? proxy_ip : '',
		proxy_port: proxy_use ? proxy_port : '',
		proxy_login: proxy_use ? proxy_login : '',
		proxy_pass: proxy_use ? proxy_pass : '',
	};

	const json = JSON.stringify(data);

	fetch(`${urlLocation}/${apiUrl}settings`, {
		method: 'POST',
		body: json,
	})
		.then((response) => response.json())
		.then((result) => {
			if (result.errortxt) {
				callTostSnackbar(result.errortxt);
			} else {
				document.getElementById('loaded-file').classList.add('hidden');
				callTostSnackbar('Дані збережено');
				if (!usr_uiauth && usr_uiauth != isNeedAuth) {
					document.querySelector('.button-hover.logout-button') && document.querySelector('.button-hover.logout-button').classList.add('hidden');
					delete_cookie('DMUIToken');
				}
				getData();
			}
		});
}
function getPrintForms() {
	fetch(`${urlLocation}/${apiUrl}settings/printforms`)
		.then((response) => response.json())
		.then((result) => {
			var url = window.URL.createObjectURL(blob);
			var a = document.createElement('a');
			a.href = url;
			a.download = "filename.xlsx";
			document.body.appendChild(a);
			if (result.errortxt) {
				callTostSnackbar(result.errortxt);
			} else {
				callTostSnackbar('Файл завантажено');
				getData();
			}
		});
}
function connectDb() {
	const db_type = document.getElementById('dbType').value;
	const server_ip = document.getElementById('database-server-ip').value;
	const port = document.getElementById('database-port').value;
	const database_name = document.getElementById('database-name').value;
	const login = document.getElementById('database-login').value;
	const pass = document.getElementById('database-pass').value;

	let data;
	if (db_type !== '0') {
		data = {
			db_type: db_type,
			server_ip: server_ip,
			port: port,
			database_name: database_name,
			login: login,
			pass: pass
		}
	} else {
		data = {
			db_type: db_type
		}
	}

	const json = JSON.stringify(data);

	fetch(`${urlLocation}/dm/api/v3/database`, {
		method: 'POST',
		body: json,
	})
		.then((response) => {
		contentType = response.headers.get('Content-Type');
		if (response.ok && contentType.includes('application/json')) {
			return response.json();
		} else if (contentType && contentType.includes('text/html')) {
			return response.text();
		} else {
			throw "Внутрішня помилка, зверніться до техпідтримки";
		}
	})
		.then((result) => {
			if (typeof result === 'string') {
				callTostSnackbar(`Внутрішня помилка: ${result}`);
				throw result;
			} else {
			if (result.res !== 0) {
				callTostSnackbar(`Помилка при зміні БД: ${result.errortxt}`);
			} else {
				callTostSnackbar('Базу даних успішно змінено. Зачекайте до 30 секунд поки буде завершено налаштування та перезавантажте сторінку');	
			}
		}});
}
function showPassword() {
	if (passwordInput.type === "password") {
		passwordInput.type = "text";
	} else {
		passwordInput.type = "password";
	}
};
function openDbMigrationModal() {
	document.getElementById('modal').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}

function closeDbMigrationModal() {
	document.getElementById('modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
}

function openDbMigrationStateModal() {
	document.getElementById('modal-migration-state').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}

function closeDbMigrationStateModal() {
	document.getElementById('modal-migration-state').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
	if (!isMigrationStarted) return;

	const url = `${urlLocation}/dm/api/v3/data_migration_stop`;

	fetch(url)
		.then(response => response.json())
		.then(({ res, errortxt }) => {
			const migrationStateProgress = document.getElementById('migration-state-progress');
			const migrationStateLoader = document.getElementById('migration-state-loader');
			const migrationStateMessage = document.getElementById('migration-state-message');
			const migrationStateErrorText = document.getElementById('migration-state-error-text');

			migrationStateProgress.classList.remove('hidden');
			migrationStateLoader.classList.remove('hidden');
			migrationStateMessage.classList.remove('hidden');
			migrationStateErrorText.classList.add('hidden');

			if (res === -1) {
				document.getElementById('migration-state-progress').innerHTML = `Прогрес перенесення:`;
				migrationStateMessage.innerHTML = '';
				migrationStateErrorText.innerHTML = '';
				isMigrationStarted = false;
				clearInterval(dbMigrationStateInterval);
				callTostSnackbar(errortxt);
			} else {
				migrationStateErrorText.classList.remove('hidden');
				migrationStateErrorText.innerHTML = errortxt;
			}
		})
		.catch(err => {
			callTostSnackbar(`Request failed: ${err}`);
		});
}


document.dbMigrationForm.onsubmit = function (e) {
	e.preventDefault();

	const db_path = document.getElementById('database-file-path').value;
	const data_migration_type = document.getElementById('migrationType').value;
	const cleardb = document.getElementById('clear-database').checked;


	fetch(`${urlLocation}/dm/api/v3/data_migration_start?db_path=${db_path}&data_migration_type=${data_migration_type}&cleardb=${cleardb}`, {
		method: 'GET',
	})
		.then((response) => response.json())
		.then((result) => {
			if (result.errortxt) {
				document.getElementById('error-db-migration').innerText = result.errortxt;
			} else if (result.res === 0) {
				isMigrationStarted = true;
				dbMigrationStateInterval = setInterval(dbMigrationState, 1000);
				closeDbMigrationModal();
				openDbMigrationStateModal();
			}
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		});
};

function dbMigrationState() {
	const url = `${urlLocation}/dm/api/v3/data_migration_state`;
	const reverseSyncLoaderBox = document.getElementById('migration-state-loader-box');

	fetch(url)
		.then(response => response.json())
		.then(({ res, errortxt }) => {
			const migrationStateProgress = document.getElementById('migration-state-progress');
			const migrationStateLoader = document.getElementById('migration-state-loader');
			const migrationStateMessage = document.getElementById('migration-state-message');
			const migrationStateErrorText = document.getElementById('migration-state-error-text');
			migrationStateMessage.classList.remove('hidden');
			migrationStateMessage.innerHTML = errortxt;

			if (res < 100 && res > 0) {
				reverseSyncLoaderBox.classList.remove('hidden');

				document
					.getElementById('migration-state-progress')
					.innerHTML = `Прогрес перенесення:&nbsp;&nbsp;&nbsp;${res}%`;
			}
			
			if (res === 100 && dbMigrationStateInterval) {
				document.getElementById('migration-state-progress').innerHTML = `Прогрес перенесення:`;
				migrationStateMessage.innerHTML = '';
				migrationStateErrorText.innerHTML = '';
				clearInterval(dbMigrationStateInterval);
				isMigrationStarted = false;
				closeDbMigrationStateModal();
				callTostSnackbar('Міграція завершена вдало');
			}

			if (res === -2) {
				clearInterval(dbMigrationStateInterval);
				document.getElementById('migration-state-progress').innerHTML = `При міграції сталась помилка:`;
				migrationStateProgress.classList.remove('hidden');
				migrationStateLoader.classList.add('hidden');
				migrationStateMessage.classList.add('hidden');
				migrationStateErrorText.classList.remove('hidden');
				migrationStateErrorText.innerHTML = errortxt;
			}
		})
		.catch(err => {
			callTostSnackbar(`Request failed: ${err}`);
		});
}

function addFilePrintForms(fileInput) {
	let file = fileInput.files[0],
		reader = new FileReader();
	reader.readAsDataURL(file);
	reader.onloadend = function () {
		printFormB64 = reader.result.split('base64,')[1];
		document.getElementById('loaded-file').classList.remove('hidden');
		document.getElementById('loaded-file').querySelector('span').innerHTML = file.name;
	};
}

function validate(checkboxNode) {
	if (checkboxNode.checked) {
		checkboxNode.value = true;
		checkboxNode.checked = true;
	} else {
		checkboxNode.value = false;
		checkboxNode.checked = false;
	}
}
function switchPackDays(checkboxNode) {
	if (checkboxNode.checked) {
		checkboxNode.checked = true;
		packdaysContainerNode.querySelector('p').classList.add('hidden');
		packdaysContainerNode.querySelector('div').classList.remove('hidden');
		packdaysInputNode.value = 40;
	} else {
		checkboxNode.checked = false;
		packdaysContainerNode.querySelector('p').classList.remove('hidden');
		packdaysContainerNode.querySelector('div').classList.add('hidden');
		packdaysInputNode.value = 0;
	}
}
function switchUseProxyFlag(checkboxNode) {
	if (checkboxNode.checked) {
		proxyConfigNode.classList.remove('hidden');
	} else {
		proxyConfigNode.classList.add('hidden');
	}
}
function goBack() {
	window.history.back();
}
document.getElementById('packdays').addEventListener('blur', (e) => {
	if (Number(e.target.value) < 4) {
		packdaysInputNode.value = 4;

	}
});
