/* interfaces icons */
const iconWeb = `<span class='web type-icon'></span>`;
const iconCom = `<span class='com type-icon'></span>`;
const iconOSBased = `<span class='osbased type-icon'></span>`;
const iconInternal = `<span class='internal type-icon'></span>`;
const iconBluetooth = `<span class='bluetooth type-icon'></span>`;
const iconEthernet = `<span class='ethernet type-icon'></span>`;
const iconUsb = `<span class='usb type-icon'></span>`;

function showModal(modalId){
    document.getElementById(modalId).classList.remove('hidden');
    document.getElementById('overlay').classList.remove('hidden');
}
function hideModal(modalId){
    document.getElementById(modalId).classList.add('hidden');
    document.getElementById('overlay').classList.add('hidden');
}
function toggleTableRowClass(trNode) {
    trNode.parentNode.classList.toggle('active');
}
function callTostSnackbar(text) {
    console.log(text);
	let x = document.getElementById('snackbar');
	x.className = 'show';
	x.innerText = text;
	setTimeout(function () {
		x.className = x.className.replace('show', '');
	}, 3000);
}
function toggleLoader() {
	document.getElementById('loader-box').classList.toggle('active');
}

function setInterfaceIcon(interface) {
	switch (interface) {
		case 'Web':
			return iconWeb;
		case 'USB':
			return iconUsb;
		case 'Bluetooth':
			return iconBluetooth;
		case 'Ethernet':
			return iconEthernet;
		case 'Internal':
			return iconInternal;
		case 'COM':
			return iconCom;
		case 'OSBased':
			return iconOSBased;
		default:
			return interface;
	}
}

/* input type number */
function validateNumbers(evt) {
	var theEvent = evt || window.event;
  
	// Handle paste
	if (theEvent.type === 'paste') {
		key = event.clipboardData.getData('text/plain');
	} else {
	// Handle key press
		var key = theEvent.keyCode || theEvent.which;
		key = String.fromCharCode(key);
	}
	var regex = /[0-9]|\./;
	if( !regex.test(key) ) {
	  theEvent.returnValue = false;
	  if(theEvent.preventDefault) theEvent.preventDefault();
	}
  }

/*redirects*/
function backToDeviceList(){
    window.location.href = `./dashboard.html`;
}