const urlLocation = location.origin;
// const urlLocation = "http://localhost:3939";
const apiUrl = "/dm/api/v1/";
const apiUrlDM = "/dm/";
const queryString = window.location.search;
const urlParams = new URLSearchParams(queryString);
const deviceId = urlParams.get("dev_id");
let deviceCode = "";


/* types of devices icons */
const iconDoc = `<span class='printer type-icon'></span>`;
const iconFis = `<span class='fiscal type-icon'></span>`;
const iconPay = `<span class='card type-icon'></span>`;
const iconScl = `<span class='scales type-icon'></span>`;

/* types of devices, needed to save changes */
let is_doc, is_fis, is_pay, is_weight;

/* Data to fetch printers is system */
let protId;
let intfInfo;
let isDoc;

/*nodes*/
const titleNode = document.getElementById("device-title-details");
const devCodeNode = document.getElementById("dev_code");
const fisParamsContainerNode = document.getElementById("fisparams-container");
const docParamsContainerNode = document.getElementById("doc_params-container");

/* empty variables to use in different functions without connection */
let protsArr = []; /* for protocols */
let interfacesArr = []; /* for interfaces */
let intfInfo1Val;
let codepages = []; /* for codepages */
let merchlist;


let modelId = '';
let protocolId = '';
let printersList = [];
let terminalsList = [];
let bankProtocols = [];
let printerProtocols = [];

function setDeviceTypeIcon({ is_doc, is_fis, is_pay, is_weight }) {
  let icons = "";
  if (is_pay) {
    icons += iconPay;
  }
  if (is_doc) {
    icons += iconDoc;
  }
  if (is_fis) {
    icons += iconFis;
  }
  if (is_weight) {
    icons += iconScl;
  }
  return icons;
}

function generateSelect(
  parentNodeId,
  nodeId,
  optionsData,
  selected = "",
  onChange
) {
  /*get parent div*/
  const parentNode = document.getElementById(parentNodeId);
  parentNode.classList.remove("hidden");

  const parentListCont = parentNode.querySelector("div");
  parentListCont.innerHTML = ""; //clear data

  const selectList = document.createElement("select");

  selectList.id = nodeId;
  selectList.name = nodeId;
  onChange && (selectList.onchange = onChange);

  for (let optionData of optionsData) {
    let newOption = (selectList.options[selectList.options.length] = new Option(
      optionData.capt,
      optionData.id
    ));
    if (nodeId === "intf") {
      newOption.classList.add(optionData.capt.toLowerCase());
    }
  }
  selected && selected.id && (selectList.value = selected.id);
  parentListCont.appendChild(selectList);
}

function generateInputText(parentNodeId, nodeId, inputVal, onChange) {
  /*get parent div*/
  const parentNode = document.getElementById(parentNodeId);
  parentNode.classList.remove("hidden");

  const parentListCont = parentNode.querySelector("div");
  parentListCont.innerHTML = ""; //clear data

  const inputText = document.createElement("input");

  inputText.id = nodeId;
  inputText.name = nodeId;
  inputText.type = "text";
  inputText.value = inputVal;
  onChange && (inputText.onchange = onChange);

  parentListCont.appendChild(inputText);
}
function generateInputNumber(parentNodeId, nodeId, inputVal, onChange) {
  /*get parent div*/
  const parentNode = document.getElementById(parentNodeId);
  parentNode.classList.remove("hidden");

  const parentListCont = parentNode.querySelector("div");
  parentListCont.innerHTML = ""; //clear data

  const inputText = document.createElement("input");

  inputText.id = nodeId;
  inputText.name = nodeId;
  inputText.type = "text";
  inputText.value = inputVal;
  inputText.onkeypress = function (event) {
    validateNumbers(event);
  };
  onChange && (inputText.onchange = onChange);

  parentListCont.appendChild(inputText);
}
function generateUploadInput(parentNodeId, nodeId, inputVal) {
  const parentNode = document.getElementById(parentNodeId);
  parentNode.classList.remove("hidden");
  setLogoImage(document.getElementById(nodeId), inputVal);
}
function generateCheckboxInput(parentNodeId, nodeId, inputVal) {
  const parentNode = document.getElementById(parentNodeId);
  parentNode.classList.remove("hidden");

  const checkbox = document.getElementById(nodeId);
  checkbox.checked = inputVal;
}

function getProtocolsAndInterfaces(model_id, selectedProt, selectedIntf) {
  /* fetch data due to selected model*/
  fetch(`${urlLocation}${apiUrl}registry/prots?model_id=${model_id}`)
    .then((response) => response.json())
    .then((result) => {
      protsArr = [];
      for (prot of result.prots) {
        /* write protocols to new arr*/
        protsArr.push(prot.prot);

        let intfsProtArr = []; //local arr to write all interfaces of current prot
        for (intf of prot.intfs) {
          intfsProtArr.push(intf.intf);
        }

        /* write interfaces to new arr*/
        interfacesArr[prot.prot.id] = intfsProtArr;
      }

      generateSelect(
        "prot-container",
        "prot",
        protsArr,
        selectedProt,
        generateInterfacesSelect
      );
      generateInterfacesSelect(selectedIntf); // call to fullfil select list of interfaces firstly
    });
}
function generateInterfacesSelect(selectedIntf) {
  /* check what protocol selected to fill select list of interfaces with correct data*/
  const protsSelect = document.getElementById("prot");
  const selectedProt = protsSelect.options[protsSelect.selectedIndex].value;

  function setAdditionalInterfaceInfo() {
    setIntfInfoLabel();
    setIntfInfo1();
  }
  generateSelect(
    "interface-container",
    "intf",
    interfacesArr[selectedProt],
    selectedIntf,
    setAdditionalInterfaceInfo
  );

  setAdditionalInterfaceInfo();
}

function getAvailablePrinters(protId, intfInfo) {
  fetch(`${urlLocation}${apiUrlDM}printerlist?prot_id=${protId}`)
      .then(response => {
        if (response.ok) {
          return response.json();
        } else {
          throw new Error('Помилка при отриманні списку принтерів');
        }
      })
      .then((result) => {
        const printers = result.printers.map(({ name: capt }) => ({ id: capt, capt }));

        generateSelect(
            "intf_info-container",
            "intf_info",
            printers,
            { id: intfInfo }
        );
      })
      .catch((error) => {
        // Handle the error if printerlist http status is not 200
        console.error(error);
        generateInputText("intf_info-container", "intf_info", intfInfo);
      });
}

function getCodePage(codepage) {
  fetch(`${urlLocation}/dm/api/v3/registry/codepages`)
    .then((response) => response.json())
    .then((result) => {
      codepages = result.cp;
      generateSelect("codepage-container", "cp", result.cp, codepage);
    });
}

function generateFisParamsBlock(fis_params) {
  if (fis_params) {
    fisParamsContainerNode.classList.remove("hidden");
    generateInputText("clogin-container", "clogin", fis_params.clogin);
    generateInputText("cpwd-container", "cpwd", fis_params.cpwd);
    generateInputText("fisid-container", "fisid", fis_params.fisid);
  } else {
    fisParamsContainerNode.classList.add("hidden");
  }
}
function generateDocParamsBlock(doc_params) {
  if (doc_params) {
    docParamsContainerNode.classList.remove("hidden");
    generateInputNumber(
      "line_width-container",
      "line_width",
      doc_params.line_width
    );
    generateInputNumber(
      "pixel_width-container",
      "pixel_width",
      doc_params.pixel_width
    );
    is_doc && generateInputNumber(
      "whites_count-container",
      "whites_count",
      doc_params.whites_count
    );
    is_doc && generateInputNumber(
        "margin-container",
        "margin",
        doc_params.margin
    );
    generateUploadInput(
      "top_image-container",
      "top_image-val",
      doc_params.top_image
    );
    generateUploadInput(
      "bottom_image-container",
      "bottom_image-val",
      doc_params.bottom_image
    );
    generateCheckboxInput(
      "img_mode-container",
      "img_mode-value",
      doc_params.imgMode
    );
    generateCheckboxInput(
        "opendrawer-container",
        "opendrawer-value",
        doc_params.open_drawer
    );
    is_doc && generateCheckboxInput(
      "qr_as_image-container",
      "qr_as_image-value",
      doc_params.qrAsImg
    );
    getCodePage(doc_params.codepage);
  } else {
    docParamsContainerNode.classList.add("hidden");
  }
}
function onUploadLogo(fileInput) {
  /* format to b64 */
  if (fileInput.files[0].size / 1024 / 1024 >= 1) {
    alert("File should be less than 1MB");
    fileInput.value = "";
  } else {
    let file = fileInput.files[0],
      reader = new FileReader();
    reader.readAsDataURL(file);
    reader.onloadend = function () {
      let b64 = reader.result;
      setLogoImage(fileInput, b64);
    };
  }
}
function setLogoImage(nodeElem, b64) {
  const parentContainer = nodeElem.parentElement;
  if (b64) {
    parentContainer.querySelector(".show-img").classList.remove("hidden");
    parentContainer.querySelector(".hidden-value").value = b64;
    parentContainer.querySelector(".button-text").classList.add("hidden");
    parentContainer.querySelector(".show-img .logo").src = b64;
  } else {
    parentContainer.querySelector(".show-img").classList.add("hidden");
    parentContainer.querySelector(".hidden-value").value = "";
    parentContainer.querySelector(".button-text").classList.remove("hidden");
    parentContainer.querySelector(".show-img .logo").src = "";
  }
}
function getIntfInfoLabel(interface) {
  switch (interface) {
    case "Web":
      return getTranslation("deviceDetail.intf_info");
    case "USB":
      return "Назва пристрою в системі";
    case "Bluetooth":
      return "Назва підключеного bluetooth принтера";
    case "Ethernet":
      return "IP";
    case "Internal":
      return getTranslation("deviceDetail.intf_info");
    case "COM":
      return "Порт. Потрібно вказати у форматі: COM№ - де № номер порту";
    case "OSBased":
      return "Обрати принтер із доступних в системі";
    default:
      return getTranslation("deviceDetail.intf_info");
  }
}
function setIntfInfoLabel() {
  const interface = document.getElementById("intf").options[
    document.getElementById("intf").selectedIndex
  ].innerText;
  const intfInfoLabel = getIntfInfoLabel(interface);
  document.querySelector(
    "#intf_info-container label"
  ).innerText = intfInfoLabel;
}

function setIntfInfo1() {
  const interface = document.getElementById("intf").options[
      document.getElementById("intf").selectedIndex
      ].innerText;
  if (isDoc === true && (interface === 'OSBased' || interface === 'USB')) {
    getAvailablePrinters(protId, intfInfo);
  } else {
    generateInputText("intf_info-container", "intf_info", intfInfo);
  }
  if (interface === "COM") {
    generateInputText("intf_info1-container", "intf_info1", intfInfo1Val);
  } else {
    /*get parent div*/
    const parentNode = document.getElementById("intf_info1-container");
    parentNode.classList.add("hidden");

    const parentListCont = parentNode.querySelector("div");
    parentListCont.innerHTML = "";
  }
}
function setActionButtons(){
    if(is_doc){
        document.getElementById('print-test-doc').classList.remove('hidden');
    }
    if(is_fis){
        document.getElementById('print-empty-rec').classList.remove('hidden');
    }
    if(is_pay){
        document.getElementById('bank-echo').classList.remove('hidden');
        document.getElementById('get-merchant-list').classList.remove('hidden');
        document.getElementById('close-shift').classList.remove('hidden');
    }
    if(is_weight){
        document.getElementById('test-weight').classList.remove('hidden');
    }
}

function getDevice() {
  toggleLoader();
  fetch(`${urlLocation}/dm/api/v3/device?dev_id=${deviceId}`)
      .then((response) => response.json())
      .then((result) => {
        toggleLoader();
        is_doc = result.is_doc;
        is_fis = result.is_fis;
        is_pay = result.is_pay;
        is_weight = result.is_weight;
        /* set extra info about device to title*/
        titleNode.innerHTML = ` ${result.manuf.capt} ${
            result.model.capt
        } ${setDeviceTypeIcon(result)}`;

        devCodeNode.value = result.dev_code;
        protocolId = result.prot.id;

        if (is_pay) {
          fillTerminalInfo(result);
        } else if (is_doc) {
          fillPrinterInf(result);
        }
      })
      .catch(function (error) {
        toggleLoader();
        callTostSnackbar(`Request failed: ${error}`);
      });
}
function saveDeviceChanges() {
      if (document.getElementById('print-settings').classList.contains('hidden')) {
        let intf_id = '';
        let prot_id = '';
        let prot_capt = '';

        const terminalProt = document.getElementById('terminal-prot').value;
        const terminalInterface = document.getElementById('terminal-interface').value;

        bankProtocols.forEach(({ prot, intfs }) => {
          let protocolFounded = false;

          intfs.forEach(({ intf }) => {
            if (intf.id === terminalInterface && prot.id === terminalProt) {
              protocolFounded = true;
              intf_id = intf.id;
              prot_capt = intf.capt;
            }
          })
  
          if (protocolFounded) {
            prot_id = prot.id;
          }
        });
  
        const body = JSON.stringify({
          dev_code: devCodeNode.value,
          model_id: modelId,
          doc_params: null,
          fis_params: null,
          pay_params: {
            req_async_status: document.getElementById('async-status-req-value').checked,
            wait_before_req: document.getElementById('wait-before-req-value').checked,
            bank_name: document.getElementById('terminal-bankname').value,
            resp_timeout: document.getElementById('resp-timeout').value,
            collision_timeout: document.getElementById('collision-timeout').value,
            commision_percent: +document.getElementById('commision-percent').value
          },
          intf_id,
          prot_id,
          intf_info: prot_capt === 'COM'
              ? document.getElementById('terminal-com').value
              : prot_capt === 'TCP_Server'
                  ? document.getElementById('terminal-tcpserver-port').value
                  : document.getElementById('terminal-ethernet-ip').value,
          intf_info1: prot_capt === 'COM'
            ? document.getElementById('terminal-com-speed').value
            : ''
        });

        toggleLoader();
  
        fetch(`${urlLocation}/dm/api/v3/device?dev_id=${deviceId}`, {
            method: 'POST',
            body
          })
          .then(res => res.json())
          .then(result => {
            toggleLoader();
  
            if (result.errortxt) {
              callTostSnackbar(result.errortxt);
            } else {
              callTostSnackbar(getTranslation("common.saved"));
              deviceCode = devCodeNode.value;
  
              const urlParams = new URLSearchParams(window.location.search);    
              urlParams.set("dev_code", devCodeNode.value);
              history.pushState(null, '', `${window.location.pathname}?${urlParams.toString()}`);
  
              getDevice();
            }
          })
          .catch(error => {
            toggleLoader();
            callTostSnackbar(`Request failed: ${error}`);
          });
      } else {
        let intf_id = '';
        let prot_id = '';
        let prot_capt = '';
  
        const printerInterface = document.getElementById('interface').value;
  
        printerProtocols.forEach(({ prot, intfs }) => {
          let protocolFounded = false;
  
          intfs.forEach(({ intf }) => {
            if (intf.id === printerInterface) {
              protocolFounded = true;
              
              intf_id = intf.id;
              prot_capt = intf.capt;
            }
          })
  
          if (protocolFounded) {
            prot_id = prot.id;
          }
        });

      
        const getIntfInfo = () => {
          if (prot_capt === 'COM') {
            return document.getElementById('printer-com').value;
          } else if (prot_capt === 'Ethernet') {
            return document.getElementById('printer-ethernet-ip').value;
          } else if (prot_capt === 'Bluetooth') {
            return document.getElementById('bluetooth-com').value;
          } else if (prot_capt === 'USB' || prot_capt === 'OSBased') {
            return document.getElementById('printer-name').value;
          }
  
          return '';
        };
  
        const getIntfInfo1 = () => {
          if (prot_capt === 'COM') {
            return document.getElementById('printer-com-speed').value;
          }
  
          return '';
        };

        const getLineWidth = () => {
          const printerSymbolsValue = document.getElementById('symbols-settings').value;

          if (printerSymbolsValue === '58') {
            return 32;
          }
  
          if (printerSymbolsValue === '80') {
            return 48;
          }
  
          return +document.getElementById('symbols_count').value;
        };
  
        const getPixelWidth = () => {
          const printerSymbolsValue = document.getElementById('symbols-settings').value;
          
          if (printerSymbolsValue === 'manual') {
            return +document.getElementById('qr_size').value;
          }
  
          return 12;
        };

        const codepageId = document.getElementById("cp")
          ? document.getElementById("cp").value
          : "";

        const codepage = codepages.find(({ id }) => id === codepageId);

        const body = JSON.stringify({
          dev_code: devCodeNode.value,
          model_id: modelId,
          doc_params: {
            line_width: getLineWidth(),
            pixel_width: getPixelWidth(),
            whites_count: document.getElementById("whites_count").value,
            top_image: document.getElementById("top_image-val").value,
            bottom_image: document.getElementById("bottom_image-val").value,
            qrAsImg: document.getElementById('qr_as_image-value').checked,
            imgMode: document.getElementById('img_mode-value').checked,
            open_drawer: document.getElementById('opendrawer-value').checked,
            codepage,
            draw_mode: document.getElementById("draw-mode").value,
            codepage_mode: document.getElementById("codepage-mode").value,
            margin: document.getElementById("margin").value
          },
          fis_params: null,
          intf_id,
          prot_id,
          intf_info: getIntfInfo(),
          intf_info1: getIntfInfo1()
        });
       
        toggleLoader();
  
        fetch(`${urlLocation}/dm/api/v3/device?dev_id=${deviceId}`, {
            method: 'POST',
            body
          })
          .then(res => res.json())
          .then(result => {
            toggleLoader();
  
            if (result.errortxt) {
              callTostSnackbar(result.errortxt);
            } else {
              callTostSnackbar(getTranslation("common.saved"));
              deviceCode = devCodeNode.value;
  
              const urlParams = new URLSearchParams(window.location.search);
              history.pushState(null, '', `${window.location.pathname}?${urlParams.toString()}`);
  
              getDevice();
            }
          })
          .catch(error => {
            toggleLoader();
            callTostSnackbar(`Request failed: ${error}`);
          });
      }
}
function goToLogs() {
  window.location = `./logs.html?dev_id=${deviceId}`;
}

/* Action Buttons test */
function generateQueryStringForTest(type) {
  const devName = document.getElementById("dev_code").value;
  // const protId = document.getElementById("prot").value;

  return `?dev_id=${deviceId}&type=${type}&prot_id=${protocolId}&dev_name=${devName}`;
}
function testWeight() {
  toggleLoader();
  const queryStr = generateQueryStringForTest("SCL");

  fetch(`${urlLocation}/dm/testweight${queryStr}`)
    .then((response) => response.json())
    .then((result) => {
      toggleLoader();
      /*print if response */
      if (result.res === 0) {
        callTostSnackbar(`Вага: ${result.info.w} грамів`);
      } else if (result.errortxt) {
        callTostSnackbar(`Помилка ${result.res}: ${result.errortxt}`);
      }
    })
    .catch(function (error) {
      toggleLoader();
      callTostSnackbar(`Request failed: ${error}`);
    });
}
function closeShift() {

  toggleLoader();

  const url = `${urlLocation}/dm/execute`;
  const data = {
    ver: 6,
    source: 'VK_UI',
    device: document.getElementById("dev_code").value,
    type: 3,
    pay: {
      task: 11
    }
  };
  const jsonData = JSON.stringify(data);
  
  fetch(url, {
    method: 'POST',
        headers: {
      'Content-Type': 'application/json',
    },
    body: jsonData
  })
    .then((response) => response.json())
    .then((result) => {
      toggleLoader();
      if (result.errortxt) {
        callTostSnackbar(`Помилка при закритті зміни: ${result.errortxt}`);
      } else {
        callTostSnackbar(`Зміну закрито успішно`);
        getDevice();
      }
    })
    .catch(function (error) {
      toggleLoader();
      callTostSnackbar(`Request failed: ${error}`);
    });
}
function openMoneyBox() {
  toggleLoader();

  const body = JSON.stringify({
    ver: 6,
    source: 'VK_UI',
      device: document.getElementById("dev_code").value,
    type: 2,
    doc: {
      opendrawer: 1
    }
  });
  
  fetch(`${urlLocation}/dm/execute`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body
  })
    .then((response) => response.json())
    .then((result) => {
      toggleLoader();
      
      if (result.errortxt) {
        callTostSnackbar(`Помилка при відкритті грошового ящика: ${result.errortxt}`);
      } else {
        callTostSnackbar(`Команду для відкриття ящику відправлено на принтер`);
      }
    })
    .catch(function (error) {
      toggleLoader();
      callTostSnackbar(`Request failed: ${error}`);
    });
}
function getMerchantList(hideResults = false) {
  toggleLoader();
  const queryStr = generateQueryStringForTest("PAY");

  fetch(`${urlLocation}/dm/getmerchantlist${queryStr}`)
    .then((response) => response.json())
    .then((result) => {
      toggleLoader();

      if (result.res === 0) {
        if (hideResults) {
          callTostSnackbar("Зв'язок з терміналом встановлено");
          merchlist = result.merchList;
        } else {
          showModal('merchant-list-modal');
          merchlist = result.merchList;
          fillMerchantListTable(result.merchList);
        }
      } else if (result.errortxt) {
        callTostSnackbar(
          hideResults
            ? `З\'єднання не встановлено: ${result.errortxt}`
            : `Помилка при отриманні списку мерчантів: ${result.errortxt}`
        );
      }
    })
    .catch(function (error) {
      toggleLoader();
      callTostSnackbar(`Request failed: ${error}`);
    });
}
async function getMerchantListLite() {
  toggleLoader();
  const queryStr = generateQueryStringForTest("PAY");
  return new Promise(resolve => {
    setTimeout(() => {
        fetch(`${urlLocation}/dm/getmerchantlist${queryStr}`)
            .then((response) => response.json())
            .then((result) => {
              toggleLoader();
              if (result.res === 0) {
                merchlist = result.merchList;
                resolve(merchlist);
              } else {
                resolve(merchlist);
              }
            })
            .catch(function (error) {
              toggleLoader();
              callTostSnackbar(`Request failed: ${error}`);
            }
      )
    }, 100);
  });
}

async function showModalExecuteOperation() {

  const container = document.getElementById('merchant-list-container');
  let element;
  const label = document.createElement('label');
  label.setAttribute('for', 'operation-merch');
  label.textContent = 'Введіть назву або номер мерчанту (можна залишити порожнім)';
  if (!merchlist) {
    await getMerchantListLite();


    if (!merchlist) {
      element = document.createElement('input');
      element.type = 'text';
      element.id = 'operation-merch';
      element.name = 'operation-merch';
      element.placeholder = 'Введіть назву або номер мерчанту (можна залишити порожнім)';
    } else {
      element = document.createElement('select');
      element.id = 'operation-merch';
      element.name = 'operation-merch';
      element.placeholder = 'Введіть назву або номер мерчанту (можна залишити порожнім)';

      merchlist.forEach(item => {
        const option = document.createElement('option');
        option.value = item.num;
        option.textContent = item.id.trim();
        element.appendChild(option);
      });
    }
  } else {
    {
      element = document.createElement('select');
      element.id = 'operation-merch';
      element.name = 'operation-merch';
      element.placeholder = 'Введіть назву або номер мерчанту (можна залишити порожнім)';

      merchlist.forEach(item => {
        const option = document.createElement('option');
        option.value = item.num;
        option.textContent = item.id.trim();
        element.appendChild(option);
      });
    }
  }


  container.innerHTML = '';
  container.appendChild(label);
  container.appendChild(element);

  document.getElementById('execute-operation-modal').classList.remove('hidden');
  document.getElementById('overlay').classList.remove('hidden');
}
function hideModalExecuteOperation(){
  document.getElementById('execute-operation-modal').classList.add('hidden');
  document.getElementById('overlay').classList.add('hidden');
  document.getElementById('error-execute-operation').classList.add('hidden');
}
function operationChangeHandler(operation_type) {

  if (operation_type === 1) {
    document.getElementById('operation-refundid-container').classList.add('hidden');
    document.getElementById('operation-cancelid-container').classList.add('hidden');
    document.getElementById('purchase-button').classList.add('active');
    document.getElementById('refund-button').classList.remove('active')
    document.getElementById('void-button').classList.remove('active')

  } else if (operation_type === 2) {
    document.getElementById('operation-refundid-container').classList.remove('hidden');
    document.getElementById('operation-cancelid-container').classList.add('hidden');
    document.getElementById('purchase-button').classList.remove('active');
    document.getElementById('refund-button').classList.add('active')
    document.getElementById('void-button').classList.remove('active')
  } else if (operation_type === 3) {
    document.getElementById('operation-refundid-container').classList.add('hidden');
    document.getElementById('operation-cancelid-container').classList.remove('hidden');
    document.getElementById('purchase-button').classList.remove('active');
    document.getElementById('refund-button').classList.remove('active')
    document.getElementById('void-button').classList.add('active')
  }
}
function ExecuteOperation() {
  toggleLoader();
  let task;
  const tasksum = Number(document.getElementById("operation-sum").value);
  if (document.getElementById('purchase-button').classList.contains('active')) {
    task = 1;
  } else if (document.getElementById('refund-button').classList.contains('active')) {
    task = 2;
  } else if (document.getElementById('void-button').classList.contains('active')) {
    task = 3;
  }

  const data = {
    ver: 6,
    source: 'vkUi',
    device: document.getElementById("dev_code").value,
    type: 3,
    pay: {
      task: task,
      merch: document.getElementById("operation-merch").value,
      sum : tasksum,
      refundid: document.getElementById("operation-refundid").value,
      cancelid: document.getElementById("operation-cancelid").value
    },
  };

  const jsonData = JSON.stringify(data);
  fetch(`${urlLocation}/dm/execute`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: jsonData,
  })
      .then((response) => response.json())
      .then((result) => {
        toggleLoader();

        if (result.res === 0) {
          hideModalExecuteOperation();
          callTostSnackbar("Операція проведена успішно");
        } else if (result.errortxt) {
          document.getElementById('error-execute-operation').classList.remove('hidden');
          document.getElementById('error-execute-operation').innerHTML =
              result.errortxt;
        }
      })
      .catch(function (error) {
        toggleLoader();
        callTostSnackbar(`Request failed: ${error}`);
      });
}
function getJsonForTest(type) {
  /* get JSON data for printing */
  toggleLoader();
  const queryStr = generateQueryStringForTest(type);
  const endPoint = type === "FIS" ? "testreceipt" : "testprint";

  fetch(`${urlLocation}/dm/${endPoint}${queryStr}`)
    .then((response) => response.json())
    .then((result) => {
      toggleLoader();
      /*print if response */
      if (result.res === 0) {
        callTostSnackbar("Тест пройдено успішно");
      } else if (result.errortxt) {
        callTostSnackbar(`Помилка ${result.res}: ${result.errortxt}`);
      }
    })
    .catch(function (error) {
      toggleLoader();
      callTostSnackbar(`Request failed: ${error}`);
    });
}
getDevice();















function fillMerchantListTable(merchants = []) {
  const merchantsTable = document.getElementById('merchant-list-table');
  merchantsTable.innerHTML = '';
if (merchants.length === 0) {
  document.getElementById('merchant-list').classList.add('hidden');
  document.getElementById('empty-merchant-list').classList.remove('hidden');
} else {
  document.getElementById('merchant-list').classList.remove('hidden');
  document.getElementById('empty-merchant-list').classList.add('hidden');
  merchants.forEach(({ num, id }) => {
    const trNode = `
      <tr>
        <td>${num}</td>
        <td>${id}</td>
      </tr>`;

    merchantsTable.insertAdjacentHTML('beforeend', trNode);
  })
}

}

function fillTerminalInfo(res) {
  document.querySelector('.terminal-buttons').classList.remove('hidden');

  if (res.model.id === '988f87a0-92f1-4fba-96f9-a7097874be7b' || res.model.id === '{988F87A0-92F1-4FBA-96F9-A7097874BE7B}' || res.model.id === '988F87A0-92F1-4FBA-96F9-A7097874BE7B') {
    document.querySelector('#terminal-bankname-container').classList.remove('hidden');
    document.getElementById('terminal-bankname').value = res.pay_params.bank_name;
  } else {
    document.querySelector('#terminal-bankname-container').classList.add('hidden');
    document.getElementById('terminal-bankname').value = res.pay_params.bank_name;
  }
  if (res.intf.capt === 'COM') {
    document.getElementById('terminal-com').value = res.intf_info;
    document.getElementById('terminal-com-speed').value = res.intf_info1;
  } else if (res.intf.capt === 'Ethernet') {
    document.getElementById('terminal-ethernet-ip').value = res.intf_info;
  } else if (res.intf.capt === 'TCP_Server') {
    document.getElementById('terminal-tcpserver-port').value = res.intf_info;
  }

  document.querySelector('#terminal-com-settings-container').classList.add('hidden');
  document.querySelector('#terminal-ethernet-settings-container').classList.add('hidden');
  document.querySelector('#terminal-tcpserver-settings-container').classList.add('hidden');

  if (res.intf.capt === 'Ethernet') {
    document.querySelector('#terminal-ethernet-settings-container').classList.remove('hidden');
  } else if (res.intf.capt === 'COM') {
    fetch(`${urlLocation}/dm/comlist`)
        .then(res => res.json())
        .then((ports) => {
          const comNamesNode = document.getElementById('com-ports');

          comNamesNode.innerHTML = '';

          ports.forEach((port) => {
            const option = document.createElement('option');
            option.value = port;

            comNamesNode.appendChild(option);
          });

        })

    document.querySelector('#terminal-com-settings-container').classList.remove('hidden');
  } else if (res.intf.capt === 'TCP_Server') {
    document.querySelector('#terminal-tcpserver-settings-container').classList.remove('hidden');
  }

  fetch(`${urlLocation}/dm/api/v3/devices/registry`)
    .then(res => res.json())
    .then(({ models }) => {
        printersList = models.filter((m) => m.is_doc && !m.is_other);
        terminalsList = models.filter((m) => m.is_pay && !m.is_other);
      
        modelId = res.model.id;

        generateSelect(
          "bank-container",
          "bank",
          terminalsList.map(({ model }) => model),
          { id: res.model.id }
        );

      generateInputNumber(
          "resp-timeout-container",
          "resp-timeout",
          res.pay_params.resp_timeout === 0 ? 300 : res.pay_params.resp_timeout
      );

      generateInputNumber(
          "collision-timeout-container",
          "collision-timeout",
          res.pay_params.collision_timeout === 0 ? 300 : res.pay_params.collision_timeout
      );

      generateInputNumber(
          "commision-percent-container",
          "commision-percent",
          res.pay_params.commision_percent
      );

        fetch(`${urlLocation}/dm/api/v3/registry/prots?model_id=${res.model.id}`)
          .then(res => res.json())
          .then(({ prots }) => {
            bankProtocols = prots;

            generateSelect(
                "terminal-protocol-container",
                "terminal-prot",
                prots.map(protocol => ({
                  id: protocol.prot.id,
                  capt: protocol.prot.capt
                })),
                { id: res.prot.id }
            );

            for (let i = 0; i < bankProtocols.length; i++) {
              if (bankProtocols[i].prot.id === document.getElementById("terminal-prot").value) {
                choosedProtocol = bankProtocols[i].intfs[0].intf.capt;
                generateSelect(
                    "terminal-interface-container",
                    "terminal-interface",
                    bankProtocols[i].intfs.map(interface => ({
                      id: interface.intf.id,
                      capt: interface.intf.capt

                    })),
                    { id: res.intf.id }
                );
              }
            }

            document.querySelector('#terminal-prot').addEventListener('change', protChangeHandler);
            document.querySelector('#terminal-interface').addEventListener('change', changeTerminalInterface);
          });

        document.querySelector('#bank').addEventListener('change', bankChangeHandler);
    });
 if (res.prot.capt === 'SSI JSON'
     || res.prot.capt === 'Укрексімбанк(SSI JSON)'
     || res.prot.capt === 'Monobank(SSI JSON)'
     || res.prot.capt === 'Ощадбанк(SSI JSON)'
     || res.prot.capt === 'Райффайзен Банк(SSI JSON)'
     || res.prot.capt === 'Банк Південний(SSI JSON)'
     || res.prot.capt === 'Банк ПУМБ(SSI JSON)'
     || res.prot.capt === 'Банк ТАС(SSI JSON)'
     || res.prot.capt === 'Банк Восток(SSI JSON)'
     || res.prot.capt === 'Полтава-банк (SSI JSON)'
     || res.prot.capt === 'Альтбанк (SSI JSON)'
     || res.prot.capt === 'МТБ Банк (SSI JSON)'
     || res.prot.capt === 'Ощадбанк(BPOS1)'
     || res.prot.capt === 'Укрсиббанк(BPOS1)'
     || res.prot.capt === 'Банк Восток(BPOS1)'
     || res.prot.capt === 'А-Банк(BPOS1)'
     || res.prot.capt === 'Банк Південний(BPOS1)'
     || res.prot.capt === 'Sense Банк(BPOS1)'
     || res.prot.capt === 'BPOS1'
     || res.prot.capt === 'Райффайзен Банк(BPOS1)'
     || res.prot.capt === 'Банк ПУМБ(BPOS1)'
     || res.prot.capt === 'МТБ Банк (BPOS1)') {
    document.querySelector('.printer-buttons').classList.remove('hidden');
    document.querySelector('#print-test-doc').classList.remove('hidden');
  } else if (res.prot.capt === 'PrivatBankJSON') {
    document.querySelector('#wait-before-req-container').classList.remove('hidden');
 } else {
    document.querySelector('.printer-buttons').classList.add('hidden');
    document.querySelector('#wait-before-req-container').classList.add('hidden');
  }
  document.getElementById('async-status-req-value').checked = res.pay_params.req_async_status;
  document.getElementById('wait-before-req-value').checked = res.pay_params.wait_before_req;
  document.querySelector('#term-settings').classList.remove('hidden');
}

function fillPrinterInf(res) {
  document.querySelector('.printer-buttons').classList.remove('hidden');
  document.querySelector('#print-test-doc').classList.remove('hidden');
  document.querySelector('#open-money-box').classList.remove('hidden');

  if (res.intf.capt === 'COM') {
    document.getElementById('printer-com').value = res.intf_info;
    document.getElementById('printer-com-speed').value = res.intf_info1;
  } else if (res.intf.capt === 'Ethernet') {
    document.getElementById('printer-ethernet-ip').value = res.intf_info;
  } else if (res.intf.capt === 'Bluetooth') {
    document.getElementById('bluetooth-com').value = res.intf_info;
  } else if (res.intf.capt === 'USB' || res.intf.capt === 'OSBased') {
    document.getElementById('printer-name').value = res.intf_info;
  }

  document.querySelector('#printer-connected-printers-settings-container').classList.add('hidden');
  document.querySelector('#printer-ethernet-settings-container').classList.add('hidden');
  document.querySelector('#printer-com-settings-container').classList.add('hidden');
  document.querySelector('#printer-bluetooth-settings-container').classList.add('hidden');
  
  if (res.intf.capt === 'COM') {
    fetch(`${urlLocation}/dm/comlist`)
        .then(res => res.json())
        .then((ports) => {
          const comNamesNode = document.getElementById('com-ports');

          comNamesNode.innerHTML = '';

          ports.forEach((port) => {
            const option = document.createElement('option');
            option.value = port;

            comNamesNode.appendChild(option);
          });

        })

    document.querySelector('#printer-com-settings-container').classList.remove('hidden');
  } else if (res.intf.capt === 'Ethernet') {
    document.querySelector('#printer-ethernet-settings-container').classList.remove('hidden');
  } else if (res.intf.capt === 'Bluetooth') {
    fetch(`${urlLocation}/dm/btlist`)
        .then(res => res.json())
        .then((btnames) => {
          const btNamesNode = document.getElementById('bt-names');

          btNamesNode.innerHTML = '';
          btnames.forEach((port) => {
            const option = document.createElement('option');
            option.value = port;

            btNamesNode.appendChild(option);
          });

        })
    document.querySelector('#printer-bluetooth-settings-container').classList.remove('hidden');
  } else if (res.intf.capt === 'USB' || res.intf.capt === 'OSBased') {
    fetch(`${urlLocation}/dm/printerlist?prot_id=${res.intf.id}`)
      .then(res => res.json())
      .then(({ printers }) => {
        const printerNamesNode = document.getElementById('printer-names');

        printerNamesNode.innerHTML = '';

        printers.forEach(({ name }) => {
          const option = document.createElement('option');
          option.value = name;

          printerNamesNode.appendChild(option);
        });

        document.querySelector('#printer-connected-printers-settings-container').classList.remove('hidden');
      });
  }

  fetch(`${urlLocation}/dm/api/v3/devices/registry`)
		.then(res => res.json())
		.then(({ models }) => {
			printersList = models.filter((m) => m.is_doc && !m.is_other);
			terminalsList = models.filter((m) => m.is_pay && !m.is_other);

      modelId = res.model.id;

      fetch(`${urlLocation}/dm/api/v3/registry/prots?model_id=${res.model.id}`)
				.then(res => res.json())
				.then(({ prots }) => {
					printerProtocols = prots;

					generateSelect(
						"interface-container",
						"interface", 
						prots[0].intfs.map(interface => ({
							id: interface.intf.id,
							capt: interface.intf.capt
						})),
						{ id: res.intf.id }
					);

					document.querySelector('#interface').addEventListener('change', changePrinterInterface);
			});
		});

  generateSelect(
    "symbols-settings-container",
    "symbols-settings", 
    [
      { id: "58", capt: '58мм' },
      { id: "80", capt: '80мм' },
      { id: "manual", capt: 'Вручну' },
    ],
    res.doc_params.line_width === 32 || res.doc_params.line_width === 48
      ? { id: res.doc_params.line_width === 32 ? '58' : '80' }
      : { id: "manual" }
  );

  document.getElementById('symbols_count').value = res.doc_params.line_width;
  document.getElementById('qr_size').value = res.doc_params.pixel_width;

  if (document.getElementById('symbols-settings').value === 'manual') {
    document.querySelector('#symbols-printer-settings').classList.remove('hidden');
  }

  document.querySelector('#symbols-settings').addEventListener('change', changeSymbolsSettings);

  document.querySelector('#print-settings').classList.remove('hidden');
  document.querySelector('#additional-print-settings').classList.remove('hidden');

  getCodePage(res.doc_params.codepage);


  generateSelect(
      "draw-mode-container",
      "draw-mode",
      [
        { id: "0", capt: 'За замовчуванням' },
        { id: "1", capt: 'Альтернативний (HPRT, BTP та інші)' },
        { id: "2", capt: 'Для розфіскалізованих РРО' },
        { id: "3", capt: 'Альтернативний 2 (SAM4S та інші)' },
        { id: "4", capt: 'Альтернативний 3 (POS Sector/Vector та інші)' },
      ],
      res.doc_params.draw_mode === 0
          ? { id: "0" }
          : res.doc_params.draw_mode === 1
              ? { id: "1" }
              : res.doc_params.draw_mode === 2
                  ? { id: "2" }
                  : res.doc_params.draw_mode === 3
                      ? { id: "3" }
                      : res.doc_params.draw_mode === 4
                          ? { id: "4" }
                          : { id: "0" }
  );

  generateSelect(
      "codepage-mode-container",
      "codepage-mode",
      [
        { id: "0", capt: 'За замовчуванням' },
        { id: "1", capt: 'Альтернативний' },
      ],
      res.doc_params.codepage_mode === 0
          ? { id: "0" }
          : { id: "1" }
  );

  generateInputNumber(
    "whites_count-container",
    "whites_count",
    res.doc_params.whites_count
  );

  generateInputNumber(
      "margin-container",
      "margin",
      res.doc_params.margin
  );

  generateUploadInput(
    "top_image-container",
    "top_image-val",
    res.doc_params.top_image
  );
  generateUploadInput(
    "bottom_image-container",
    "bottom_image-val",
    res.doc_params.bottom_image
  );

  document.getElementById('qr_as_image-value').checked = res.doc_params.qrAsImg;
  document.getElementById('img_mode-value').checked = res.doc_params.imgMode;
  document.getElementById('opendrawer-value').checked = res.doc_params.open_drawer;
}

function bankChangeHandler({ target: { value } }) {
	modelId = value;

	fetch(`${urlLocation}/dm/api/v3/registry/prots?model_id=${value}`)
		.then(res => res.json())
		.then(({ prots }) => { 
			bankProtocols = prots;

			let choosedProtocol = prots[0].intfs[0].intf.capt; 

			generateSelect(
				"terminal-interface-container",
				"terminal-interface", 
				prots[0].intfs.map(interface => ({
						id: interface.intf.id,
						capt: interface.intf.capt
					
				})),
				{ id: prots[0].intfs[0].intf.id }
			);
          generateSelect(
              "terminal-protocol-container",
              "terminal-prot",
              prots.map(protocol => ({
                id: protocol.prot.id,
                capt: protocol.prot.capt
              })),
              { id: prots[0].prot.id }
          );
          document.querySelector('#terminal-prot').addEventListener('change', protChangeHandler);
			
			document.querySelector('#terminal-com-settings-container').classList.add('hidden');
			document.querySelector('#terminal-ethernet-settings-container').classList.add('hidden');
            document.querySelector('#terminal-tcpserver-settings-container').classList.add('hidden');

          if (modelId === '988f87a0-92f1-4fba-96f9-a7097874be7b' || modelId === '{988F87A0-92F1-4FBA-96F9-A7097874BE7B}' || modelId === '988F87A0-92F1-4FBA-96F9-A7097874BE7B') {
            document.querySelector('#terminal-bankname-container').classList.remove('hidden');
          } else {
            document.querySelector('#terminal-bankname-container').classList.add('hidden');
          }
			if (choosedProtocol === 'Ethernet') {
				document.querySelector('#terminal-ethernet-settings-container').classList.remove('hidden');
			} else if (choosedProtocol === 'COM') {
				document.querySelector('#terminal-com-settings-container').classList.remove('hidden');
			} else if (choosedProtocol === 'TCP_Server') {
              document.querySelector('#terminal-tcpserver-settings-container').classList.remove('hidden');
            }

			document.querySelector('#terminal-interface').addEventListener('change', changeTerminalInterface);
	});
}

function protChangeHandler({ target: { value } }) {
  document.querySelector('#terminal-com-settings-container').classList.add('hidden');
  document.querySelector('#terminal-ethernet-settings-container').classList.add('hidden');
  document.querySelector('#terminal-tcpserver-settings-container').classList.add('hidden');

  let choosedProtocol = '';


  for (let i = 0; i < bankProtocols.length; i++) {
    if (bankProtocols[i].prot.id === value) {
      choosedProtocol = bankProtocols[i].intfs[0].intf.capt;
      generateSelect(
          "terminal-interface-container",
          "terminal-interface",
          bankProtocols[i].intfs.map(interface => ({
            id: interface.intf.id,
            capt: interface.intf.capt

          })),
          { id: bankProtocols[i].intfs[0].intf.id }
      );
    }
  }

  if (choosedProtocol === 'Ethernet') {
    document.querySelector('#terminal-ethernet-settings-container').classList.remove('hidden');
  } else if (choosedProtocol === 'COM') {
    document.querySelector('#terminal-com-settings-container').classList.remove('hidden');
  } else if (choosedProtocol === 'TCP_Server') {
    document.querySelector('#terminal-tcpserver-settings-container').classList.remove('hidden');
  }
  document.querySelector('#terminal-interface').addEventListener('change', changeTerminalInterface);

}

function changeTerminalInterface({ target: { value } }) {
  document.querySelector('#terminal-ethernet-settings-container').classList.add('hidden');
  document.querySelector('#terminal-com-settings-container').classList.add('hidden');
  document.querySelector('#terminal-tcpserver-settings-container').classList.add('hidden');

	let choosedProtocol = '';

	bankProtocols.forEach(({ intfs }) =>
		intfs.forEach(({ intf }) => {
			if (intf.id === value) {
				choosedProtocol = intf.capt;
			}
	}));

  if (choosedProtocol === 'Ethernet') {
    document.querySelector('#terminal-ethernet-settings-container').classList.remove('hidden');
  } else if (choosedProtocol === 'COM') {
    document.querySelector('#terminal-com-settings-container').classList.remove('hidden');
  } else if (choosedProtocol === 'TCP_Server') {
    document.querySelector('#terminal-tcpserver-settings-container').classList.remove('hidden');
  }
}

function changePrinterInterface({ target: { value } }) {
  document.querySelector('#printer-connected-printers-settings-container').classList.add('hidden');
  document.querySelector('#printer-ethernet-settings-container').classList.add('hidden');
  document.querySelector('#printer-com-settings-container').classList.add('hidden');
  document.querySelector('#printer-bluetooth-settings-container').classList.add('hidden');

  let choosedProtocol = '';

	printerProtocols.forEach(({ intfs }) =>
		intfs.forEach(({ intf }) => {
			if (intf.id === value) {
				choosedProtocol = intf.capt;
			}
	}));
  
  if (choosedProtocol === 'USB' || choosedProtocol === 'OSBased ') {
    document.querySelector('#printer-connected-printers-settings-container').classList.remove('hidden');
  } else if (choosedProtocol === 'Ethernet') {
    document.querySelector('#printer-ethernet-settings-container').classList.remove('hidden');
  } else if (choosedProtocol === 'COM') {
    document.querySelector('#printer-com-settings-container').classList.remove('hidden');
  } else if (choosedProtocol === 'Bluetooth') {
    document.querySelector('#printer-bluetooth-settings-container').classList.remove('hidden');
  }
}

function changeSymbolsSettings({ target: { value } }) {
  if (value === 'manual') {
    document.querySelector('#symbols-printer-settings').classList.remove('hidden');
  } else {
    document.querySelector('#symbols-printer-settings').classList.add('hidden');
  }
}

function toggleBox(nodeId) {
  document.querySelector(`#${nodeId}`).classList.toggle('open');
}