const deviceListNode = document.querySelector('#main-table-container');
const remoteAccessNode = document.querySelector('.remote-access');
const actionEdit = "<span class='edit'><img src='./images/edit.png' /></span>";
const actionShowRegistry = "<span class='show-registry'><img src='./images/show-registry.png' /></span>";
const actionDelete =
	"<span class='delete' onclick='showModalAsk(deleteDevice, this)'><img src='./images/delete.png' /></span>";
const urlLocation = location.origin;
// const urlLocation = "http://localhost:3939";
const apiUrl = 'dm/vchasno-kasa/api/v1/';

/* Current Day logs block */
const logsContainer = document.getElementById('current-day-logs-container');
const logsRefreshButton = document.getElementById('current-day-logs-refresh');
const logsError = document.getElementById('error-text-current-day-logs');
const DEFAULT_LOGS_SIZE = 64000;
let logsOffset = 0;
let logsSize = DEFAULT_LOGS_SIZE;
let stopFetchingLogs = false;

// will be initialised after getDeviceList() call
let version = null;
let need_upd = null;
let dfs = null;

const statusDesc = {
	0: {
		caption: 'Online',
		className: 'green',
	},
	1: {
		caption: 'Online, поточна помилка не потребує уваги',
		className: 'yellow',
	},
	2: {
		caption: 'Online, помилка потребує уваги',
		className: 'yellow',
	},
	10: {
		caption: 'Offline',
		className: 'blue',
	},
	12: {
		caption: 'Offline, помилка потребує уваги',
		className: 'yellow',
	},
	20: {
		caption: 'Заблоковано',
		className: 'red',
	},
};
function toggleLoader() {
	document.getElementById('loader-box').classList.toggle('active');
}
function getSettingsData() {
	fetch(`${urlLocation}/dm/settings`)
		.then((response) => response.text())
		.then((result) => {
			if (result.extAccess) {
				remoteAccessNode.classList.remove('hidden');
				remoteAccessNode.innerText = 'Відкрито доступ ззовні';
			} else {
				remoteAccessNode.classList.add('hidden');
				remoteAccessNode.innerText = '';
			}
		})
}
getSettingsData();
function formatOfflineTime(time) {
	const hours =
		Math.floor(time / 60) > 9
			? Math.floor(time / 60)
			: `0${Math.floor(time / 60)}`;
	const minutes = time % 60 > 9 ? time % 60 : `0${time % 60}`;
	return `${hours}:${minutes}`;
}
function setAdditionalInfo(version, need_upd, dfs) {
	const versionContainerNode = document.querySelector('.additional-info .version');
	versionContainerNode.innerHTML = '';

	let dfsClass = 'green';
	let needUpdNode = document.createElement('span');
	const versionNode = document.createElement('span');
	const updateDeviceManager = document.createElement('button')
	updateDeviceManager.innerText = 'Перейти до оновлення';
	updateDeviceManager.className = 'update-device-manager';
	updateDeviceManager.addEventListener('click', showUpdateBox);
	versionNode.innerText = version;

	dfs < 95 && dfs > 50 && (dfsClass = 'orange');
	dfs <= 50 && (dfsClass = 'red');

	document.querySelector('.additional-info .dfs span').classList.add(dfsClass);
	document.querySelector('.additional-info .dfs span').innerText =
		dfs < 0 ? 'Не доступна' : `${dfs}%`;

	if (need_upd === 1) {
		needUpdNode.innerText = ' (доступна нова версія)';
		needUpdNode.className = 'red';
	} else if (need_upd === 2) {
		needUpdNode.innerText = ' (поточна версія)';
		needUpdNode.className = 'green';
	}

	versionContainerNode.insertAdjacentElement('beforeend', versionNode);
	versionContainerNode.insertAdjacentElement('beforeend', needUpdNode);
	need_upd === 1 && versionContainerNode.insertAdjacentElement('beforeend', updateDeviceManager);
}

function showUpdateBox() {
	document.getElementById('modal-update').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}

function hideUpdateBox() {
	document.getElementById('modal-update').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
}

function openChangeLog() {
	window.open('https://wiki-kasa.vchasno.ua/uk/DeviceManager/Changelog');
}

function updateDeviceManagerVersion() {
	toggleLoader();
	fetch(`${urlLocation}/dm/api/v1/app-update`, { method: 'POST', body: JSON.stringify({}) })
		.then((response) => response.json())
		.then(result => {
			if (result.res === 0) {
				document.getElementById('error-text-update').classList.add('hidden');
				document.getElementById('success-text-update').classList.remove('hidden');
				document.getElementById('update-success').innerText = result.errortxt;
			} else {
				document.getElementById('error-text-update').classList.remove('hidden');
				document.getElementById('success-text-update').classList.add('hidden');
				document.getElementById('update-error').innerText = `Помилка оновлення: ${result.errortxt}`;
			}
			toggleLoader();
		})
		.catch(function (error) {
			document.getElementById('error-text-update').classList.remove('hidden');
			document.getElementById('success-text-update').classList.add('hidden');
			document.getElementById('update-error').innerText = `Помилка оновлення: ${error}`;
			toggleLoader();
		})
}
function isEndOfSighKey(endStr) {
	if (endStr) {
		const today = new Date();
		const endDate = new Date(
			endStr.substr(0, 4),
			endStr.substr(4, 2) - 1,
			endStr.substr(6, 2)
		);
		const Days = Math.floor(
			(endDate.getTime() - today.getTime()) / (1000 * 60 * 60 * 24)
		);
		return Days > 5 ? false : true;
	}
	return false;
}
function fillDeviceListData(deviceList) {
	for (let device of deviceList) {
		/* prev key info */
		const signInfo = device.signinfo && JSON.parse(device.signinfo);

		const expiredDateOfSignKey = isEndOfSighKey(signInfo?.endTime);

		let signInfoText = '';
		if (
			signInfo &&
			(signInfo.subjectCN === signInfo.subjectOrg || !signInfo.subjectOrg)
		) {
			signInfoText = signInfo.subjectCN;
		} else if (signInfo) {
			signInfoText = `${signInfo.subjectCN} (${signInfo.subjectOrg})`;
		}

		/* open shift time */
		const shiftPostTime = device.shiftterm / 60;
		let shiftPosClassName = '';

		switch (true) {
			case shiftPostTime && shiftPostTime <= 20:
				shiftPosClassName = 'green';
				break;
			case shiftPostTime < 24 && shiftPostTime > 20:
				shiftPosClassName = 'yellow';
				break;
			case shiftPostTime >= 24:
				shiftPosClassName = 'red';
				break;
		}
		let offline_str = '';
		/* offline time */
		if (device.prro_status === 10 || device.prro_status === 12 || device.prro_status === 20) {
			offline_str = `<span class='offline_time'>Офлайн ${formatOfflineTime(
				device.offline_time1
			)} / ${formatOfflineTime(device.offline_time2)}</span>`;
		} else if (device.offline_time2) {
			offline_str = `<span class='offline_time'>Офлайн ${formatOfflineTime(
				device.offline_time2
			)}</span>`;
		}
		/* format date of shift open */
		const shiftOpenDate =
			device.shiftdt &&
			`${device.shiftdt.substr(6, 2)}.${device.shiftdt.substr(
				4,
				2
			)}.${device.shiftdt.substr(0, 4)}<br>${device.shiftdt.substr(
				8,
				2
			)}:${device.shiftdt.substr(10, 2)}:${device.shiftdt.substr(12, 2)}`;

		/* paid_date_to */
		let paidDateToClass = '';
		let paidDateTo;

		if (device.billing) {
			paidDateTo = device.billing.paid_date_to &&
				`${device.billing.paid_date_to.substr(
					6, 2)}.${device.billing.paid_date_to.substr(
						4, 2)}.${device.billing.paid_date_to.substr(
							0, 4)}`;

			const dayNow = new Date();
			const dayToday = new Date(dayNow.getFullYear(), dayNow.getMonth(), dayNow.getDate());
			const dayPaid = device.billing.paid_date_to && new Date(
				+device.billing.paid_date_to.substr(0, 4),
				+device.billing.paid_date_to.substr(4, 2) - 1,
				+device.billing.paid_date_to.substr(6, 2)
			)

			if (!device.billing.paid_date_to) {
				paidDateToClass = '';
			} else if ((dayPaid - dayToday) / 86400000 > 3) {
				paidDateToClass = 'green';
			} else if (dayPaid <= dayToday && (device.billing.enough_to_renew_subscription == 0 || device.billing.enough_to_renew_subscription == 2)) {
				paidDateToClass = 'red';
			} else if (dayPaid <= dayToday && device.billing.enough_to_renew_subscription == 1) {
				paidDateToClass = 'green';
			} else if ((dayPaid - dayToday) / 86400000 <= 3 && device.billing.enough_to_renew_subscription == 2) {
				paidDateToClass = 'orange';
			} else if ((dayPaid - dayToday) / 86400000 <= 3 && device.billing.enough_to_renew_subscription == 1) {
				paidDateToClass = 'green';
			}
		}
		/* paid_date_to */

		const signInfoClasses = expiredDateOfSignKey ? 'auto-height red' : 'auto-height';

		let trNode =
			`<tr data-id="${device.dev_id}" class="row ${device.blocked === 1 ? 'blue' : ''}">
				<td class="device_name mob-${shiftPosClassName}"><span class="visible-xs"><span class="device-indicator ${statusDesc[device.prro_status].className}"></span>Пристрій:</span>${device.device}</td>
				<td><span class="visible-xs">Тип:</span>${device.prro_type ? 'Тестовий' : 'Фіскальний'}</td>
				<td><span class="visible-xs">Номер ПРРО:</span>${device.fisid}</td><td class="${signInfoClasses}"><span class="visible-xs">ЕЦП:</span>${signInfoText}</td>
				<td class="${shiftPosClassName}"><span class="visible-xs">Зміна:</span>${device.shiftdt ? shiftOpenDate : 'Закрита'}</td>
				<td class='${statusDesc[device.prro_status].className}'><span class="visible-xs">Статус:</span>${statusDesc[device.prro_status].caption}</td>
				<td class='${paidDateToClass}'><span class="visible-xs">Оплачена до:</span>${device.billing && device.billing.paid_date_to ? paidDateTo : 'Немає даних'}</td>
				<td><span class="visible-xs">Інфо:</span>${offline_str}${device.prro_info}</td><td>${actionShowRegistry}${actionEdit}${!device.shiftdt ? actionDelete : ''}</td>
			</tr>`;
		deviceListNode.insertAdjacentHTML('beforeend', trNode);
	}
}
async function getDeviceList() {
	toggleLoader();

	const dashboardInfo = await fetch(`${urlLocation}/${apiUrl}dashboard`, {
		headers: {
			"Cookie": "DMUIToken=28d7847f1ca7eb11b30091ed57b6b772"
		}
	})
		.then((response) => response.text())
		.then((result) => {
			let changedResult = result.replaceAll(/\\\\U0027/g, "'");
			changedResult = JSON.parse(changedResult);
			if (changedResult.devices.length >= 7) {
				checkSqlitePrroCap();
				document.getElementById("sqliteCapWarning").innerHTML = `
<p>Застосунок використовує базу даних SQLite. Дозволено створювати не більше 10 ПРРО!<br>У вас уже створено: ${changedResult.devices.length} ПРРО<br><a href="https://wiki-kasa.vchasno.ua/uk/DeviceManager/Start/Requirements" target="_blank">Детальніше про наявні обмеження</a></p>`;
			} else {
				document.getElementById('sqliteCapWarning').classList.add('hidden');
			}
			let serverAlias = changedResult.server_alias;
			let headerElement = document.getElementById("server_alias_name");

			if (serverAlias === "") {
				headerElement.textContent = "ПРРО";
			} else {
				headerElement.textContent = `ПРРО: ${serverAlias}`;
			}

			const deviceList = changedResult.devices;
			if (deviceList && deviceList.length) {
				deviceListNode.innerHTML = '';
				deviceList && fillDeviceListData(deviceList);
				!document.getElementById('empty-list').classList.contains('hidden') && document.getElementById('empty-list').classList.add('hidden');
				document.querySelector('.main.device-list-page').classList.remove('hidden');

				afterReload(deviceList);
			} else {
				document.getElementById('empty-list').classList.remove('hidden');
				document.querySelector('.main.device-list-page').classList.add('hidden');
			}

			return changedResult;
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		})
		.finally(() => {
			toggleLoader();
		});

	const adminPanelButton = document.getElementById("admin-panel-button");
	const logoutButton = document.getElementById("logout-button");

	if (logoutButton.classList.contains("hidden")) {
		adminPanelButton.classList.remove("auth-active-style");
	} else {
		adminPanelButton.classList.add("auth-active-style");
	}

	const dfsAvailabilityPromise = fetch(`${urlLocation}/${apiUrl}dfs_availability`)
		.then(response => response.json())
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		});

	const needUpdatePromise = fetch(`${urlLocation}/${apiUrl}svc_need_update`)
		.then(response => response.json())
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		});

	Promise.all([needUpdatePromise, dfsAvailabilityPromise])
		.then(([needUpdateResponse, dfsAvailabilityResponse]) => {
			if (
				dashboardInfo?.server_v &&
				(needUpdateResponse?.need_update || needUpdateResponse?.need_update === 0) &&
				(dfsAvailabilityResponse?.availability || dfsAvailabilityResponse?.availability === 0)
			) {
				version = dashboardInfo.server_v;
				need_upd = needUpdateResponse.need_update;
				dfs = dfsAvailabilityResponse.availability;

				setAdditionalInfo(
					dashboardInfo.server_v,
					needUpdateResponse.need_update,
					dfsAvailabilityResponse.availability
				);
			}
		});
}

function afterReload(deviceList) {
	const editButtons = document.querySelectorAll('#main-table .edit');
	const showRegistryButtons = document.querySelectorAll('#main-table .show-registry');
	const tableRows = document.querySelectorAll('#main-table tr');

	for (let editButton of editButtons) {
		editButton.onclick = function (e) {
			e.stopPropagation();

			const deviceId = editButton.closest('.row').getAttribute('data-id');
			window.location = `./devicedetail.html?dev_id=${deviceId}`;
		};
	}
	for (let showRegistryButton of showRegistryButtons) {
		showRegistryButton.onclick = function (e) {
			e.stopPropagation();

			const deviceId = showRegistryButton.closest('.row').getAttribute('data-id');
			const device = deviceList.find(({ dev_id }) => dev_id === deviceId).device;

			window.location = `./shifts.html?device=${device}&version=${version}&need_upd=${need_upd}&dfs=${dfs}`;
		}
	}
	for (let tableRow of tableRows) {
		tableRow.onclick = function () {
			if (window.innerWidth < 768) {
				tableRow.classList.toggle('opened');
			}
		}
	}
}
function hideModalAddPrro() {
	document.getElementById('modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
}
function showModalAddPrro() {
	document.getElementById('modal').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}

function checkSqlitePrroCap() {
	fetch(`${urlLocation}/dm/api/v1/sys_info`, {
		method: 'GET',
	})
		.then((response) => response.json())
		.then((result) => {
			if (result.database === 'SQLite') {
				document.getElementById('sqliteCapWarning').classList.remove('hidden');
			} else {
				document.getElementById('sqliteCapWarning').classList.add('hidden');
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function validateCheckBox(checkboxNode) {
	if (checkboxNode.checked) {
		checkboxNode.value = true;
		checkboxNode.checked = true;
	} else {
		checkboxNode.value = false;
		checkboxNode.checked = false;
	}
}
function deleteDevice(deleteButtonNode) {
	toggleLoader();
	const parentNode = deleteButtonNode.closest('.row');
	const deviceId = parentNode.getAttribute('data-id');

	fetch(`${urlLocation}/${apiUrl}prro?dev_id=${deviceId}`, {
		method: 'DELETE',
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				document.getElementById('error-text-action-ask').classList.remove('hidden');
				document.getElementById('error-text-action-ask').innerHTML =
					result.errortxt;
			} else {
				hideModalAsk();
				callTostSnackbar('ПРРО успішно видалено');
				getDeviceList();
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}
document.addPrro.onsubmit = function (e) {
	e.preventDefault();
	let device_data = new FormData(document.getElementById('addPrro'));
	let object = {};

	device_data.forEach((value, key) => {
		object[key] = value;
	});
	object.can_offline = true;
	let data = JSON.stringify(object);

	if (!object.device) {
		callTostSnackbar("Потрібно вказати ім'я пристрою");
		return;
	}

	toggleLoader();

	fetch(`${urlLocation}/${apiUrl}prro`, {
		method: 'POST',
		body: data,
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.errortxt) {
				document.getElementById('error-add-prro').innerText = result.errortxt;
			} else {
				document.getElementById('error-add-prro').innerText = '';
				callTostSnackbar('ПРРО створено успішно');
				getDeviceList();
				setTimeout(function () {
					hideModalAddPrro();
					window.location = `${urlLocation}/dm/vchasno-kasa/devicedetail.html?dev_id=${result.dev_id}`;
				}, 3000);
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
};
function AddToAdminChangeHandler(is_add_to_admin) {
	if (is_add_to_admin === 'false') {
		document.getElementById('file-key-button').classList.remove('active');
		document.getElementById('cloud-cap-button').classList.add('active');
		document.getElementById('add-to-admin-container').classList.add('hidden');
		document.getElementById('admin-token-input-container').classList.remove('hidden');
		document.getElementById('error-add-to-admin').classList.add('hidden');
		document.getElementById('error-admin-panel').classList.remove('hidden');
		getAdminToken();
	} else {
		document.getElementById('file-key-button').classList.add('active');
		document.getElementById('cloud-cap-button').classList.remove('active');
		document.getElementById('add-to-admin-container').classList.remove('hidden');
		document.getElementById('admin-token-input-container').classList.add('hidden');
		document.getElementById('error-add-to-admin').classList.remove('hidden');
		document.getElementById('error-admin-panel').classList.add('hidden');
	}
}
function linkToken() {
	toggleLoader();
	const data = {
		group_token: document.getElementById('group-token').value,
		name: document.getElementById('dm-name').value
	};
	const jsonData = JSON.stringify(data);
	fetch(`${urlLocation}/dm/api/v3/link-token`, {
		method: 'POST',
		body: jsonData,
	})
		.then((response) => response.json())
		.then((result) => {
			if (result.errortxt) {
				toggleLoader();
				document.getElementById('error-add-to-admin').innerText = result.errortxt;
			} else {
				toggleLoader();
				document.getElementById('error-add-to-admin').innerText = '';
				hideModalAdminPanel();
				callTostSnackbar(`Застосунок додано до панелі адміністрування`);
			}
		})
		.catch(function (error) {
			callTostSnackbar(`Request failed: ${error}`);
		});
}
function getAdminToken() {
	if (document.getElementById('admin_token').value === "") {
		fetch(`${urlLocation}/dm/api/v3/admintoken`, {
			method: 'GET',
		})
			.then((response) => response.json())
			.then((result) => {
				if (result.errortxt) {
					document.getElementById('admin-token-input-container').classList.add('hidden');
					document.getElementById('error-admin-panel').innerText = result.errortxt;
				} else {
					document.getElementById('admin-token-input-container').classList.remove('hidden');
					document.getElementById('error-admin-panel').innerText = '';
					document.getElementById('admin_token').value = result.token;
				}
			})
			.catch(function (error) {
				callTostSnackbar(`Request failed: ${error}`);
			});
	} else {
		document.getElementById('admin-token-input-container').classList.remove('hidden');
		document.getElementById('error-admin-panel').innerText = '';
	}
}
function showModalAsk(actionName, buttonNode) {
	document.getElementById('modal-ask-before-action').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
	if (actionName.name === 'deleteDevice') {
		const parentNode = buttonNode.closest('.row');
		const modalDoc = document.getElementById('modal-ask-before-action');
		modalDoc.querySelector('.actionQuestion').innerHTML = `Видалити пристрій ${parentNode.querySelector('.device_name').innerText}?`;
	}
	document.querySelector('.approveActionButton').onclick = function () {
		buttonNode ? actionName(buttonNode) : actionName();
	};
}
function showModalAdminPanel() {
	document.getElementById('admin-panel-modal').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}
function hideModalAdminPanel() {
	document.getElementById('admin-panel-modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
	document.getElementById('error-admin-panel').innerText = '';
	document.getElementById('error-add-to-admin').innerText = '';
	document.getElementById('error-text-zip-logs').classList.add('hidden');
	document.getElementById('error-text-zip-logs').innerHTML = '';
}
function showModalHelpRequest() {
	document.getElementById('help-req-modal').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}
function hideModalHelpRequest() {
	document.getElementById('help-req-modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
	document.getElementById('error-help-req').classList.add('hidden');
	document.getElementById('error-help-req').innerHTML = '';
}
function showModalZipLogs() {
	document.getElementById('zip-logs-modal').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');
}
function hideModalZipLogs() {
	document.getElementById('zip-logs-modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');
	document.getElementById('error-text-zip-logs').classList.add('hidden');
	document.getElementById('error-text-zip-logs').innerHTML = '';
}
function validateZipLogs(checkbox) {
	if (checkbox.checked) {
		document.getElementById('log-date-from').disabled = true;
		document.getElementById('log-date-to').disabled = true;
	} else {
		document.getElementById('log-date-from').removeAttribute('disabled');
		document.getElementById('log-date-to').removeAttribute('disabled');
	}
}
function goToLogs() {
	window.location = `${urlLocation}/dm/vchasno-kasa/logs.html`;
}
function goToSettings() {
	window.location = `${urlLocation}/dm/vchasno-kasa/settings.html`;
}
function showModalCurrentDayLogs() {
	document.getElementById('current-day-logs-modal').classList.remove('hidden');
	document.getElementById('overlay').classList.remove('hidden');

	fetchDayLogs(true);
}
function hideModalCurrentDayLogs() {
	document.getElementById('current-day-logs-modal').classList.add('hidden');
	document.getElementById('overlay').classList.add('hidden');

	logsError.classList.add('hidden');
	logsError.innerHTML = '';
}
function fetchDayLogs(isInitialLoad = false) {
	fetch(isInitialLoad
		? `${urlLocation}/dm/logfilepart?length=${logsSize}`
		: `${urlLocation}/dm/logfilepart?length=${logsSize}&offset=${logsOffset}`
	)
		.then(parseLog)
		.then(log => writeLogToPage(log, isInitialLoad))
		.catch(() => {
			logsError.classList.remove('hidden');
			logsError.innerText = 'При завантаженні логів сталася помилка';
		});
}
function parseLog(response) {
	const logsOffsetResponseHeader = response.headers.get('X-Log-Offset');
	const logsOffsetNumber = Number.parseFloat(logsOffsetResponseHeader);

	if (logsOffsetNumber === 0) stopFetchingLogs = true;

	if (logsOffsetNumber >= 64000) {
		logsOffset = logsOffsetNumber - 64000;
	} else {
		logsOffset = 0;
		logsSize = logsOffsetNumber;
	}

	return response.text();
}
function writeLogToPage(log, isInitialLoad) {
	const logDiv = document.createElement('div');
	logDiv.innerText = `--------------------------------------------------------------------------------------\n${log}`;

	if (isInitialLoad) {
		logsContainer.innerHTML = '';
	}

	logsContainer.insertAdjacentElement('afterbegin', logDiv);

	if (isInitialLoad) {
		logsContainer.scrollTop = logsContainer.scrollHeight;
	} else {
		logsContainer.scrollTop = logsContainer.scrollTop + logDiv.offsetHeight;
	}

	logsContainer.classList.remove('no-scroll');
}
document.getElementById('log-date-from').onclick = function (e) {
	e.preventDefault();
	e.cancelBubble = true;
	this.select();
	_Calendar.lcs(this);
};
document.getElementById('log-date-to').onclick = function (e) {
	e.preventDefault();
	e.cancelBubble = true;
	this.select();
	_Calendar.lcs(this);
};
document.zipLogs.onsubmit = function (e) {
	e.preventDefault();
	toggleLoader();
	let zip_logs_data = new FormData(this);
	let object = {};
	let buttonNode = this.querySelector('.modal-footer button');
	let contentType;
	zip_logs_data.forEach((value, key) => {
		object[key] = value;
	});
	if (object.all_logs) {
		object.date_begin = '';
		object.date_end = '';
	}
	buttonNode.innerText = 'Завантаження...';
	buttonNode.disabled = true;
	fetch(
		`${urlLocation}/${apiUrl}ziplogs?date_begin=${object.date_begin}&date_end=${object.date_end}`,
		{
			method: 'GET',
		}
	)
		.then((response) => {
			contentType = response.headers.get('Content-Type');
			if (response.ok && contentType.includes('application/zip')) {
				return response.blob(); // Convert response to Blob
			} else if (contentType && contentType.includes('application/json')) {
				return response.json();
			} else if (contentType && contentType.includes('text/html')) {
				return response.text();
			} else {
				throw "Невідома помилка при завантаженні логів";
			}
		})
		.then((data) => {
			if (typeof data === 'string') {
				throw data;
			} else {
				if (contentType.includes('application/json')) {
					throw data.errortxt;
				} else {
					let a = document.createElement('a');
					let url = URL.createObjectURL(data);
					a.href = url;
					if (object.all_logs) {
						a.download = 'All_EDM_Logs.zip'; // Set the desired file name
					} else {
						a.download = object.date_begin + '_' + object.date_end + '_EDM_Logs.zip';
					}

					document.body.appendChild(a);
					a.click();
					document.body.removeChild(a);
					toggleLoader();
					buttonNode.innerText = 'Завантажити';
					buttonNode.removeAttribute('disabled');
					callTostSnackbar('Логи завантажено');
					hideModalZipLogs();
				}
			}
		})
		.catch(function (error) {
			toggleLoader();
			document
				.getElementById('error-text-zip-logs')
				.classList.remove('hidden');
			document.getElementById('error-text-zip-logs').innerHTML = `Помилка: ${error}`;
			buttonNode.innerText = 'Завантажити';
			buttonNode.disabled = false;
		});
};
(function () {
	document.getElementById('log-date-to').value = _Calendar.addnull(
		_Calendar.now.getDate(),
		_Calendar.now.getMonth() + 1,
		_Calendar.now.getFullYear()
	);
	document.getElementById('log-date-from').value = _Calendar.addnull(
		_Calendar.now.getDate(),
		_Calendar.now.getMonth() + 1,
		_Calendar.now.getFullYear()
	);
})();

document.getElementById('log-date-to').onkeypress = (e) => {
	e.preventDefault();
};
document.getElementById('log-date-from').onkeypress = (e) => {
	e.preventDefault();
};
function check(evt) {
	if (!evt) evt = event;
	if (evt.ctrlKey && (evt.keyCode == 86 || evt.keyCode == 118)) {
		return true;
	} else {
		return true;
	}
}
document.addEventListener('DOMContentLoaded', function (event) {
	getDeviceList();

	logsContainer.addEventListener('scroll', () => {
		if (logsContainer.scrollTop === 0 && !stopFetchingLogs) {
			logsContainer.classList.add('no-scroll');
			fetchDayLogs();
		}
	});

	logsRefreshButton.addEventListener('click', () => {
		logsSize = DEFAULT_LOGS_SIZE;
		stopFetchingLogs = false;

		fetchDayLogs(true);
	});
});
function copyToClipboard(input_id) {

		var copyText = document.getElementById(input_id);

		copyText.select();
		copyText.setSelectionRange(0, 99999); // For mobile devices

		navigator.clipboard.writeText(copyText.value);

		// Alert the copied text
		callTostSnackbar("Ідентифікатор скопійовано");
}

function sendHelpRequest() {
	toggleLoader();
	const data = {
		message: document.getElementById('help-req-message').value,
		contacts: document.getElementById('help-req-contacts').value,
	};
	const json = JSON.stringify(data);
	fetch(`${urlLocation}/dm/api/v3/support-req`, {
		method: 'POST',
		body: json,
	})
		.then((response) => response.json())
		.then((result) => {
			toggleLoader();
			if (result.res !== 0) {
				document.getElementById('error-help-req').classList.remove('hidden');
				document.getElementById('error-help-req').innerHTML =
					result.errortxt;

			} else {
				hideModalHelpRequest()
				callTostSnackbar('Запит про допомогу успішно відправлено');
			}
		})
		.catch(function (error) {
			toggleLoader();
			callTostSnackbar(`Request failed: ${error}`);
		});
}